/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.constant.agent.FieldTypeEnum;
import kd.ai.gai.core.domain.dto.agent.Entity;
import kd.ai.gai.core.domain.dto.agent.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BigIntProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import org.apache.commons.lang3.StringUtils;

public class EntityMetaService {
    private static final Log logger = LogFactory.getLog(EntityMetaService.class);

    private static boolean canShow(IDataEntityProperty dp) {
        return !(dp instanceof DynamicLocaleProperty) && StringUtils.isNotEmpty((CharSequence)dp.getAlias());
    }

    private static String getDisplayName(IDataEntityProperty dp) {
        LocaleString displayName = dp.getDisplayName();
        if (displayName != null) {
            return displayName.getLocaleValue();
        }
        return dp.getName();
    }

    private static String getParentEntityId(IDataEntityType dataEntityType) {
        String parentId = "";
        while (dataEntityType != null) {
            String pid = dataEntityType.getName();
            parentId = StringUtils.isEmpty((CharSequence)parentId) ? pid : String.format("%s.%s", pid, parentId);
            dataEntityType = dataEntityType.getParent();
        }
        parentId = !StringUtils.contains((CharSequence)parentId, (CharSequence)".") ? "" : parentId.substring(parentId.indexOf(46) + 1);
        return parentId;
    }

    private static void getEntityFieldListMap(Map<String, EntityType> allEntities, String entityName, String entityDisplayName, DataEntityPropertyCollection properties, Map<String, List<Field>> entityFieldListMap) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        EntityType entityType = allEntities.get(entityName);
        String primaryFieldName = entityType.getPrimaryKey().getName();
        if (entityType instanceof SubEntryType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5b50\u5355\u636e\u4f53");
            String parentName = entityType.getParent().getName();
            primaryFieldName = String.format("%s.%s.%s", parentName, entityName, primaryFieldName);
        } else if (entityType instanceof EntryType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u4f53");
            primaryFieldName = String.format("%s.%s", entityName, primaryFieldName);
        } else if (entityType instanceof BillEntityType) {
            logger.info("#####" + entityType.getName() + "\u662f\u5355\u636e\u5934");
        }
        for (IDataEntityProperty dp : properties) {
            String parentEntityId = EntityMetaService.getParentEntityId(dp.getParent());
            if (dp instanceof EntryProp) {
                EntryProp entry = (EntryProp)dp;
                DynamicObjectType dot = entry.getDynamicCollectionItemPropertyType();
                DataEntityPropertyCollection entryProperties = dot.getProperties();
                String displayName = "";
                if (entry.getDisplayName() != null) {
                    displayName = entry.getDisplayName().getLocaleValue();
                }
                EntityMetaService.getEntityFieldListMap(allEntities, entry.getName(), displayName, entryProperties, entityFieldListMap);
                continue;
            }
            if (!EntityMetaService.canShow(dp)) continue;
            String mainKey = dp.getName();
            String pkName = "";
            if (dp.getParent() != null && dp.getParent().getPrimaryKey() != null) {
                pkName = dp.getParent().getPrimaryKey().getName();
            }
            String mainDisplayName = EntityMetaService.getDisplayName(dp);
            if (StringUtils.equalsIgnoreCase((CharSequence)pkName, (CharSequence)mainKey)) {
                if (StringUtils.isNotEmpty((CharSequence)entityDisplayName)) {
                    mainDisplayName = String.format("%s%s", entityDisplayName, mainDisplayName);
                }
                mainDisplayName = String.format("%s %s", mainDisplayName, "PK");
            }
            if (StringUtils.isNotEmpty((CharSequence)parentEntityId)) {
                mainKey = String.format("%s.%s", parentEntityId, mainKey);
            }
            if (dp instanceof BasedataProp) {
                MainEntityType dataEntityType;
                String baseEntityName;
                BasedataProp bd = (BasedataProp)dp;
                DynamicObjectType ref = bd.getDynamicComplexPropertyType();
                DataEntityPropertyCollection subPS = ref.getProperties();
                String baseEntityDisplayName = baseEntityName = bd.getBaseEntityId();
                if (StringUtils.isNotEmpty((CharSequence)baseEntityName) && (dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityName)) != null && dataEntityType.getDisplayName() != null) {
                    baseEntityDisplayName = dataEntityType.getDisplayName().getLocaleValue();
                }
                for (IDataEntityProperty subDP : subPS) {
                    if (!EntityMetaService.canShow(subDP)) continue;
                    String fieldType = EntityMetaService.getFieldTypeNameByDp(subDP);
                    String subKey = subDP.getName();
                    String subDisplayName = EntityMetaService.getDisplayName(subDP);
                    String subName = subDP.getAlias();
                    if (StringUtils.isEmpty((CharSequence)subName)) {
                        subName = subKey.replaceAll("\\.", "_");
                    }
                    Field field = new Field();
                    field.setDesc(String.format("%s.%s", mainDisplayName, subDisplayName));
                    field.setName(String.format("%s.%s", mainKey, subKey));
                    field.setType(fieldType);
                    if (field.getName() == null || field.getName().equals(field.getDesc()) || field.getName().matches("^.*(\\(|\uff08)(\u5c01\u5b58|\u5e9f\u5f03|\u5df2\u5e9f\u5f03|\u5df2\u5931\u6548)(\\)|\uff09)") || field.getName().matches("^.*(id|seq)$")) continue;
                    String[] primaryFieldNames = primaryFieldName.split("\\.");
                    String[] names = field.getName().split("\\.");
                    if (names.length > primaryFieldNames.length + 1 || names.length == primaryFieldNames.length + 1 && !subKey.equals("name")) continue;
                    fieldList.add(field);
                }
                continue;
            }
            String fieldType = EntityMetaService.getFieldTypeNameByDp(dp);
            Field field = new Field();
            field.setDesc(mainDisplayName);
            field.setType(fieldType);
            field.setName(mainKey);
            if (field.getName() == null || field.getName().equals(field.getDesc()) || field.getName().matches("^.*(\\(|\uff08)(\u5c01\u5b58|\u5e9f\u5f03|\u5df2\u5e9f\u5f03|\u5df2\u5931\u6548)(\\)|\uff09)") || field.getName().matches("^.*(id|seq)$")) continue;
            String[] primaryFieldNames = primaryFieldName.split("\\.");
            String[] names = field.getName().split("\\.");
            String subKey = "";
            if (names.length > 0) {
                subKey = names[names.length - 1];
            }
            if (names.length > primaryFieldNames.length + 1 || names.length == primaryFieldNames.length + 1 && !subKey.equals("name")) continue;
            fieldList.add(field);
        }
        entityFieldListMap.put(entityName, fieldList);
    }

    public static String getFieldTypeNameByDp(IDataEntityProperty dp) {
        String typeName = FieldTypeEnum.STRING.getId();
        if (dp instanceof BigIntProp || dp instanceof LongProp) {
            typeName = FieldTypeEnum.LONG.getId();
        } else if (dp instanceof IntegerProp) {
            typeName = FieldTypeEnum.INT.getId();
        } else if (dp instanceof DecimalProp) {
            typeName = FieldTypeEnum.DECIMAL.getId();
        } else if (dp instanceof DateProp) {
            typeName = FieldTypeEnum.DATE.getId();
        } else if (dp instanceof DateTimeProp) {
            typeName = FieldTypeEnum.DATETIME.getId();
        } else if (dp instanceof BooleanProp) {
            typeName = FieldTypeEnum.BOOLEAN.getId();
        }
        return typeName;
    }

    public static JSONArray entityMetaQuery(List<String> entityIdList) {
        JSONArray jsonArray = new JSONArray();
        if (entityIdList == null) {
            return null;
        }
        ArrayList<Entity> entityList = new ArrayList<Entity>(entityIdList.size());
        for (String entityId : entityIdList) {
            DynamicObjectCollection allBizAppList;
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            Entity entity = new Entity();
            entityList.add(entity);
            entity.setId(entityId);
            String displayName = "";
            HashMap<String, List<Field>> entityFieldListMap = new HashMap<String, List<Field>>();
            if (mainEntityType.getDisplayName() != null) {
                displayName = mainEntityType.getDisplayName().getLocaleValue();
                entity.setName(displayName);
            }
            if ((allBizAppList = BizAppServiceHelp.getAllBizApps()) != null && !allBizAppList.isEmpty()) {
                for (DynamicObject bizAppDo : allBizAppList) {
                    String cloudId = bizAppDo.getString("bizcloud");
                    String name = bizAppDo.getString("name");
                    String description = bizAppDo.getString("description");
                    String number = bizAppDo.getString("number");
                    if (!number.equalsIgnoreCase(mainEntityType.getAppId())) continue;
                    DynamicObject cloud = BizCloudServiceHelp.getBizCloudByID((String)cloudId);
                    entity.setFullName(cloud.getString("name") + "." + name + "." + displayName);
                    break;
                }
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            Map allEntities = mainEntityType.getAllEntities();
            EntityMetaService.getEntityFieldListMap(allEntities, mainEntityType.getName(), displayName, mainEntityType.getProperties(), entityFieldListMap);
            for (Map.Entry entry : entityFieldListMap.entrySet()) {
                String mapKey = (String)entry.getKey();
                List mapValue = (List)entry.getValue();
                fields.addAll(mapValue);
            }
            entity.setFields(fields);
            logger.info(String.format("appId:%s", mainEntityType.getAppId()));
        }
        for (Entity entity : entityList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("entity", (Object)entity);
            jsonArray.add((Object)jsonObject);
        }
        logger.info("###entitlyList###" + jsonArray.toJSONString());
        return jsonArray;
    }

    public static JSONObject getEntityInfosByAppId(String bizAppId) {
        String bosEntityobject = "bos_entityobject";
        QFilter qFilter = new QFilter("bizappid.number", "=", (Object)bizAppId);
        JSONObject application = new JSONObject();
        QFilter[] qFilters = new QFilter[]{qFilter};
        String selectFields = "id,name,number,bizappid.name,bizappid.id,bizappid.number";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)bosEntityobject, (String)selectFields, (QFilter[])qFilters);
        JSONArray entities = new JSONArray();
        for (DynamicObject dynamicObject : dynamicObjects) {
            JSONObject entity = new JSONObject();
            String entityId = dynamicObject.getString("id");
            String entityName = dynamicObject.getString("name");
            entity.put("id", (Object)entityId);
            entity.put("name", (Object)entityName);
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)entityId);
            entity.put("desc", (Object)mainEntityType.getDisplayName());
            entities.add((Object)entity);
        }
        DynamicObjectCollection allBizAppList = BizAppServiceHelp.getAllBizApps();
        if (allBizAppList != null && !allBizAppList.isEmpty()) {
            for (DynamicObject bizAppDo : allBizAppList) {
                String name = bizAppDo.getString("name");
                String description = bizAppDo.getString("description");
                String cloudId = bizAppDo.getString("bizcloud");
                String number = bizAppDo.getString("number");
                if (!number.equalsIgnoreCase(bizAppId)) continue;
                DynamicObject cloud = BizCloudServiceHelp.getBizCloudByID((String)cloudId);
                application.put("id", (Object)number);
                application.put("name", (Object)name);
                application.put("fullname", (Object)(cloud.getString("name") + "." + name));
                break;
            }
        }
        application.put("entities", (Object)entities);
        return application;
    }

    public static JSONArray entityInfos(List<String> bizApps) {
        JSONArray jsonArray = new JSONArray();
        if (bizApps != null) {
            for (int i = 0; i < bizApps.size(); ++i) {
                JSONObject json = new JSONObject();
                JSONObject application = EntityMetaService.getEntityInfosByAppId(bizApps.get(i));
                json.put("application", (Object)application);
                jsonArray.add((Object)json);
            }
        }
        logger.info("###entityInfos###" + jsonArray.toJSONString());
        return jsonArray;
    }

    public static JSONArray getEntiyMetaInfos(JSONObject json) {
        JSONArray result = null;
        List params = null;
        String levelId = json.getString("levelId");
        int index = EntityInfos.parseIndex(levelId);
        JSONArray objects = json.getJSONArray("objectIds");
        if (index != 0) {
            params = JSONArray.parseArray((String)objects.toString(), String.class);
        }
        switch (index) {
            case 0: {
                result = EntityMetaService.cloudInfos();
                break;
            }
            case 1: {
                result = EntityMetaService.cloudApps(params);
                break;
            }
            case 2: {
                result = EntityMetaService.entityInfos(params);
                break;
            }
            case 3: {
                result = EntityMetaService.entityMetaQuery(params);
                break;
            }
            default: {
                logger.info("");
            }
        }
        return result;
    }

    public static JSONArray cloudApps(List<String> clouds) {
        JSONArray jsonArray = new JSONArray();
        if (clouds == null) {
            return null;
        }
        for (int i = 0; i < clouds.size(); ++i) {
            DynamicObject bizCloud = BizCloudServiceHelp.getBizCloudByID((String)clouds.get(i));
            String cloudName = bizCloud.getString("name");
            JSONObject cloudInfo = new JSONObject();
            cloudInfo.put("id", (Object)clouds.get(i));
            cloudInfo.put("name", (Object)cloudName);
            JSONObject cloud = new JSONObject();
            cloud.put("cloud", (Object)cloudInfo);
            jsonArray.add((Object)cloud);
            DynamicObjectCollection allBizAppList = BizAppServiceHelp.getAllBizAppsByCloudID((String)clouds.get(i));
            if (allBizAppList == null || allBizAppList.isEmpty()) continue;
            JSONArray applications = new JSONArray();
            cloudInfo.put("applications", (Object)applications);
            for (DynamicObject bizAppDo : allBizAppList) {
                JSONObject json = new JSONObject();
                String name = bizAppDo.getString("name");
                String description = bizAppDo.getString("description");
                String number = bizAppDo.getString("number");
                json.put("id", (Object)number);
                json.put("name", (Object)name);
                json.put("desc", (Object)description);
                applications.add((Object)json);
            }
        }
        logger.info("###cloudApps###" + jsonArray.toJSONString());
        return jsonArray;
    }

    public static JSONArray cloudInfos() {
        JSONArray jsonArray = new JSONArray();
        JSONObject cloud = new JSONObject();
        JSONArray clouds = new JSONArray();
        cloud.put("clouds", (Object)clouds);
        jsonArray.add((Object)cloud);
        DynamicObjectCollection allBizCloudList = BizCloudServiceHelp.getAllBizClouds();
        if (allBizCloudList != null && !allBizCloudList.isEmpty()) {
            for (DynamicObject bizCloud : allBizCloudList) {
                JSONObject json = new JSONObject();
                String cloudId = bizCloud.getString("id");
                String name = bizCloud.getString("name");
                json.put("id", (Object)cloudId);
                json.put("name", (Object)name);
                clouds.add((Object)json);
            }
        }
        logger.info("###cloudInfos###" + jsonArray.toJSONString());
        return jsonArray;
    }

    public static enum EntityInfos {
        clouds("0", "\u4e91\u4fe1\u606f", 0),
        apps("1", "\u5e94\u7528\u4fe1\u606f", 1),
        entities("2", "\u5b9e\u4f53\u4fe1\u606f", 2),
        fileds("3", "\u5b57\u6bb5\u4fe1\u606f", 3);

        private String level;
        private String name;
        private int index;

        private EntityInfos(String level, String name) {
            this.name = name;
            this.level = level;
        }

        private EntityInfos(String level, String name, int index) {
            this.level = level;
            this.name = name;
            this.index = index;
        }

        public String getLevel() {
            return this.level;
        }

        public String getName() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public static String parseName(String level) {
            String name = null;
            for (EntityInfos item : EntityInfos.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.getLevel(), (CharSequence)level)) continue;
                name = item.getName();
                break;
            }
            return name;
        }

        public static int parseIndex(String level) {
            int index = 0;
            for (EntityInfos item : EntityInfos.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.getLevel(), (CharSequence)level)) continue;
                index = item.getIndex();
                break;
            }
            return index;
        }

        public static boolean contains(String level) {
            boolean flag = false;
            for (EntityInfos item : EntityInfos.values()) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)item.getLevel(), (CharSequence)level)) continue;
                flag = true;
                break;
            }
            return flag;
        }
    }
}

