/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.agent.FileInfo;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.bos.cache.CacheFactory;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.session.GuestUtiils;
import kd.bos.session.SessionManager;
import kd.bos.util.RevProxyUtil;
import org.apache.commons.lang3.time.DateFormatUtils;

public class FileService {
    private static final Log log = LogFactory.getLog(FileService.class);
    private static final String KEY_ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String KEY_ENTITY = "gai_file";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInfo save(FileInfo fileInfo) {
        String fileName = fileInfo.getName();
        Long fileSize = fileInfo.getFileSize();
        String source = fileInfo.getSource();
        Long sourceId = fileInfo.getSourceId();
        String fileType = fileInfo.getFileType();
        String description = fileInfo.getDescription();
        String purpose = fileInfo.getPurpose();
        String fileUrl = fileInfo.getFileUrl();
        RequestContext rc = RequestContext.get();
        long orgId = rc.getOrgId();
        DynamicObject attachmentDo = BusinessDataServiceHelper.newDynamicObject((String)KEY_ENTITY);
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)attachmentDo.getDataEntityType().getName(), (DynamicObject)attachmentDo, null);
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRule, (DynamicObject)attachmentDo);
        long id = ID.genLongId();
        attachmentDo.set("id", (Object)id);
        attachmentDo.set("number", (Object)number);
        attachmentDo.set("name", (Object)fileName);
        attachmentDo.set("enable", (Object)EnableEnum.YES.getKeyStr());
        attachmentDo.set("filetype", (Object)fileType);
        attachmentDo.set("filesize", (Object)fileSize);
        attachmentDo.set("purpose", (Object)purpose);
        attachmentDo.set("source", (Object)source);
        attachmentDo.set("sourceid", (Object)sourceId);
        attachmentDo.set("org", (Object)orgId);
        attachmentDo.set("createorg", (Object)orgId);
        attachmentDo.set("useorg", (Object)orgId);
        attachmentDo.set("ctrlstrategy", (Object)"5");
        attachmentDo.set("creator", (Object)UserServiceHelper.getCurrentUser((String)"id"));
        attachmentDo.set("masterid", (Object)id);
        InputStream in = null;
        try {
            in = fileInfo.getInputStream();
            if (fileUrl != null && fileUrl.length() > 0) {
                if (in != null) {
                    FileService.safeClose(in);
                }
                in = CacheFactory.getCommonCacheFactory().getTempFileCache().getInputStream(fileUrl);
            }
            in.available();
            attachmentDo.set("filesize", (Object)fileSize);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{attachmentDo});
            BaseDataServiceHelper.baseDataAddnewHandler((DynamicObject)attachmentDo, (Long)orgId);
            boolean uploadSuccess = FileService.upload(attachmentDo, in, fileSize, fileName, description);
            if (uploadSuccess) {
                FileInfo fileInfo2 = fileInfo = FileService.queryFileUrl(id);
                return fileInfo2;
            }
        }
        catch (IOException e) {
            log.error("error:" + e.getMessage(), (Throwable)e);
            FileInfo fileInfo3 = null;
            return fileInfo3;
        }
        finally {
            if (in != null) {
                FileService.safeClose(in);
            }
        }
        return null;
    }

    public static void safeClose(InputStream fis) {
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String encryptHttpUrlSession(String url, int timeOut) {
        RequestContext rc = RequestContext.get();
        String visitorSessionid = GuestUtiils.getGuestUserSessionId();
        String value = visitorSessionid + "~~" + System.currentTimeMillis();
        Base64.Encoder encoder = Base64.getEncoder();
        try {
            String encodeValue = encoder.encodeToString(value.getBytes("UTF-8"));
            StringBuilder addition = new StringBuilder();
            addition.append(url).append(RevProxyUtil.getHttpParamCollectFlag((String)url));
            addition.append("kdedcba").append("=").append(URLEncoder.encode(encodeValue, "UTF-8"));
            String csrfTokenValue = SessionManager.getCSRFTokenValue((String)RequestContext.get().getGlobalSessionId());
            addition.append(String.format("&kd_cs_ticket=%s", csrfTokenValue));
            addition.append(String.format("&kdcdc=%s", rc.getAccountId()));
            return addition.toString();
        }
        catch (UnsupportedEncodingException var6) {
            return url;
        }
    }

    public static List<FileInfo> queryFileList(List<Long> fileIdList) {
        ArrayList<FileInfo> fileInfos = null;
        String selectFields = "id,name,number,filesize,filetype,purpose";
        QFilter qFilter = new QFilter("id", "in", fileIdList);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)KEY_ENTITY, (String)selectFields, (QFilter[])qFilters);
        if (dynamicObjects == null) {
            return fileInfos;
        }
        fileInfos = new ArrayList<FileInfo>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            FileInfo fileInfo = new FileInfo();
            String name = dynamicObject.getString("name");
            String number = dynamicObject.getString("number");
            Long fileSize = dynamicObject.getLong("filesize");
            String fileType = dynamicObject.getString("filetype");
            Long fileId = dynamicObject.getLong("id");
            List list = AttachmentServiceHelper.getAttachments((String)KEY_ENTITY, (Object)fileId, (String)KEY_ATTACHMENTPANELAP, (boolean)false);
            String previewUrl = null;
            String url = null;
            if (list.size() > 0) {
                url = (String)((Map)list.get(0)).get("url");
                url = FileService.encryptHttpUrlSession(url, 7200);
                if (("image/jpeg".equals(fileType) || "image/png".equals(fileType) || "application/pdf".equals(fileType) || "text/plain".equals(fileType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(fileType)) && (previewUrl = (String)((Map)list.get(0)).get("previewurl")) != null) {
                    previewUrl = FileService.encryptHttpUrlSession(previewUrl, 7200);
                }
            }
            fileInfo.setId(fileId);
            fileInfo.setName(name);
            fileInfo.setFileType(fileType);
            fileInfo.setPreviewUrl(previewUrl == null ? url : previewUrl);
            fileInfo.setFileUrl(url);
            fileInfo.setFileSize(fileSize);
            fileInfo.setNumber(number);
            fileInfos.add(fileInfo);
        }
        return fileInfos;
    }

    public static FileInfo queryFileUrl(Long fileId) {
        FileInfo fileInfo = null;
        String selectFields = "id,name,number,filesize,filetype,purpose";
        QFilter qFilter = new QFilter("id", "=", (Object)fileId);
        QFilter[] qFilters = new QFilter[]{qFilter};
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)KEY_ENTITY, (String)selectFields, (QFilter[])qFilters);
        if (dynamicObject == null) {
            return fileInfo;
        }
        fileInfo = new FileInfo();
        String name = dynamicObject.getString("name");
        String number = dynamicObject.getString("number");
        Long fileSize = dynamicObject.getLong("filesize");
        String fileType = dynamicObject.getString("filetype");
        List list = AttachmentServiceHelper.getAttachments((String)KEY_ENTITY, (Object)fileId, (String)KEY_ATTACHMENTPANELAP, (boolean)false);
        String previewUrl = null;
        String url = null;
        if (list.size() > 0) {
            url = (String)((Map)list.get(0)).get("url");
            url = FileService.encryptHttpUrlSession(url, 7200);
            if (("image/jpeg".equals(fileType) || "image/png".equals(fileType) || "application/pdf".equals(fileType) || "text/plain".equals(fileType) || "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(fileType)) && (previewUrl = (String)((Map)list.get(0)).get("previewurl")) != null) {
                previewUrl = FileService.encryptHttpUrlSession(previewUrl, 7200);
            }
        }
        fileInfo.setId(fileId);
        fileInfo.setName(name);
        fileInfo.setFileType(fileType);
        fileInfo.setPreviewUrl(previewUrl == null ? url : previewUrl);
        fileInfo.setFileUrl(url);
        fileInfo.setFileSize(fileSize);
        fileInfo.setNumber(number);
        return fileInfo;
    }

    private static boolean upload(DynamicObject attachmentDo, InputStream inputStream, Long size, String fileName, String desc) {
        RequestContext rc = RequestContext.get();
        boolean uploadSuccess = false;
        try {
            String today = DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMMdd");
            String uploadPath = String.format("%s/%s/%s/%s/%s", rc.getTenantId(), rc.getAccountId(), today, attachmentDo.getPkValue(), fileName);
            kd.bos.fileservice.FileService fs = FileServiceFactory.getAttachmentFileService();
            FileItem fi = new FileItem(fileName, uploadPath, inputStream);
            String path = fs.upload(fi);
            HashMap<String, Object> uploadFileMap = new HashMap<String, Object>();
            uploadFileMap.put("entityNum", attachmentDo.getDynamicObjectType().getName());
            uploadFileMap.put("billPkId", attachmentDo.get("id"));
            uploadFileMap.put("lastModified", KDDateUtils.now().getTime());
            uploadFileMap.put("name", fileName);
            uploadFileMap.put("url", uploadPath);
            uploadFileMap.put("size", size);
            uploadFileMap.put("description", desc);
            uploadFileMap.put("status", "success");
            ArrayList<HashMap<String, Object>> attachments = new ArrayList<HashMap<String, Object>>();
            attachments.add(uploadFileMap);
            AttachmentServiceHelper.upload((String)attachmentDo.getDynamicObjectType().getName(), (Object)attachmentDo.getPkValue(), (String)KEY_ATTACHMENTPANELAP, attachments);
            uploadSuccess = true;
        }
        catch (Exception e) {
            uploadSuccess = false;
            log.error("error:" + e.getMessage(), (Throwable)e);
        }
        return uploadSuccess;
    }
}

