/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.Map;
import kd.ai.gai.core.api.mservice.MserviceResultHelper;
import kd.ai.gai.core.domain.dto.agent.GptPrompt;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GPTPromptService {
    private static final Log logger = LogFactory.getLog(GPTPromptService.class);

    public static BaseResult syncCall(GptPrompt gptPrompt, String chatSessionId) {
        logger.info("\u540c\u6b65\u8c03\u7528GPT\u63d0\u793a\u8bcdRequest:{}", (Object)JSONObject.toJSONString((Object)gptPrompt));
        long promptId = gptPrompt.getPromptId();
        Context context = FlowCacheData.getContext(chatSessionId);
        if (Context.needCheckLicense(context)) {
            try {
                GPTLicenseHelper.checkLic(GaiFormIdEnum.GAI_PROMPT.getId(), promptId);
            }
            catch (KDBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return BaseResult.fail(e.getErrorCode().getMessage());
            }
        }
        String input = gptPrompt.getInput();
        Map<String, String> varParams = gptPrompt.getVarParams();
        Map<String, Object> result = GPTPromptService.syncCall(promptId, input, varParams, context);
        logger.info("\u540c\u6b65\u8c03\u7528GPT\u63d0\u793a\u8bcdResponse:{}", (Object)JSONObject.toJSONString(result));
        if (result != null) {
            String errCode = (String)result.get("errCode");
            String errMsg = (String)result.get("errMsg");
            Map data = (Map)result.get("data");
            JSONObject dataJo = new JSONObject();
            if (data != null) {
                dataJo.put("llmValue", data.get("llmValue"));
            }
            BaseResult br = new BaseResult(dataJo);
            br.setErrCode(errCode);
            br.setErrMsg(errMsg);
            return br;
        }
        return BaseResult.fail();
    }

    private static Map<String, Object> syncCall(long promptId, String input, Map<String, String> varParams, Context context) {
        String requestId = context.getChatSessionId();
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setUserInput(input);
        llmMessage.setPromptId(promptId);
        llmMessage.setRepoIdList(Collections.emptyList());
        llmMessage.setStream(Boolean.FALSE);
        llmMessage.setParamMap(varParams);
        llmMessage.setSync(Boolean.TRUE);
        Result result = HandlerFactory.runHandler(context, llmMessage);
        logger.info(String.format("\u3010GPT\u63d0\u793a\u3011\u540c\u6b65\u8c03\u7528-\u7ed3\u675f\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s,llm\u7ed3\u679c\uff1a%s", requestId, promptId, JSON.toJSONString((Object)result)));
        return MserviceResultHelper.build(requestId, result);
    }
}

