/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.agent.entity.AgentRequestBizParams;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;

public class GaiAgentLogService {
    private static final Log logger = LogFactory.getLog(GaiAgentLogService.class);
    public static final String GAILOG_PREFIX = "[GAILog] level:{} requestId:{} \n {}";
    public static int LOG_MAX_LENGTH = 5000;

    public static BaseResult agentMonitorLogSave(AgentRequestBizParams bizParams) {
        String logLevel = bizParams.getLevel();
        String logMsg = bizParams.getMsg();
        String requestId = bizParams.getRequestId();
        List<String> msgList = GaiAgentLogService.getMsgList(logMsg);
        switch (logLevel) {
            case "ERROR": {
                if (!logger.isErrorEnabled()) break;
                for (String msgItem : msgList) {
                    logger.error(GAILOG_PREFIX, new Object[]{logLevel, requestId, msgItem});
                }
                break;
            }
            case "WARN": {
                if (!logger.isWarnEnabled()) break;
                for (String msgItem : msgList) {
                    logger.warn(GAILOG_PREFIX, new Object[]{logLevel, requestId, msgItem});
                }
                break;
            }
            case "DEBUG": {
                if (!logger.isDebugEnabled()) break;
                for (String msgItem : msgList) {
                    logger.debug(GAILOG_PREFIX, new Object[]{logLevel, requestId, msgItem});
                }
                break;
            }
            case "INFO": {
                if (!logger.isInfoEnabled()) break;
                for (String msgItem : msgList) {
                    logger.info(GAILOG_PREFIX, new Object[]{logLevel, requestId, msgItem});
                }
                break;
            }
        }
        return new BaseResult(new JSONObject());
    }

    private static List<String> getMsgList(String msg) {
        ArrayList<String> msgList = new ArrayList<String>();
        if (msg != null) {
            if (msg.length() <= LOG_MAX_LENGTH) {
                msgList.add(msg);
            } else {
                String number = RandomStringUtils.randomNumeric((int)3);
                int index = 1;
                do {
                    if (msg != null && msg.length() > LOG_MAX_LENGTH) {
                        String item = msg.substring(0, LOG_MAX_LENGTH);
                        item = String.format("[\u7f16\u53f7%s-%s]%s", number, index, item);
                        msg = msg.substring(LOG_MAX_LENGTH);
                        msgList.add(item);
                    } else {
                        msg = String.format("[\u7f16\u53f7%s-%s]%s", number, index, msg);
                        msgList.add(msg);
                        msg = null;
                    }
                    ++index;
                } while (StringUtils.isNotEmpty((CharSequence)msg));
            }
        }
        return msgList;
    }
}

