/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.agent.entity.LLMTransferRequestBizParams;
import kd.ai.gai.core.agent.entity.ModelName;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.service.LlmServiceFactory;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class GaiLLMTransferService {
    private static Log logger = LogFactory.getLog(GaiLLMTransferService.class);

    public static BaseResult llmPromptRequest(LLMTransferRequestBizParams params) {
        String serviceNum = params.getLlm();
        Map serviceResult = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"getService", (Object[])new Object[]{serviceNum});
        String llmNumber = (String)serviceResult.get("llm");
        if (serviceNum.equals("AZURE_GPT_40")) {
            llmNumber = serviceNum;
        }
        LLM llm = LLM.parse(llmNumber);
        LlmService helper = LlmServiceFactory.getExecutor(llm, false);
        JSONObject llmParamJson = params.getLlmParam();
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("isEncrypt", "false");
        if (helper != null) {
            String llmStr = GaiLLMTransferService.paramHandle(llm, llmParamJson);
            logger.info("GaiLLMTransferService param:  {}", (Object)llmStr);
            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"syncService", (Object[])new Object[]{contextMap, serviceNum, llmStr});
            String content = "";
            String errorCode = (String)result.get("errorCode");
            if (Errors.OK.getCode().equals(errorCode)) {
                content = (String)result.get("result");
                logger.info("GaiLLMTransferService result: {}", (Object)content);
                return new BaseResult(content);
            }
            content = (String)result.get("message");
            logger.error("GaiLLMTransferService error: {}", (Object)content);
            return BaseResult.fail(content);
        }
        return BaseResult.fail("\u6682\u4e0d\u652f\u6301\u8be5\u6a21\u578b");
    }

    private static String paramHandle(LLM llm, JSONObject paramJson) {
        String number;
        String model = "";
        switch (number = llm.getNumber()) {
            case "MOONSHOT_V1_8K": {
                model = ModelName.MOONSHOT_V1_8K.getModelName();
                break;
            }
            case "MOONSHOT_V1_32K": {
                model = ModelName.MOONSHOT_V1_32K.getModelName();
                break;
            }
            case "MOONSHOT_V1_128K": {
                model = ModelName.MOONSHOT_V1_128K.getModelName();
            }
        }
        if (StringUtils.isNotEmpty((String)model)) {
            paramJson.put("model", (Object)model);
        }
        return paramJson.toJSONString();
    }
}

