/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.ChatItem;
import kd.ai.gai.core.domain.dto.agent.ApiChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.GaiMsgConfig;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.domain.dto.agent.MessageDTO;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.domain.dto.agent.annotations.BaseAnnotation;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.agent.EnableEnum;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.GaiTableEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.service.ChatHistoryService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.RunService;
import kd.ai.gai.core.trace.util.ThreadUtils;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.KDDateFormatUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class MessageService {
    private static final Log log = LogFactory.getLog(MessageService.class);

    public static boolean userMessageCancelled(Long userMessageId) {
        DynamicObject userMessageDo;
        return QueryServiceHelper.exists((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (Object)userMessageId) && StringUtils.equalsIgnoreCase((CharSequence)(userMessageDo = BusinessDataServiceHelper.loadSingle((Object)userMessageId, (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId())).getString("msgstatus"), (CharSequence)RunStepStatusEnum.CANCELLED.getId());
    }

    public static Message getLastUserMessage(String chatSessionId, Long runId) {
        DynamicObject[] messageDoArr;
        ChatSessionDTO chatSessionDTO = ChatService.getChatSession(chatSessionId);
        Message message = null;
        QFilter qFilter = new QFilter("sessionid", "=", (Object)Long.parseLong(chatSessionDTO.getSessionId())).and("type", "=", (Object)ChatMessageTypeEnum.USER.getId());
        if (runId != null) {
            qFilter.and("runid", "=", (Object)runId);
        }
        if ((messageDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (String)"id", (QFilter[])qFilter.toArray(), (String)"id desc", (int)1)) != null && messageDoArr.length > 0) {
            message = MessageService.getMessageById((Long)messageDoArr[0].getPkValue());
        }
        return message;
    }

    public static Message getMessageById(long messageId) {
        Message message = null;
        DynamicObject messageDo = BusinessDataServiceHelper.loadSingle((Object)messageId, (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId());
        if (messageDo != null) {
            message = new Message();
            message.setMessageId((Long)messageDo.getPkValue());
            message.setSkillId(messageDo.getLong("skillid"));
            message.setRunId(messageDo.getLong("runid"));
            DynamicObject creatorDo = messageDo.getDynamicObject("creatorid");
            message.setUserId(creatorDo != null ? (Long)creatorDo.getPkValue() : null);
            message.setSkillSrc(messageDo.getString("skillsrc"));
            message.setSkillType(messageDo.getString("skilltype"));
            message.setConfigTag(messageDo.getString("config_tag"));
            message.setRunStepId(messageDo.getLong("runstepid"));
            message.setContentTag(messageDo.getString("content_tag"));
            message.setSessionId(messageDo.getLong("sessionid"));
            message.setAssistantId(messageDo.getLong("assistantid"));
            message.setCreateTime(messageDo.getDate("createtime"));
            message.setType(messageDo.getLong("type"));
            message.setEnable(messageDo.getString("enable"));
            message.setMsgStatus(messageDo.getString("msgstatus"));
        }
        return message;
    }

    public static Message insertMessage(String chatSessionId, String content, String config, Skill skill, ChatMessageTypeEnum chatMessageType, EnableEnum enable) {
        Context context = FlowCacheData.getContext(chatSessionId);
        long assistantId = 0L;
        if (context.getAssistant() != null) {
            assistantId = context.getAssistant().getId();
        }
        Message message = MessageService.saveMessageInfo(chatSessionId, 0L, assistantId, chatMessageType, content, config, enable, skill);
        return message;
    }

    private static Message saveMessageInfo(String chatSessionId, Long messageId, Long assistantId, ChatMessageTypeEnum chatMessageTypeEnum, String contentTag, String configTag, EnableEnum enableEnum, Skill skill) {
        Message message = new Message();
        ChatSessionDTO chatSessionDTO = ChatService.getChatSession(chatSessionId);
        if (chatSessionDTO == null) {
            chatSessionDTO = ChatService.saveChatSession(chatSessionId, contentTag, assistantId, enableEnum);
        }
        if (chatSessionDTO != null) {
            message.setSessionId(Long.parseLong(chatSessionDTO.getSessionId()));
            String userId = chatSessionDTO.getUserId();
            message.setUserId(StringUtils.isNotEmpty((CharSequence)userId) ? Long.parseLong(userId) : 0L);
        }
        DynamicObject chatMessageDo = null;
        if (messageId != null && messageId > 0L && (chatMessageDo = BusinessDataServiceHelper.loadSingle((Object)messageId, (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId())) != null) {
            message.setMessageId(messageId);
            message.setCreateTime(KDDateUtils.now());
        }
        message.setEnable(enableEnum.getKeyStr());
        message.setType(chatMessageTypeEnum.getId());
        message.setContentTag(contentTag);
        message.setAssistantId(assistantId);
        message.setConfigTag(configTag);
        if (skill != null) {
            message.setSkillId(StringUtils.isNotEmpty((CharSequence)skill.getId()) ? Long.valueOf(Long.parseLong(skill.getId())) : null);
            message.setSkillType(skill.getType() != null ? skill.getType().name() : null);
            message.setSkillSrc(skill.getSkillSrc() != null ? skill.getSkillSrc().getId() : null);
        }
        message = MessageService.saveMessage(chatSessionId, message);
        return message;
    }

    public static MessageConfig getMessageConfig(Message userMessage) {
        String configTag = userMessage.getConfigTag();
        if (StringUtils.isNotEmpty((CharSequence)configTag)) {
            return (MessageConfig)JSONObject.parseObject((String)configTag, MessageConfig.class);
        }
        return new MessageConfig();
    }

    public static Message saveMessage(String chatSessionId, Message message) {
        Run run;
        Long runId = message.getRunId();
        if (runId != null && runId > 0L && MessageService.userMessageCancelled((run = RunService.getRunById(message.getRunId())).getMessageId())) {
            log.info("user message cancelled : {}", (Object)run.getMessageId());
            return message;
        }
        Context context = FlowCacheData.getContext(chatSessionId);
        DynamicObject chatMessageDo = null;
        Long messageId = message.getMessageId();
        if (messageId != null && messageId > 0L) {
            chatMessageDo = BusinessDataServiceHelper.loadSingle((Object)messageId, (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId());
        }
        if (chatMessageDo == null) {
            chatMessageDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId());
            long id = ID.genLongId();
            chatMessageDo.set("id", (Object)id);
            if ((long)message.getType().intValue() == ChatMessageTypeEnum.USER.getId()) {
                runId = ID.genLongId();
                message.setRunId(runId);
                Run run2 = new Run();
                run2.setSessionId(message.getSessionId());
                run2.setMessageId(id);
                run2.setStartedAt(KDDateUtils.now());
                run2.setRunStatus(RunStepStatusEnum.IN_PROGRESS.getId());
                run2.setRunId(runId);
                RunService.saveRun(run2);
            }
        }
        if (message.getAssistantId() != null && message.getAssistantId() > 0L) {
            chatMessageDo.set("assistantid", (Object)message.getAssistantId());
        }
        if (message.getRunId() != null && message.getRunId() > 0L) {
            chatMessageDo.set("runid", (Object)message.getRunId());
        }
        if (message.getType() != null) {
            chatMessageDo.set("type", (Object)message.getType());
        }
        if (message.getSessionId() != null && message.getSessionId() > 0L) {
            chatMessageDo.set("sessionid", (Object)message.getSessionId());
        }
        if (message.getRunStepId() != null && message.getRunStepId() > 0L) {
            chatMessageDo.set("runstepid", (Object)message.getRunStepId());
        }
        if (message.getConfigTag() != null && StringUtils.isNotEmpty((CharSequence)message.getConfigTag())) {
            chatMessageDo.set("config_tag", (Object)message.getConfigTag());
        }
        chatMessageDo.set("enable", (Object)message.getEnable());
        if (message.getContentTag() != null && StringUtils.isNotEmpty((CharSequence)message.getContentTag())) {
            String contentTag = message.getContentTag();
            contentTag = AnnotationService.parseTagAndAppendChatSessionId(contentTag, chatSessionId, message.getSessionId());
            chatMessageDo.set("content_tag", (Object)contentTag);
            message.setContentTag(contentTag);
            GaiMsgConfig gaiMsgConfig = AnnotationService.parseGaiMsgConfig(contentTag);
            if (gaiMsgConfig != null && !gaiMsgConfig.getNeedPushMsg().booleanValue()) {
                chatMessageDo.set("enable", (Object)EnableEnum.NO.getKeyStr());
            }
        }
        if (message.getSkillId() != null && message.getSkillId() > 0L) {
            chatMessageDo.set("skillid", (Object)message.getSkillId());
        }
        if (message.getSkillType() != null && StringUtils.isNotEmpty((CharSequence)message.getSkillType())) {
            chatMessageDo.set("skilltype", (Object)message.getSkillType());
        }
        if (message.getSkillSrc() != null && StringUtils.isNotEmpty((CharSequence)message.getSkillSrc())) {
            chatMessageDo.set("skillsrc", (Object)message.getSkillSrc());
        }
        MessageService.fillSkillInfoForAssistantMessage(message, chatMessageDo, context);
        chatMessageDo.set("creatorid", (Object)message.getUserId());
        chatMessageDo.set("createtime", (Object)KDDateUtils.now().getTime());
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chatMessageDo});
        if (saveObjs != null && saveObjs.length > 0) {
            message.setMessageId((Long)chatMessageDo.getPkValue());
            log.info("saveMessage messageId:{}", (Object)message.getMessageId());
            message.setCreateTime(chatMessageDo.getDate("createtime"));
            MessageService.updateMessageIdToRunStep(message);
            if (message.getType().longValue() == ChatMessageTypeEnum.ASSISTANT.getId().longValue()) {
                MessageService.updateUserMessage2Completed(chatSessionId);
            }
            DynamicObject finalChatMessageDo = chatMessageDo;
            ThreadUtils.execute(() -> {
                MessageService.updateLastMessageTime(finalChatMessageDo);
                MessageService.saveChatItem(chatSessionId, finalChatMessageDo);
            });
            log.info("save success size: {}", (Object)saveObjs.length);
        } else {
            log.info("sync fail.");
        }
        return message;
    }

    private static void fillSkillInfoForAssistantMessage(Message message, DynamicObject chatMessageDo, Context context) {
        if (message.getType().longValue() == ChatMessageTypeEnum.ASSISTANT.getId().longValue() || message.getType().longValue() == ChatMessageTypeEnum.RUNSTEP.getId().longValue()) {
            Long userMessageId;
            DynamicObject userMessageDo;
            HashSet<Long> runIdSet = new HashSet<Long>(1);
            runIdSet.add(message.getRunId());
            Map<Long, Run> idRunMap = RunService.getIdRunMap(runIdSet);
            Run run = idRunMap.get(message.getRunId());
            if (run != null && (userMessageDo = BusinessDataServiceHelper.loadSingle((Object)(userMessageId = run.getMessageId()), (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId())) != null) {
                Long skillId;
                Skill skill = context.getCurrentSkill();
                if (skill != null) {
                    chatMessageDo.set("skillid", StringUtils.isNotEmpty((CharSequence)skill.getId()) ? Long.valueOf(Long.parseLong(skill.getId())) : null);
                    chatMessageDo.set("skilltype", skill.getType() != null ? skill.getType().name() : null);
                    chatMessageDo.set("skillsrc", skill.getSkillSrc() != null ? skill.getSkillSrc().getId() : null);
                }
                if ((skillId = Long.valueOf(userMessageDo.getLong("skillid"))) != null && skillId > 0L) {
                    chatMessageDo.set("skillid", (Object)userMessageDo.getLong("skillid"));
                    chatMessageDo.set("skilltype", (Object)userMessageDo.getString("skilltype"));
                    chatMessageDo.set("skillsrc", (Object)userMessageDo.getString("skillsrc"));
                }
                chatMessageDo.set("assistantid", (Object)userMessageDo.getLong("assistantid"));
                DynamicObject creatorDo = userMessageDo.getDynamicObject("creatorid");
                chatMessageDo.set("creatorid", creatorDo != null ? creatorDo.getPkValue() : null);
            }
        }
    }

    private static void updateMessageIdToRunStep(Message message) {
        long messageId = message.getMessageId();
        if (message.getType().longValue() == ChatMessageTypeEnum.RUNSTEP.getId().longValue()) {
            log.info("update messageId:{} to RunStep:{}", (Object)messageId, (Object)message.getRunStepId());
            int updateCount = DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)String.format("update %s set fstepchatitemid = ? where fentryid = ?", GaiTableEnum.T_GAI_RUN_STEP_ENTRY.getId()), (Object[])new Object[]{messageId, message.getRunStepId()});
            log.info("update messageId:{} to RunStep:{} -- updateCount:{}", new Object[]{messageId, message.getRunStepId(), updateCount});
        }
    }

    private static void updateLastMessageTime(DynamicObject chatMessageDo) {
        DynamicObject chatSessionDo = BusinessDataServiceHelper.loadSingle((Object)chatMessageDo.getLong("sessionid"), (String)GaiFormIdEnum.GAI_CHAT_SESSION.getId());
        if (chatSessionDo != null) {
            Date lastMessageTime = chatMessageDo.getDate("createtime");
            chatSessionDo.set("lastmessagetime", (Object)(lastMessageTime != null ? lastMessageTime : KDDateUtils.now()));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{chatSessionDo});
        }
    }

    private static void saveChatItem(String chatSessionId, DynamicObject assistantMessageDo) {
        DynamicObject userMessageDo;
        long runId;
        long type = assistantMessageDo.getLong("type");
        if (type == ChatMessageTypeEnum.ASSISTANT.getId() && (runId = assistantMessageDo.getLong("runid")) > 0L && (userMessageDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (QFilter[])new QFilter("runid", "=", (Object)runId).and("type", "=", (Object)ChatMessageTypeEnum.USER.getId()).toArray())) != null) {
            ChatHistoryService.save(chatSessionId, 0L, Collections.singletonList(new ChatItem(ChatMessageTypeEnum.USER.getId().intValue(), userMessageDo.getString("content_tag"))));
            ChatHistoryService.save(chatSessionId, 0L, Collections.singletonList(new ChatItem(ChatMessageTypeEnum.ASSISTANT.getId().intValue(), assistantMessageDo.getString("content_tag"))));
        }
    }

    public static List<MessageDTO> getAllChatMessageList(Long sessionId) {
        List<MessageDTO> messageDTOList = new ArrayList<MessageDTO>();
        ChatSessionDTO chatSessionDTO = ChatService.getChatSession(sessionId);
        DynamicObject chatInfoDo = BusinessDataServiceHelper.loadSingle((String)"gai_chat_info", (QFilter[])new QFilter("chatSessionId", "=", (Object)chatSessionDTO.getId()).toArray());
        if (chatInfoDo != null) {
            DynamicObject[] chatItemDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_ITEM.getId(), (String)"id,chatinfoid,type,content_tag,time", (QFilter[])new QFilter("chatinfoid", "=", chatInfoDo.getPkValue()).and("type", "in", Arrays.asList(ChatMessageTypeEnum.USER.getId(), ChatMessageTypeEnum.ASSISTANT.getId())).toArray());
            messageDTOList = MessageService.transChatItemDTOList(chatItemDoArr);
        }
        return messageDTOList;
    }

    private static List<MessageDTO> transChatItemDTOList(DynamicObject[] chatItemDoArr) {
        int length = chatItemDoArr != null ? chatItemDoArr.length : 0;
        ArrayList<MessageDTO> messageDTOList = new ArrayList<MessageDTO>(length);
        if (chatItemDoArr != null && chatItemDoArr.length > 0) {
            for (DynamicObject chatItemDo : chatItemDoArr) {
                String contentTag = chatItemDo.getString("content_tag");
                MessageDTO messageDTO = new MessageDTO();
                messageDTO.setMessageId((Long)chatItemDo.getPkValue());
                messageDTO.setType(chatItemDo.getLong("type"));
                messageDTO.setContentTag(contentTag);
                List<BaseAnnotation> annotations = AnnotationService.parseMessageAnnotations(contentTag);
                messageDTO.setAnnotations(annotations);
                long time = chatItemDo.getLong("time");
                if (time > 0L) {
                    messageDTO.setCreateTime(KDDateFormatUtils.getDateTimeFormat().format(new Date(time)));
                }
                messageDTOList.add(messageDTO);
            }
        }
        return messageDTOList;
    }

    public static void updateUserMessage2Cancelled(String chatSessionId) {
        MessageService.updateUserMessageStatus(chatSessionId, RunStepStatusEnum.CANCELLED);
    }

    public static void updateUserMessage2Completed(String chatSessionId) {
        MessageService.updateUserMessageStatus(chatSessionId, RunStepStatusEnum.COMPLETED);
    }

    private static void updateUserMessageStatus(String chatSessionId, RunStepStatusEnum runStepStatusEnum) {
        DynamicObject[] messageDoArr;
        ChatSessionDTO chatSessionDO = ChatService.getChatSession(chatSessionId);
        if (chatSessionDO != null && (messageDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (String)"id,sessionid,type", (QFilter[])new QFilter("sessionid", "=", (Object)Long.parseLong(chatSessionDO.getSessionId())).and("type", "=", (Object)ChatMessageTypeEnum.USER.getId()).toArray(), (String)"id desc", (int)1)) != null && messageDoArr.length > 0) {
            DynamicObject lastUserMessageDo = BusinessDataServiceHelper.loadSingle((Object)messageDoArr[0].getPkValue(), (String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId());
            lastUserMessageDo.set("msgstatus", (Object)runStepStatusEnum.getId());
            Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{lastUserMessageDo});
            if (saveObjs != null && saveObjs.length > 0) {
                log.info("updateUserMessageStatus success size: {}", (Object)saveObjs.length);
            } else {
                log.info("updateUserMessageStatus fail.");
            }
        }
    }

    public static ApiChatMessageDTO getAssistantMessage(long runId) {
        ApiChatMessageDTO apiChatMessageDTO = null;
        DynamicObject messageDo = BusinessDataServiceHelper.loadSingle((String)GaiFormIdEnum.GAI_CHAT_MESSAGE.getId(), (QFilter[])new QFilter("runid", "=", (Object)runId).and("type", "=", (Object)ChatMessageTypeEnum.ASSISTANT.getId()).toArray());
        if (messageDo != null) {
            Long sessionId = messageDo.getLong("sessionid");
            ChatSessionDTO chatSessionDTO = ChatService.getChatSession(sessionId);
            apiChatMessageDTO = new ApiChatMessageDTO();
            apiChatMessageDTO.setChatSessionId(chatSessionDTO.getId());
            apiChatMessageDTO.setSessionId(StrUtils.longAsString(sessionId));
            apiChatMessageDTO.setRunId(StrUtils.longAsString(runId));
            apiChatMessageDTO.setMessageId(StrUtils.longAsString((Long)messageDo.getPkValue()));
            apiChatMessageDTO.setMessage(messageDo.getString("content_tag"));
            apiChatMessageDTO.setType(messageDo.getLong("type"));
            apiChatMessageDTO.setCreateTime(KDDateFormatUtils.getDateTimeFormat().format(messageDo.getDate("createtime")));
            List<BaseAnnotation> annotationList = AnnotationService.parseMessageAnnotations(apiChatMessageDTO.getMessage());
            apiChatMessageDTO.setAnnotations(annotationList);
            DynamicObject runDo = BusinessDataServiceHelper.loadSingle((Object)runId, (String)GaiFormIdEnum.GAI_RUN.getId());
            if (runDo != null) {
                apiChatMessageDTO.setRunStatus(runDo.getString("runstatus"));
                String metadataTag = runDo.getString("metadata_tag");
                if (StringUtils.isNotEmpty((CharSequence)metadataTag)) {
                    JSONObject metadataTagJo = JSONObject.parseObject((String)metadataTag);
                    JSONArray traceJa = metadataTagJo.getJSONArray("trace");
                    apiChatMessageDTO.setTrace(traceJa != null ? traceJa : new JSONArray());
                }
            }
        }
        return apiChatMessageDTO;
    }
}

