/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.Map;
import kd.ai.gai.core.agent.tool.ToolConstant;
import kd.ai.gai.core.agent.tool.hander.OpenAPIAuthHandlerFactory;
import kd.ai.gai.core.agent.tool.model.APIKeyAuthConfig;
import kd.ai.gai.core.agent.tool.model.APIParam;
import kd.ai.gai.core.agent.tool.model.AuthConfig;
import kd.ai.gai.core.agent.tool.model.AuthType;
import kd.ai.gai.core.agent.tool.model.CosmicAccessTokenAuthConfig;
import kd.ai.gai.core.agent.tool.model.NoAuthConfig;
import kd.ai.gai.core.agent.tool.model.OAuthCredentialsConfig;
import kd.ai.gai.core.agent.tool.model.OperationParam;
import kd.ai.gai.core.agent.tool.util.OpenAPIUtils;
import kd.ai.gai.core.domain.dto.agent.AgentTool;
import kd.ai.gai.core.domain.dto.agent.ThirdOpenAPI;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.service.agent.AgentToolService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class OpenAPIService {
    private static final Log logger = LogFactory.getLog(OpenAPIService.class);

    public static BaseResult call(ThirdOpenAPI api) {
        logger.info("\u6267\u884c\u8c03\u7528\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177\u63a5\u53e3\u53c2\u6570:{}", (Object)JSONObject.toJSONString((Object)api));
        Long toolId = api.getToolId();
        if (toolId == null) {
            return BaseResult.fail("toolId\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JSONObject toolParams = api.getToolParams();
        if (toolParams == null) {
            return BaseResult.fail("toolParams\u53c2\u6570\u9519\u8bef\uff0c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String operationId = toolParams.getString("operationId");
        if (ObjectUtils.isEmpty((Object)operationId)) {
            return BaseResult.fail("toolParams\u53c2\u6570\u4e2doperationId\u53c2\u6570\u4e3a\u7a7a");
        }
        AgentTool agentTool = AgentToolService.getAgentTool(toolId);
        if (agentTool == null) {
            return BaseResult.fail(String.format("id\u4e3a%s\u7684\u5de5\u5177\u4e0d\u5b58\u5728", toolId));
        }
        String toolType = agentTool.getType();
        if (StringUtils.equalsIgnoreCase((CharSequence)toolType, (CharSequence)ToolConstant.ToolType.AGENT_PRESET.getType())) {
            return new BaseResult();
        }
        String toolConfig = agentTool.getConfig();
        String chatSessionId = api.getChatSessionId();
        logger.info("chatSessionId:{}", (Object)chatSessionId);
        if (!StringUtils.isEmpty((CharSequence)chatSessionId)) {
            FlowCacheData.restoreRequestContext(chatSessionId);
        }
        return OpenAPIService.call(toolConfig, toolParams, chatSessionId);
    }

    public static BaseResult callOpenAPITool(String toolConfig, JSONObject toolParams) {
        return OpenAPIService.call(toolConfig, toolParams, null);
    }

    private static BaseResult call(String toolConfig, JSONObject toolParams, String chatSessionId) {
        JSONObject swagger = JSONObject.parseObject((String)toolConfig);
        String at = swagger.getString("authtype");
        String swaggerConfig = swagger.getString("swaggerSchema");
        AuthType authType = AuthType.parseAuthType(at);
        AuthConfig config = null;
        if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.SERVICE.getType())) {
            APIKeyAuthConfig apiKeyAuthConfig;
            JSONObject serviceConfig = swagger.getJSONObject("serviceConfig");
            config = apiKeyAuthConfig = (APIKeyAuthConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)serviceConfig), APIKeyAuthConfig.class);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.OAUTH.getType())) {
            JSONObject oauthConfig = swagger.getJSONObject("oauthConfig");
            OAuthCredentialsConfig oAuthConfig = (OAuthCredentialsConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)oauthConfig), OAuthCredentialsConfig.class);
            config = oAuthConfig;
        } else if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.NO_AUTH.getType())) {
            config = new NoAuthConfig();
        } else if (StringUtils.equalsIgnoreCase((CharSequence)at, (CharSequence)AuthType.COSMIC_ACCESS_TOKEN.getType())) {
            JSONObject cosmicConfig = swagger.getJSONObject("cosmicAccessTokenConfig");
            CosmicAccessTokenAuthConfig caaa = (CosmicAccessTokenAuthConfig)JSONObject.parseObject((String)JSONObject.toJSONString((Object)cosmicConfig), CosmicAccessTokenAuthConfig.class);
            config = caaa;
        }
        logger.info("\u6267\u884c\u8c03\u7528\u7b2c\u4e09\u65b9OpenAPI\u5de5\u5177\u9274\u6743\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)config));
        Map<String, OperationParam> operationParamMap = OpenAPIUtils.parseOperationParam(swaggerConfig);
        String operationId = toolParams.getString("operationId");
        if (!operationParamMap.containsKey(operationId)) {
            BaseResult br = BaseResult.fail(String.format("\u5de5\u5177\u4e2d\u4e0d\u5b58\u5728\u540d\u4e3a%s\u7684\u63a5\u53e3", operationId));
            return br;
        }
        OperationParam operationParam = operationParamMap.get(operationId);
        JSONArray commonHeaders = swagger.getJSONArray("headerList");
        if (commonHeaders == null) {
            commonHeaders = new JSONArray();
        }
        if (!StringUtils.isEmpty((CharSequence)chatSessionId)) {
            OpenAPIService.buildChatSessionIdHeader(commonHeaders, chatSessionId);
            logger.info("build commonHeaders : {}", (Object)JSONObject.toJSONString((Object)commonHeaders));
        } else {
            logger.error("build commonHeaders,chatSessionId is empty");
        }
        toolParams.put("headers", (Object)commonHeaders);
        JSONArray bodyCommonParams = swagger.getJSONArray("bodyParamList");
        toolParams.put("bodyParamList", (Object)bodyCommonParams);
        APIParam param = new APIParam(toolParams, config, operationParam);
        Object handler = OpenAPIAuthHandlerFactory.getHandler(authType);
        return handler.call(param);
    }

    private static void buildChatSessionIdHeader(JSONArray commonHeaders, String chatSessionId) {
        JSONObject sidHeader = new JSONObject();
        JSONObject gaiParams = new JSONObject();
        gaiParams.put("chatSessionId", (Object)chatSessionId);
        Context context = FlowCacheData.getContext(chatSessionId);
        if (context != null) {
            gaiParams.put("PAGE_ID", (Object)context.getBizPageId());
            gaiParams.put("ROOT_PAGE_ID", (Object)context.getRootPageId());
        }
        sidHeader.put("key", (Object)"gaiParams");
        sidHeader.put("value", (Object)JSONObject.toJSONString((Object)gaiParams, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        commonHeaders.add((Object)sidHeader);
    }
}

