/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.SystemAgentEnum;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;
import kd.bos.url.UrlService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class PictureAvatarService {
    private static final Log log = LogFactory.getLog(PictureAvatarService.class);

    public static String getPictureByAgentName(String agentName) {
        SystemAgentEnum systemAgentEnum = SystemAgentEnum.fromAgentName(agentName);
        String picture = "/kingdee/gai/images/pc/agent/avatar/common_agent.png";
        if (systemAgentEnum != null) {
            picture = systemAgentEnum.getPicture();
        }
        String pictureUrl = PictureAvatarService.getDomainContextUrl() + picture;
        return PictureAvatarService.uploadPresetPicture2ImageServer(pictureUrl);
    }

    public static String getDomainContextUrl() {
        String host = UrlService.getDomainContextUrl();
        if (StringUtils.endsWithIgnoreCase((CharSequence)host, (CharSequence)"/")) {
            host = host.substring(0, host.length() - 1);
        }
        return host;
    }

    public static String uploadPresetPicture2ImageServer(String pictureUrl) {
        String pic = null;
        try {
            String host = PictureAvatarService.getDomainContextUrl();
            if (!StringUtils.startsWithIgnoreCase((CharSequence)pictureUrl, (CharSequence)"http")) {
                pictureUrl = String.format("%s%s", host, pictureUrl);
            }
            InputStream inputStream = new URL(pictureUrl).openStream();
            RequestContext rc = RequestContext.get();
            pictureUrl = pictureUrl.replace(host, "");
            FileService imageFileService = FileServiceFactory.getAttachmentFileService();
            String fileName = pictureUrl.substring(pictureUrl.lastIndexOf(47) + 1);
            String month = DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMM");
            String day = DateFormatUtils.format((Date)KDDateUtils.now(), (String)"yyyyMMdd");
            String path = String.format("/%s/%s/%s/%s/gai/%s/images%s", rc.getTenantId(), rc.getAccountId(), month, day, GaiFormIdEnum.GAI_AGENT.getId(), pictureUrl);
            FileItem fileItem = new FileItem(fileName, path, inputStream);
            pictureUrl = imageFileService.upload(fileItem);
            pic = String.format("%s%s%s", pictureUrl, "?kdcdc=", rc.getAccountId());
        }
        catch (IOException e) {
            log.error("error:" + e.getMessage(), (Throwable)e);
        }
        return pic;
    }
}

