/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.dto.agent.Retrieval;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class RetrievalService {
    private static final Log logger = LogFactory.getLog(RetrievalService.class);

    public static BaseResult retrieval(Retrieval retrieval, String chatSessionId) {
        logger.info(String.format("\u77e5\u8bc6\u5e93\u68c0\u7d22Request:%s", JSONObject.toJSONString((Object)retrieval)));
        List<Long> repoIdList = retrieval.getRepoIdList();
        Context context = FlowCacheData.getContext(chatSessionId);
        if (Context.needCheckLicense(context)) {
            try {
                GPTLicenseHelper.checkLic("ai_gai_reporag", 0L);
            }
            catch (KDBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
                return BaseResult.fail(e.getErrorCode().getMessage());
            }
        }
        final String text = retrieval.getText();
        int top = retrieval.getTop();
        final ArrayList chunks = new ArrayList();
        if (repoIdList != null && !repoIdList.isEmpty()) {
            repoIdList.stream().forEach(new Consumer<Long>(){

                @Override
                public void accept(Long repoId) {
                    RepoVO repoInfo = RepoService.getRepoInfo(repoId);
                    if (repoInfo != null) {
                        LLM embeddingModel = repoInfo.getLlm();
                        List<Long> repos = Collections.singletonList(repoId);
                        List<Chunk> list = EmbeddingServiceFactory.getExecutor(embeddingModel).search(repos, text);
                        logger.info(String.format("\u4ece\u77e5\u8bc6\u5e93{%s}\u4e2d\u5171\u68c0\u7d22\u5230{%s}\u4e2a\u6587\u672c\u5757", repoId, list.size()));
                        chunks.addAll(list);
                    }
                }
            });
        }
        List resChunks = chunks.size() <= top ? chunks : chunks.subList(0, top);
        logger.info(String.format("\u77e5\u8bc6\u5e93\u68c0\u7d22Response:%s", JSONObject.toJSONString(resChunks)));
        JSONObject dataJo = new JSONObject();
        dataJo.put("chunkList", (Object)RetrievalService.handlerResult(resChunks));
        return new BaseResult(dataJo);
    }

    private static JSONArray handlerResult(List<Chunk> resChunks) {
        JSONArray res = new JSONArray();
        if (resChunks != null && !resChunks.isEmpty()) {
            for (Chunk chunk : resChunks) {
                JSONObject ck = new JSONObject();
                ck.put("id", (Object)chunk.getId());
                ck.put("repositoryId", (Object)chunk.getRepositoryId());
                ck.put("fileId", (Object)chunk.getFileId());
                ck.put("page", (Object)chunk.getPage());
                ck.put("order", (Object)chunk.getOrder());
                ck.put("chunk", (Object)chunk.getChunk());
                res.add((Object)ck);
            }
        }
        return res;
    }
}

