/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.agent.ChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.GaiMsgConfig;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.domain.dto.agent.RunStep;
import kd.ai.gai.core.domain.dto.agent.RunStepMessage;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.enuz.ResultActionType;
import kd.ai.gai.core.enuz.agent.GaiFormIdEnum;
import kd.ai.gai.core.enuz.agent.RunStepStatusEnum;
import kd.ai.gai.core.service.WebSocketService;
import kd.ai.gai.core.service.agent.AnnotationService;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RunService {
    private static final Log log = LogFactory.getLog(RunService.class);

    public static Run saveRun(Run run) {
        Long runId = run.getRunId();
        DynamicObject runDo = BusinessDataServiceHelper.newDynamicObject((String)GaiFormIdEnum.GAI_RUN.getId());
        if (runId != null && runId > 0L) {
            if (MessageService.userMessageCancelled(run.getMessageId())) {
                log.info("user message cancelled : {}", (Object)run.getMessageId());
                return run;
            }
            boolean exists = QueryServiceHelper.exists((String)GaiFormIdEnum.GAI_RUN.getId(), (Object)runId);
            if (exists) {
                runDo = BusinessDataServiceHelper.loadSingle((Object)runId, (String)GaiFormIdEnum.GAI_RUN.getId());
            } else {
                runDo.set("id", (Object)runId);
            }
        }
        log.info("triggerAgentStart runId 03 : {}", (Object)runId);
        if (StringUtils.isNotEmpty((CharSequence)run.getRunStatus())) {
            runDo.set("runstatus", (Object)run.getRunStatus());
        }
        if (run.getSessionId() != null && run.getSessionId() > 0L) {
            runDo.set("sessionid", (Object)run.getSessionId());
        }
        if (run.getMessageId() != null && run.getMessageId() > 0L) {
            runDo.set("messageid", (Object)run.getMessageId());
        }
        if (run.getAssistantMessageId() != null && run.getAssistantMessageId() > 0L) {
            runDo.set("assistantmessageid", (Object)run.getAssistantMessageId());
        }
        if (StringUtils.isNotEmpty((CharSequence)run.getErrorMsgTag())) {
            runDo.set("errormsg_tag", (Object)run.getErrorMsgTag());
        }
        if (StringUtils.isNotEmpty((CharSequence)run.getErrorCode())) {
            runDo.set("errorcode", (Object)run.getErrorCode());
        }
        if (run.getExpiredAt() != null) {
            runDo.set("expiredat", (Object)run.getExpiredAt());
        }
        if (run.getStartedAt() != null) {
            runDo.set("startedat", (Object)run.getStartedAt());
        }
        if (run.getCancelledAt() != null) {
            runDo.set("cancelledat", (Object)run.getCancelledAt());
        }
        if (run.getFailedAt() != null) {
            runDo.set("failedat", (Object)run.getFailedAt());
        }
        if (run.getCompletedAt() != null) {
            runDo.set("completedat", (Object)run.getCompletedAt());
        }
        if (StringUtils.isNotEmpty((CharSequence)run.getToolIds())) {
            runDo.set("toolids", (Object)run.getToolIds());
        }
        if (StringUtils.isNotEmpty((CharSequence)run.getPromptIds())) {
            runDo.set("promptids", (Object)run.getPromptIds());
        }
        if (StringUtils.isNotEmpty((CharSequence)run.getProcessIds())) {
            runDo.set("processids", (Object)run.getProcessIds());
        }
        if (StringUtils.isNotEmpty((CharSequence)run.getFileIds())) {
            runDo.set("fileids", (Object)run.getFileIds());
        }
        if (StringUtils.isNotEmpty((CharSequence)run.getMetadataTag())) {
            runDo.set("metadata_tag", (Object)run.getMetadataTag());
        }
        if (StringUtils.isNotEmpty((CharSequence)run.getLlm())) {
            runDo.set("llm", (Object)run.getLlm());
        }
        if (run.getPromptTokens() != null) {
            runDo.set("prompttokens", (Object)run.getPromptTokens());
        }
        if (run.getCompletionTokens() != null) {
            runDo.set("completiontokens", (Object)run.getCompletionTokens());
        }
        RequestContext rc = RequestContext.get();
        runDo.set("creatorid", (Object)rc.getCurrUserId());
        DynamicObject[] saveObjs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{runDo});
        if (saveObjs != null && saveObjs.length > 0) {
            log.info("save success size: {}", (Object)saveObjs.length);
            run.setRunId((Long)runDo.getPkValue());
        } else {
            log.info("save fail.");
        }
        return run;
    }

    public static RunStep saveRunStep(Context context, RunStep runStep) {
        String chatSessionId = context.getChatSessionId();
        log.info("saveRunStep start ...{} - {}", (Object)chatSessionId, (Object)JSONObject.toJSONString((Object)runStep));
        Long runId = runStep.getRunId();
        if (runId == null || runId == 0L) {
            log.info("runId invaild : {}", (Object)runId);
            return null;
        }
        Run run = RunService.getRunById(runId);
        Message userMessage = MessageService.getMessageById(run.getMessageId());
        if (StringUtils.equalsIgnoreCase((CharSequence)userMessage.getMsgStatus(), (CharSequence)RunStepStatusEnum.CANCELLED.getId())) {
            log.info("user message cancelled : {}", (Object)run.getMessageId());
            return null;
        }
        Message runStepMessage = null;
        Long runStepId = runStep.getRunStepId();
        if (runStepId == null || runStepId == 0L) {
            runStepId = ID.genLongId();
            runStep.setRunStepId(runStepId);
            runStepMessage = runStep.getMessage();
            if (runStepMessage != null) {
                runStepMessage.setRunStepId(runStepId);
                runStepMessage.setEnable(userMessage.getEnable());
                runStepMessage = MessageService.saveMessage(chatSessionId, runStepMessage);
                runStep.setMessageId(runStepMessage.getMessageId());
                runStep.setMessage(runStepMessage);
            }
        }
        DynamicObject runDo = BusinessDataServiceHelper.loadSingle((Object)runId, (String)GaiFormIdEnum.GAI_RUN.getId());
        DynamicObjectCollection runStepDoc = runDo.getDynamicObjectCollection("gai_run_step_entry");
        DynamicObject runStepDo = null;
        int seq = 1;
        if (runStepDoc != null && runStepDoc.size() > 0) {
            seq = runStepDoc.size() + 1;
            for (DynamicObject stepDo : runStepDoc) {
                long stepId = (Long)stepDo.getPkValue();
                if (stepId != runStepId) continue;
                runStepDo = stepDo;
                break;
            }
        }
        if (runStepDo == null) {
            log.info("runStepDo == null");
            runStepDo = runStepDoc.addNew();
            runStep.setRunStepId(runStepId);
            runStepDo.set("id", (Object)runStepId);
            runStepDo.set("seq", (Object)seq++);
        }
        if (runStep.getMessageId() != null && runStep.getMessageId() > 0L) {
            runStepDo.set("stepchatitemid", (Object)runStep.getMessageId());
        }
        if (StringUtils.isNotEmpty((CharSequence)runStep.getType())) {
            runStepDo.set("type", (Object)runStep.getType());
        }
        if (StringUtils.isNotEmpty((CharSequence)runStep.getStepStatus())) {
            runStepDo.set("stepstatus", (Object)runStep.getStepStatus());
        }
        if (StringUtils.isNotEmpty((CharSequence)runStep.getStepDetailsTag())) {
            runStepDo.set("stepdetails_tag", (Object)runStep.getStepDetailsTag());
        }
        if (StringUtils.isNotEmpty((CharSequence)runStep.getStepErrorMsgTag())) {
            runStepDo.set("steperrormsg_tag", (Object)runStep.getStepErrorMsgTag());
        }
        if (StringUtils.isNotEmpty((CharSequence)runStep.getStepErrorCode())) {
            runStepDo.set("steperrorcode", (Object)runStep.getStepErrorCode());
        }
        if (runStep.getStepExpiredAt() != null) {
            runStepDo.set("stepexpiredat", (Object)runStep.getStepExpiredAt());
        }
        if (runStep.getStepStartedAt() != null) {
            runStepDo.set("stepstartedat", (Object)runStep.getStepStartedAt());
        }
        if (runStep.getStepCancelledAt() != null) {
            runStepDo.set("stepcancelledat", (Object)runStep.getStepCancelledAt());
        }
        if (runStep.getStepFailedAt() != null) {
            runStepDo.set("stepfailedat", (Object)runStep.getStepFailedAt());
        }
        if (runStep.getStepCompletedAt() != null) {
            runStepDo.set("stepcompletedat", (Object)runStep.getStepCompletedAt());
        }
        if (runStep.getStepPromptTokens() != null) {
            runStepDo.set("stepprompttokens", (Object)runStep.getStepPromptTokens());
        }
        if (runStep.getStepCompletionTokens() != null) {
            runStepDo.set("stepcompletiontokens", (Object)runStep.getStepCompletionTokens());
        }
        runDo.set("gai_run_step_entry", (Object)runStepDoc);
        Object[] saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{runDo});
        if (saveObjs != null && saveObjs.length > 0) {
            RunService.pushRunStepMessage(chatSessionId, context, runId, runStepDo, userMessage);
            log.info("save success size: {}", (Object)saveObjs.length);
        } else {
            log.info("save fail.");
        }
        return runStep;
    }

    private static void pushRunStepMessage(String chatSessionId, Context context, long runId, DynamicObject runStepDo, Message userMessage) {
        GaiMsgConfig gaiMsgConfig;
        MessageConfig messageConfig = MessageService.getMessageConfig(userMessage);
        if (!messageConfig.getNeedPushMsg().booleanValue()) {
            return;
        }
        String stepStatus = runStepDo.getString("stepstatus");
        RunStepMessage runStepMessage = new RunStepMessage();
        String stepType = runStepDo.getString("type");
        runStepMessage.setStepStatus(stepStatus);
        runStepMessage.setId(chatSessionId);
        runStepMessage.setStepType(stepType);
        runStepMessage.setStepTypeName(stepType);
        runStepMessage.setRunId(StrUtils.longAsString(runId));
        runStepMessage.setRunStepId(StrUtils.longAsString((Long)runStepDo.getPkValue()));
        runStepMessage.setTaskId(StrUtils.longAsString(runId));
        runStepMessage.setType(ChatMessageTypeEnum.RUNSTEP.getId());
        runStepMessage.setStream(Boolean.FALSE);
        runStepMessage.setId(chatSessionId);
        ChatMessageDTO chatMessageDTO = ChatService.getRunStepMessageByRunStepId(chatSessionId, (Long)runStepDo.getPkValue());
        String message = null;
        if (chatMessageDTO != null) {
            message = chatMessageDTO.getMessage();
            runStepMessage.setMessage(chatMessageDTO.getMessage());
            runStepMessage.setMessageId(chatMessageDTO.getMessageId());
            runStepMessage.setAnnotations(chatMessageDTO.getAnnotations());
        }
        if ((gaiMsgConfig = AnnotationService.parseGaiMsgConfig(message)) != null && !gaiMsgConfig.getNeedPushMsg().booleanValue()) {
            return;
        }
        WebSocketService.pushResult(null, context.getAssistantPageId(), context.getRootPageId(), context.getGlobalSessionId(), ResultActionType.runStepChat.name(), runStepMessage);
    }

    public static void expiredRunOrRunStep(String chatSessionId) {
        ChatSessionDTO chatSession = ChatService.getChatSession(chatSessionId);
        if (chatSession != null) {
            long sessionId = Long.parseLong(chatSession.getSessionId());
            DynamicObject[] runDoArr = BusinessDataServiceHelper.load((String)GaiFormIdEnum.GAI_RUN.getId(), (String)"id", (QFilter[])new QFilter("sessionid", "=", (Object)sessionId).and("runstatus", "=", (Object)RunStepStatusEnum.IN_PROGRESS.getId()).toArray());
            if (runDoArr != null && runDoArr.length > 0) {
                Context context = FlowCacheData.getContext(chatSessionId);
                for (DynamicObject runDo : runDoArr) {
                    Object[] saveObjs;
                    if (runDo == null) continue;
                    long runId = (Long)runDo.getPkValue();
                    runDo = BusinessDataServiceHelper.loadSingle((Object)runId, (String)GaiFormIdEnum.GAI_RUN.getId());
                    runDo.set("runstatus", (Object)RunStepStatusEnum.EXPIRED.getId());
                    DynamicObjectCollection runStepDoc = runDo.getDynamicObjectCollection("gai_run_step_entry");
                    ArrayList<DynamicObject> pushRunStepDoList = new ArrayList<DynamicObject>(1);
                    if (runStepDoc != null && runStepDoc.size() > 0) {
                        for (DynamicObject stepDo : runStepDoc) {
                            String stepStatus = stepDo.getString("stepstatus");
                            if (!StringUtils.equalsIgnoreCase((CharSequence)stepStatus, (CharSequence)RunStepStatusEnum.IN_PROGRESS.getId())) continue;
                            stepDo.set("stepstatus", (Object)RunStepStatusEnum.EXPIRED.getId());
                            pushRunStepDoList.add(stepDo);
                        }
                    }
                    if ((saveObjs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{runDo})) != null && saveObjs.length > 0) {
                        log.info("expiredRunOrRunStep sessionId:{} runId:{} success", (Object)sessionId, runDo.getPkValue());
                        Message userMessage = MessageService.getMessageById(runDo.getLong("messageid"));
                        if (!CollectionUtils.isNotEmpty(pushRunStepDoList)) continue;
                        for (DynamicObject runStepDo : pushRunStepDoList) {
                            RunService.pushRunStepMessage(chatSessionId, context, runId, runStepDo, userMessage);
                        }
                        continue;
                    }
                    log.info("expiredRunOrRunStep sessionId:{} runId:{} fail", (Object)sessionId, runDo.getPkValue());
                }
            }
        }
    }

    public static Map<Long, RunStep> getIdRunStepMap(Set<Long> runStepIdList) {
        Map<Long, RunStep> idRunStepMap = new HashMap<Long, RunStep>();
        if (CollectionUtils.isNotEmpty(runStepIdList)) {
            StringBuilder sql = new StringBuilder();
            sql.append("select fid,fentryid,fstepchatitemid,ftype,fstepstatus from t_gai_run_step_entry ");
            sql.append("where fentryid in (");
            sql.append(String.join((CharSequence)",", Collections.nCopies(runStepIdList.size(), "?")));
            sql.append(')');
            List runStepList = (List)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)sql.toString(), (Object[])runStepIdList.toArray(), rs -> {
                ArrayList<RunStep> runSteps = new ArrayList<RunStep>(runStepIdList.size());
                while (rs.next()) {
                    RunStep runStep = new RunStep();
                    runStep.setRunId(rs.getLong("fid"));
                    runStep.setRunStepId(rs.getLong("fentryid"));
                    runStep.setMessageId(rs.getLong("fstepchatitemid"));
                    runStep.setType(rs.getString("ftype"));
                    runStep.setStepStatus(rs.getString("fstepstatus"));
                    runSteps.add(runStep);
                }
                return runSteps;
            });
            if (CollectionUtils.isNotEmpty((Collection)runStepList)) {
                idRunStepMap = runStepList.stream().collect(Collectors.toMap(RunStep::getRunStepId, Function.identity()));
            }
        }
        return idRunStepMap;
    }

    public static Run getRunById(Long runId) {
        HashSet<Long> runIdSet = new HashSet<Long>(1);
        runIdSet.add(runId);
        Map<Long, Run> idRunMap = RunService.getIdRunMap(runIdSet);
        Run run = idRunMap.get(runId);
        return run;
    }

    public static Map<Long, Run> getIdRunMap(Set<Long> runIdList) {
        Map<Long, Run> idRunMap = new HashMap<Long, Run>();
        if (CollectionUtils.isNotEmpty(runIdList)) {
            StringBuilder sql = new StringBuilder();
            sql.append("select fid,frunstatus,fsessionid,fmessageid,fassistantmessageid,fmetadata_tag from t_gai_run ");
            sql.append("where fid in (");
            sql.append(String.join((CharSequence)",", Collections.nCopies(runIdList.size(), "?")));
            sql.append(')');
            List runList = (List)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)sql.toString(), (Object[])runIdList.toArray(), rs -> {
                ArrayList<Run> runs = new ArrayList<Run>(runIdList.size());
                while (rs.next()) {
                    Run run = new Run();
                    run.setRunId(rs.getLong("fid"));
                    run.setRunStatus(rs.getString("frunstatus"));
                    run.setSessionId(rs.getLong("fsessionid"));
                    run.setMessageId(rs.getLong("fmessageid"));
                    run.setAssistantMessageId(rs.getLong("fassistantmessageid"));
                    run.setMetadataTag(rs.getString("fmetadata_tag"));
                    runs.add(run);
                }
                return runs;
            });
            if (CollectionUtils.isNotEmpty((Collection)runList)) {
                idRunMap = runList.stream().collect(Collectors.toMap(Run::getRunId, Function.identity()));
            }
        }
        return idRunMap;
    }
}

