/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent.handler;

import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.api.websocket.query.WsRequestParams;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.service.agent.handler.AssistantDetailHandler;
import kd.ai.gai.core.service.agent.handler.FileDetailHandler;
import kd.ai.gai.core.service.agent.handler.FileMetadataSaveHandler;
import kd.ai.gai.core.service.agent.handler.IWsRequestHandler;
import kd.ai.gai.core.service.agent.handler.LlmCompletionHandler;
import kd.ai.gai.core.service.agent.handler.LogEventSaveHandler;
import kd.ai.gai.core.service.agent.handler.LogStepSaveHandler;
import kd.ai.gai.core.service.agent.handler.MonitorLogSaveHandler;
import kd.ai.gai.core.service.agent.handler.SessionMessageListAllHandler;
import kd.ai.gai.core.service.agent.handler.SessionMessageSaveHandler;
import kd.ai.gai.core.service.agent.handler.SessionRunSaveHandler;
import kd.ai.gai.core.service.agent.handler.SessionRunStepSaveHandler;
import kd.ai.gai.core.service.agent.handler.ToolCosmicActionHandler;
import kd.ai.gai.core.service.agent.handler.ToolDetailHandler;
import kd.ai.gai.core.service.agent.handler.ToolEntityMetadataiHandler;
import kd.ai.gai.core.service.agent.handler.ToolGptProcessHandler;
import kd.ai.gai.core.service.agent.handler.ToolGptPromptHandler;
import kd.ai.gai.core.service.agent.handler.ToolRetrievalHandler;
import kd.ai.gai.core.service.agent.handler.ToolThirdOpenApiHandler;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AgentHandlerFactory {
    private static final Log log = LogFactory.getLog(AgentHandlerFactory.class);
    private static final Map<String, Class<? extends IWsRequestHandler>> wsRequestHandlerMap = new HashMap<String, Class<? extends IWsRequestHandler>>();

    private AgentHandlerFactory() {
    }

    public static <T extends IWsRequestHandler> T getHandler(String requestType) {
        Class<? extends IWsRequestHandler> handlerType = wsRequestHandlerMap.get(requestType);
        if (handlerType == null) {
            throw new KDBizException(Errors.handlerNotExistedError(requestType), new Object[0]);
        }
        try {
            return (T)handlerType.newInstance();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new KDBizException(Errors.instanceHandlerError(e.getMessage()), new Object[0]);
        }
    }

    public static <T extends WsRequestParams> WsRequestParams runHandler(String chatSessionId, WsRequestParams wsRequestParams) {
        String requestType = wsRequestParams.getRequiredParams().getType();
        T handler = AgentHandlerFactory.getHandler(requestType);
        return handler.process(chatSessionId, wsRequestParams);
    }

    static {
        wsRequestHandlerMap.put("request.assistant.detail", AssistantDetailHandler.class);
        wsRequestHandlerMap.put("request.session.run.save", SessionRunSaveHandler.class);
        wsRequestHandlerMap.put("request.session.run.step.save", SessionRunStepSaveHandler.class);
        wsRequestHandlerMap.put("request.session.message.save", SessionMessageSaveHandler.class);
        wsRequestHandlerMap.put("request.session.message.list.all", SessionMessageListAllHandler.class);
        wsRequestHandlerMap.put("request.tool.detail", ToolDetailHandler.class);
        wsRequestHandlerMap.put("request.tool.retrieval", ToolRetrievalHandler.class);
        wsRequestHandlerMap.put("request.tool.gpt_prompt", ToolGptPromptHandler.class);
        wsRequestHandlerMap.put("request.tool.gpt_process", ToolGptProcessHandler.class);
        wsRequestHandlerMap.put("request.tool.third_openapi", ToolThirdOpenApiHandler.class);
        wsRequestHandlerMap.put("request.tool.entity.metadata", ToolEntityMetadataiHandler.class);
        wsRequestHandlerMap.put("request.file.metadata.save", FileMetadataSaveHandler.class);
        wsRequestHandlerMap.put("request.file.detail", FileDetailHandler.class);
        wsRequestHandlerMap.put("request.log.step.save", LogStepSaveHandler.class);
        wsRequestHandlerMap.put("request.log.event.save", LogEventSaveHandler.class);
        wsRequestHandlerMap.put("request.monitor.log.save", MonitorLogSaveHandler.class);
        wsRequestHandlerMap.put("request.llm.completion", LlmCompletionHandler.class);
        wsRequestHandlerMap.put("request.tool.cosmic_action", ToolCosmicActionHandler.class);
    }
}

