/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent.handler;

import com.alibaba.fastjson.JSONObject;
import kd.ai.gai.core.api.websocket.query.RequiredParams;
import kd.ai.gai.core.api.websocket.query.WsRequestParams;
import kd.ai.gai.core.cache.SessionCache;
import kd.ai.gai.core.domain.dto.agent.FileInfo;
import kd.ai.gai.core.enuz.agent.PurposeEnum;
import kd.ai.gai.core.service.agent.handler.BaseWsRequestHandler;
import kd.ai.gai.core.service.agent.handler.IWsRequestHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FileMetadataSaveHandler
extends BaseWsRequestHandler
implements IWsRequestHandler {
    private static final Log log = LogFactory.getLog(FileMetadataSaveHandler.class);

    @Override
    public WsRequestParams process(String chatSessionId, WsRequestParams wsRequestParams) {
        try {
            this.fillRespWsRequestParams(wsRequestParams);
            JSONObject bizParams = (JSONObject)wsRequestParams.getBizParams();
            RequiredParams requiredParams = wsRequestParams.getRequiredParams();
            FileInfo fileInfo = (FileInfo)bizParams.toJavaObject(FileInfo.class);
            fileInfo.setPurpose(PurposeEnum.ASSISTANT.getId());
            fileInfo.setRequestId(requiredParams.getRequestId());
            String tempFileCacheKey = String.format("%s_%s", "tempFile", chatSessionId);
            SessionCache.get().put(tempFileCacheKey, JSONObject.toJSONString((Object)fileInfo));
        }
        catch (Exception e) {
            log.info("processRequest error: {}", (Object)e.getMessage(), (Object)e);
        }
        return wsRequestParams;
    }
}

