/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent.handler;

import com.alibaba.fastjson.JSONObject;
import kd.ai.gai.core.agent.entity.LLMTransferRequestBizParams;
import kd.ai.gai.core.api.websocket.query.WsRequestParams;
import kd.ai.gai.core.service.agent.GaiLLMTransferService;
import kd.ai.gai.core.service.agent.handler.BaseWsRequestHandler;
import kd.ai.gai.core.service.agent.handler.IWsRequestHandler;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.KDDateUtils;

public class LlmCompletionHandler
extends BaseWsRequestHandler
implements IWsRequestHandler {
    private static final Log log = LogFactory.getLog(LlmCompletionHandler.class);

    @Override
    public WsRequestParams process(String chatSessionId, WsRequestParams wsRequestParams) {
        try {
            this.fillRespWsRequestParams(wsRequestParams);
            String requestId = wsRequestParams.getRequiredParams().getRequestId();
            long st = KDDateUtils.now().getTime();
            log.info("LlmCompletionHandler requestId:{} with {} start...", (Object)requestId, (Object)JSONObject.toJSONString((Object)wsRequestParams));
            JSONObject bizParams = (JSONObject)wsRequestParams.getBizParams();
            LLMTransferRequestBizParams llmTransferRequestBizParams = (LLMTransferRequestBizParams)bizParams.toJavaObject(LLMTransferRequestBizParams.class);
            BaseResult llmResult = GaiLLMTransferService.llmPromptRequest(llmTransferRequestBizParams);
            long et = KDDateUtils.now().getTime();
            log.info("LlmCompletionHandler requestId:{}, cost:{}s with result : {}", new Object[]{requestId, (et - st) / 1000L, JSONObject.toJSONString((Object)llmResult)});
            wsRequestParams.setBizParams(llmResult);
            this.sendRespMsg(chatSessionId, wsRequestParams);
        }
        catch (Exception e) {
            log.info("processRequest error: {}", (Object)e.getMessage(), (Object)e);
        }
        return wsRequestParams;
    }
}

