/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import kd.ai.gai.core.api.websocket.query.WsRequestParams;
import kd.ai.gai.core.domain.dto.agent.MessageDTO;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.agent.handler.BaseWsRequestHandler;
import kd.ai.gai.core.service.agent.handler.IWsRequestHandler;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SessionMessageListAllHandler
extends BaseWsRequestHandler
implements IWsRequestHandler {
    private static final Log log = LogFactory.getLog(SessionMessageListAllHandler.class);

    @Override
    public WsRequestParams process(String chatSessionId, WsRequestParams wsRequestParams) {
        try {
            this.fillRespWsRequestParams(wsRequestParams);
            JSONObject bizParams = (JSONObject)wsRequestParams.getBizParams();
            long sessionId = bizParams.getLong("sessionId");
            List<MessageDTO> messageDTOList = MessageService.getAllChatMessageList(sessionId);
            wsRequestParams.setBizParams(new BaseResult(messageDTOList));
            this.sendRespMsg(chatSessionId, wsRequestParams);
        }
        catch (Exception e) {
            log.info("processRequest error: {}", (Object)e.getMessage(), (Object)e);
        }
        return wsRequestParams;
    }
}

