/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.ai.gai.core.api.mservice.query.MsRequiredParams;
import kd.ai.gai.core.api.websocket.query.WsRequestParams;
import kd.ai.gai.core.domain.dto.CallBackInfo;
import kd.ai.gai.core.domain.dto.agent.ApiChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.domain.dto.agent.MessageConfig;
import kd.ai.gai.core.domain.dto.agent.Run;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.service.agent.RunService;
import kd.ai.gai.core.service.agent.handler.BaseWsRequestHandler;
import kd.ai.gai.core.service.agent.handler.IWsRequestHandler;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class SessionMessageSaveHandler
extends BaseWsRequestHandler
implements IWsRequestHandler {
    private static final Log log = LogFactory.getLog(SessionMessageSaveHandler.class);

    @Override
    public WsRequestParams process(String chatSessionId, WsRequestParams wsRequestParams) {
        try {
            CallBackInfo callBackInfo;
            this.fillRespWsRequestParams(wsRequestParams);
            JSONObject bizParams = (JSONObject)wsRequestParams.getBizParams();
            Message message = (Message)bizParams.toJavaObject(Message.class);
            Run run = RunService.getRunById(message.getRunId());
            Message userMessage = MessageService.getMessageById(run.getMessageId());
            message.setEnable(userMessage.getEnable());
            Context context = FlowCacheData.getContext(chatSessionId);
            message = MessageService.saveMessage(chatSessionId, message);
            JSONObject configJo = this.getConfigJo(chatSessionId, message);
            log.info("configJo:{}", (Object)JSONObject.toJSONString((Object)configJo));
            SLIDEENV slideEnv = this.getSlideEnv(configJo);
            log.info("slideEnv.name:{}", (Object)slideEnv.name());
            MessageConfig messageConfig = MessageService.getMessageConfig(userMessage);
            if (messageConfig.getNeedPushMsg().booleanValue()) {
                ChatService.pushUserOrAssistantMessage(context, message);
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)slideEnv.name(), (CharSequence)SLIDEENV.API_MSERVICE.name()) && (callBackInfo = this.getCallBackInfo(configJo)) != null) {
                log.info("start trigger callback ...");
                MsRequiredParams msRequiredParams = this.getMsRequiredParams(configJo);
                ApiChatMessageDTO apiChatMessageDTO = MessageService.getAssistantMessage(message.getRunId());
                log.info("execute mservice requiredParams:{}, bizParams:{}", (Object)JSONObject.toJSONString((Object)msRequiredParams), (Object)JSONObject.toJSONString((Object)apiChatMessageDTO));
                Object obj = DispatchServiceHelper.invokeBizService((String)callBackInfo.getCloudId(), (String)callBackInfo.getAppId(), (String)callBackInfo.getServiceName(), (String)callBackInfo.getMethodName(), (Object[])new Object[]{JSONObject.toJSONString((Object)msRequiredParams), JSONObject.toJSONString((Object)apiChatMessageDTO)});
                log.info("callback result : {}", (Object)JSONObject.toJSONString((Object)obj));
            }
            wsRequestParams.setBizParams(new BaseResult(message));
            this.sendRespMsg(chatSessionId, wsRequestParams);
        }
        catch (Exception e) {
            log.info("processRequest error: {}", (Object)e.getMessage(), (Object)e);
        }
        return wsRequestParams;
    }

    private JSONObject getConfigJo(String chatSessionId, Message message) {
        JSONObject configJo = null;
        Message lastUserMessage = MessageService.getLastUserMessage(chatSessionId, message.getRunId());
        if (lastUserMessage != null) {
            String configTag = lastUserMessage.getConfigTag();
            log.info("lastUserMessage:{}, configTag:{}", (Object)lastUserMessage.getMessageId(), (Object)configTag);
            if (StringUtils.isNotEmpty((CharSequence)configTag)) {
                configJo = JSONObject.parseObject((String)configTag);
            }
        }
        return configJo;
    }

    private SLIDEENV getSlideEnv(JSONObject configJo) {
        String slideEnvValue;
        SLIDEENV slideEnv = SLIDEENV.MAIN;
        if (configJo != null && StringUtils.isNotEmpty((CharSequence)(slideEnvValue = configJo.getString("slideEnv")))) {
            slideEnv = SLIDEENV.valueOf(slideEnvValue);
        }
        return slideEnv;
    }

    private CallBackInfo getCallBackInfo(JSONObject configJo) {
        JSONObject callBackInfoJo;
        CallBackInfo callBackInfo = null;
        if (configJo != null && (callBackInfoJo = configJo.getJSONObject("callBackInfo")) != null) {
            callBackInfo = (CallBackInfo)JSONObject.toJavaObject((JSON)callBackInfoJo, CallBackInfo.class);
        }
        return callBackInfo;
    }

    private MsRequiredParams getMsRequiredParams(JSONObject configJo) {
        JSONObject msRequiredParamsJo;
        MsRequiredParams msRequiredParams = null;
        if (configJo != null && (msRequiredParamsJo = configJo.getJSONObject("requiredParams")) != null) {
            msRequiredParams = (MsRequiredParams)JSONObject.toJavaObject((JSON)msRequiredParamsJo, MsRequiredParams.class);
        }
        return msRequiredParams;
    }
}

