/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.agent.handler;

import com.alibaba.fastjson.JSONObject;
import kd.ai.gai.core.api.websocket.query.WsRequestParams;
import kd.ai.gai.core.domain.dto.agent.RunStep;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.service.agent.RunService;
import kd.ai.gai.core.service.agent.handler.BaseWsRequestHandler;
import kd.ai.gai.core.service.agent.handler.IWsRequestHandler;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class SessionRunStepSaveHandler
extends BaseWsRequestHandler
implements IWsRequestHandler {
    private static final Log log = LogFactory.getLog(SessionRunStepSaveHandler.class);

    @Override
    public WsRequestParams process(String chatSessionId, WsRequestParams wsRequestParams) {
        try {
            this.fillRespWsRequestParams(wsRequestParams);
            JSONObject bizParams = (JSONObject)wsRequestParams.getBizParams();
            RunStep runStep = (RunStep)bizParams.toJavaObject(RunStep.class);
            Context context = FlowCacheData.getContext(chatSessionId);
            runStep = RunService.saveRunStep(context, runStep);
            wsRequestParams.setBizParams(new BaseResult(runStep));
            this.sendRespMsg(chatSessionId, wsRequestParams);
        }
        catch (Exception e) {
            log.info("processRequest error: {}", (Object)e.getMessage(), (Object)e);
        }
        return wsRequestParams;
    }
}

