/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.embedding;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.Result4Embedding;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.message.EmbeddingMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.ai.gai.core.service.ChunkService;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;

public abstract class EmbeddingService {
    private static final Log logger = LogFactory.getLog(EmbeddingService.class);
    private static final int def_topk = 5;
    private int dimension;
    private LLM llm;

    public EmbeddingService(LLM llm, int dimension) {
        this.setDimension(dimension);
        this.setLlm(llm);
    }

    public Result4Embedding embedding(List<String> chunkTextList) {
        return this.resultParse(this.embedding(this.getLlm(), chunkTextList));
    }

    public int getDimension() {
        return this.dimension;
    }

    protected final void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public LLM getLlm() {
        return this.llm;
    }

    protected final void setLlm(LLM llm) {
        this.llm = llm;
    }

    public abstract Result4Embedding resultParse(Result2User var1);

    public abstract List<Chunk> search(List<Long> var1, String var2);

    public abstract List<Chunk> search(List<Long> var1, String var2, int var3);

    public List<Chunk> search(List<Long> repoIdList, List<Float> vectorList) {
        return this.search(repoIdList, vectorList, 5);
    }

    public List<Chunk> search(List<Long> repoIdList, List<Float> vectorList, int topK) {
        if (vectorList == null || vectorList.isEmpty()) {
            logger.error(Errors.EMBEDDING_ERROR.getMessage());
            throw new KDBizException(Errors.EMBEDDING_ERROR, new Object[0]);
        }
        List<Long> searchIds = MilvusService.getExecutor(this.getLlm()).searchIds(vectorList, repoIdList, topK);
        logger.info("\u67e5\u8be2\u7ed3\u679c{}", searchIds);
        return ChunkService.getByList(searchIds);
    }

    protected Result2User embedding(LLM llm, List<String> chunkTextList) {
        HashMap<String, List<String>> paramList = new HashMap<String, List<String>>();
        paramList.put("input", chunkTextList);
        String userName = RequestContext.get().getUserName();
        long start = System.currentTimeMillis();
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("stream", "false");
        logger.info("\u7528\u6237({})\u5f00\u59cb\u8c03\u7528Embedding {} \u670d\u52a1", new Object[]{userName, "syncService", JSON.toJSON(paramList)});
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"syncService", (Object[])new Object[]{contextMap, llm.getNumber(), JSON.toJSON(paramList).toString()});
        logger.info("\u7528\u6237({})\u5f00\u59cb\u8c03\u7528Embedding {} \u540c\u6b65\u670d\u52a1\u6267\u884c\u7ed3\u679c {} \uff0c\u8017\u65f6 {}", new Object[]{userName, "syncService", JSON.toJSON((Object)result), System.currentTimeMillis() - start});
        String taskId = (String)result.get("id");
        String errMessage = (String)result.get("message");
        String errorCode = (String)result.get("errorCode");
        if (!Errors.OK.getCode().equals(errorCode)) {
            throw new KDBizException("embedding\u540c\u6b65\u63a5\u53e3\u8c03\u7528\u51fa\u9519(" + errorCode + "):" + errMessage);
        }
        return new Result2User(errorCode, errMessage, taskId, (String)result.get("result"));
    }

    public Result2User embeddingAsync(EmbeddingMessage embeddingMessage) {
        LLM llm = embeddingMessage.getLlm();
        List<String> chunkTextList = embeddingMessage.getChunks();
        if (llm == LLM.AZURE_EMBEDDING_ADA_002 && chunkTextList.size() > 1) {
            throw new KDBizException("AZURE_EMBEDDING_ADA_002 \u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c");
        }
        HashMap<String, List<String>> paramList = new HashMap<String, List<String>>();
        paramList.put("input", chunkTextList);
        String userName = RequestContext.get().getUserName();
        long start = System.currentTimeMillis();
        HashMap<String, String> contextMap = new HashMap<String, String>();
        contextMap.put("stream", "false");
        contextMap.put("notify_ms_cloudid", "ai");
        contextMap.put("notify_ms_appid", "gai");
        contextMap.put("notify_ms_service_name", "GaiCallBackService");
        contextMap.put("notify_ms_method_name", "embeddingNotify");
        logger.info("\u7528\u6237({})\u5f00\u59cb\u8c03\u7528Embedding {} \u670d\u52a1", new Object[]{userName, "asyncService", JSON.toJSON(paramList)});
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"ai", (String)"aicc", (String)"AiccService", (String)"asyncService", (Object[])new Object[]{contextMap, llm.getNumber(), JSON.toJSON(paramList).toString()});
        logger.info("\u7528\u6237({})\u5f00\u59cb\u8c03\u7528Embedding {} \u5f02\u6b65\u670d\u52a1\u6267\u884c\u7ed3\u679c {} \uff0c\u8017\u65f6 {}", new Object[]{userName, "asyncService", JSON.toJSON((Object)result), System.currentTimeMillis() - start});
        String taskId = (String)result.get("id");
        String errMessage = (String)result.get("message");
        String errorCode = (String)result.get("errorCode");
        if (!Errors.OK.getCode().equals(errorCode)) {
            throw new KDBizException("embedding\u5f02\u6b65\u63a5\u53e3\u8c03\u7528\u51fa\u9519(" + errorCode + "):" + errMessage);
        }
        return new Result2User(errorCode, errMessage, taskId, (String)result.get("result"));
    }
}

