/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.embedding;

import java.util.EnumMap;
import java.util.Map;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.service.embedding.AzureEmbeddingAda002NewService;
import kd.ai.gai.core.service.embedding.AzureEmbeddingAda002Service;
import kd.ai.gai.core.service.embedding.BaiduEmbeddingService;
import kd.ai.gai.core.service.embedding.EmbeddingService;
import kd.ai.gai.core.service.embedding.KingdeeEmbeddingService;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class EmbeddingServiceFactory {
    private static final Log logger = LogFactory.getLog(EmbeddingServiceFactory.class);

    public static EmbeddingService getExecutor(LLM llm) {
        EmbeddingService embeddingService = (EmbeddingService)Holder.map.get((Object)llm);
        if (embeddingService != null) {
            return embeddingService;
        }
        throw new KDBizException("\u4e0d\u652f\u6301\u7684Embedding\u6a21\u578b");
    }

    private static class Holder {
        private static final Map<LLM, EmbeddingService> map = new EnumMap<LLM, EmbeddingService>(LLM.class);

        private Holder() {
        }

        static {
            map.put(LLM.AZURE_EMBEDDING_ADA_002, new AzureEmbeddingAda002Service(LLM.AZURE_EMBEDDING_ADA_002, 1536));
            map.put(LLM.AZURE_EMBEDDING_ADA_002_BATCH, new AzureEmbeddingAda002NewService(LLM.AZURE_EMBEDDING_ADA_002_BATCH, 1536));
            map.put(LLM.KINGDEE_EMBEDDING, new KingdeeEmbeddingService(LLM.KINGDEE_EMBEDDING, 768));
            map.put(LLM.BAIDU_EMBEDDING_V1, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_V1, 384));
            map.put(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_BGE_LARGE_ZH, 1024));
            map.put(LLM.BAIDU_EMBEDDING_TAO_8K, new BaiduEmbeddingService(LLM.BAIDU_EMBEDDING_TAO_8K, 1024));
        }
    }
}

