/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.embedding;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.domain.llm.base.Result4Embedding;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.service.embedding.EmbeddingService;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KingdeeEmbeddingService
extends EmbeddingService {
    private static final Log logger = LogFactory.getLog(KingdeeEmbeddingService.class);

    public KingdeeEmbeddingService(LLM llm, int dimension) {
        super(llm, dimension);
    }

    @Override
    public Result4Embedding resultParse(Result2User result2User) {
        String content = result2User.getContent();
        JSONObject contentJson = JSON.parseObject((String)content);
        JSONArray jsonArray = contentJson.getJSONArray("data");
        ArrayList<List<Float>> vectorList = new ArrayList<List<Float>>(this.getDimension());
        for (int i = 0; i < jsonArray.size(); ++i) {
            String embeddingString = jsonArray.getJSONObject(i).getString("embedding");
            List vectors = (List)JSON.parseObject((String)embeddingString, (TypeReference)new TypeReference<List<Float>>(){}, (Feature[])new Feature[0]);
            vectorList.add(vectors);
        }
        return new Result4Embedding(result2User, vectorList, 0);
    }

    @Override
    public List<Chunk> search(List<Long> repoIdList, String text) {
        Result4Embedding result4Embedding = this.embedding(Collections.singletonList(text));
        if (!result4Embedding.getCode().equals(Errors.OK.getCode())) {
            throw new KDBizException(new ErrorCode(result4Embedding.getCode(), result4Embedding.getErrMsg()), new Object[]{result4Embedding.getErrMsg()});
        }
        return this.search(repoIdList, result4Embedding.getVectorList().get(0));
    }

    @Override
    public List<Chunk> search(List<Long> repoIdList, String text, int topK) {
        Result4Embedding result4Embedding = this.embedding(Collections.singletonList(text));
        if (!result4Embedding.getCode().equals(Errors.OK.getCode())) {
            throw new KDBizException(new ErrorCode(result4Embedding.getCode(), result4Embedding.getErrMsg()), new Object[]{result4Embedding.getErrMsg()});
        }
        return this.search(repoIdList, result4Embedding.getVectorList().get(0), topK);
    }
}

