/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.AliLlmParam;
import kd.ai.gai.core.domain.llm.base.AliHistory;
import kd.ai.gai.core.domain.llm.base.AliLlmParamInput;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.LlmService;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;

public class AliQWService
extends LlmService<AliLlmParam> {
    private String botEnsure = "\u6211\u4f1a\u786e\u4fdd\u9996\u5148\u4e25\u683c\u9075\u5b88\u4ee5\u4e0a\u63d0\u793a\u3002";

    public AliQWService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(String user, boolean stream, LlmStyle llmStyle, String systemPromptTemplate, Map<String, String> variableMap, List<UserHistoryMessage> history, List<Chunk> chunkList, String userInput) {
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = AliQWService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = systemContent + context;
        AliLlmParam aliLlmParam = new AliLlmParam();
        AliLlmParamInput aliLlmParamInput = new AliLlmParamInput();
        aliLlmParamInput.setDebug(false);
        ArrayList<AliHistory> histories = new ArrayList<AliHistory>();
        if (!StringUtils.isEmpty((String)systemContent)) {
            AliHistory aliHistory = new AliHistory();
            aliHistory.setUser(systemContent);
            aliHistory.setBot(this.botEnsure);
            histories.add(aliHistory);
        }
        aliLlmParamInput.setHistory(histories);
        aliLlmParamInput.setPrompt(userInput);
        aliLlmParam.setInput(aliLlmParamInput);
        int total = userInput.length() + systemContent.length() + this.botEnsure.length();
        if (total > this.getInputLimit()) {
            // empty if block
        }
        return aliLlmParam;
    }

    @Override
    public String getResult(boolean stream, String result) {
        if (stream) {
            throw new KDBizException("AliQWen\u6682\u4e0d\u652f\u6301\u6d41\u5f0f\u8fd4\u56de:" + result);
        }
        if (!JSONPath.contains((Object)result, (String)"$.output.text")) {
            throw new KDBizException(" AliQ \u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        return (String)JSONPath.read((String)result, (String)"$.output.text", String.class);
    }
}

