/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.AwsAnthropicClaudeMessagesParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4Claude3;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AwsAnthropicClaudeMessagesService
extends LlmService<AwsAnthropicClaudeMessagesParam> {
    private static final Log logger = LogFactory.getLog(AwsAnthropicClaudeMessagesService.class);

    public AwsAnthropicClaudeMessagesService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(String user, boolean stream, LlmStyle llmStyle, String systemPromptTemplate, Map<String, String> variableMap, List<UserHistoryMessage> history, List<Chunk> chunkList, String userInput) {
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        AwsAnthropicClaudeMessagesParam awsAnthropicClaudeMessagesParam = new AwsAnthropicClaudeMessagesParam(llmStyle);
        ArrayList<MessageItem4Claude3> list = new ArrayList<MessageItem4Claude3>(1);
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = AwsAnthropicClaudeMessagesService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = systemContent + context;
        int total = userInput.length() + systemContent.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        awsAnthropicClaudeMessagesParam.setSystem(systemContent);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            ListIterator<UserHistoryMessage> listIterator = history.listIterator();
            boolean bFindFirstAssistantRoleMessage = false;
            LlmRole lastRole = null;
            int i = 0;
            while (listIterator.hasNext()) {
                UserHistoryMessage historyMessage = listIterator.next();
                logger.info(String.format("History[%s]\nAssistant=%s\nUser=%s", ++i, kd.bos.util.StringUtils.isEmpty((String)historyMessage.getAssistant()) ? "" : historyMessage.getAssistant(), kd.bos.util.StringUtils.isEmpty((String)historyMessage.getUser()) ? "" : historyMessage.getUser()));
                if (!bFindFirstAssistantRoleMessage) {
                    bFindFirstAssistantRoleMessage = kd.bos.util.StringUtils.isNotEmpty((String)historyMessage.getAssistant());
                }
                if (!bFindFirstAssistantRoleMessage) continue;
                LlmRole role = null;
                String text = historyMessage.getAssistant();
                if (kd.bos.util.StringUtils.isNotEmpty((String)text)) {
                    role = LlmRole.assistant;
                } else {
                    role = LlmRole.user;
                    text = historyMessage.getUser();
                }
                if (role == lastRole || (total += text.length()) > this.getInputLimit()) break;
                MessageItem4Claude3 messageItem4Claude3 = new MessageItem4Claude3();
                messageItem4Claude3.setRole(role);
                messageItem4Claude3.setContent(Collections.singletonList(new MessageItem4Claude3.Claude3Item(text)));
                list.add(messageItem4Claude3);
                lastRole = role;
            }
            if (!list.isEmpty() && ((MessageItem4Claude3)list.get(list.size() - 1)).getRole() != LlmRole.user) {
                list.remove(list.size() - 1);
            }
            Collections.reverse(list);
        }
        MessageItem4Claude3 messageItem4Claude3 = new MessageItem4Claude3();
        messageItem4Claude3.setRole(LlmRole.user);
        messageItem4Claude3.setContent(Collections.singletonList(new MessageItem4Claude3.Claude3Item(userInput)));
        list.add(messageItem4Claude3);
        awsAnthropicClaudeMessagesParam.setMessages(list);
        return awsAnthropicClaudeMessagesParam;
    }

    @Override
    public String getResult(boolean stream, String result) {
        if (stream) {
            if ("data: [DONE]".equals(result)) {
                return null;
            }
            JSONObject json = GaiUtils.toJson(result);
            logger.info("aws bedrock \u539f\u59cb\u5185\u5bb9\uff1a{} json\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)result, (Object)json);
            if (json.isEmpty()) {
                return "";
            }
            if (!json.containsKey((Object)"bytes")) {
                throw new KDBizException("claude2 stream \u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
            }
            String base64String = json.getString("bytes");
            String resultJsonString = new String(Base64.getDecoder().decode(base64String), StandardCharsets.UTF_8);
            if (StringUtils.isEmpty((CharSequence)resultJsonString)) {
                return resultJsonString;
            }
            JSONObject resultJson = JSON.parseObject((String)resultJsonString);
            if (resultJson.getString("type").equals("content_block_delta")) {
                return resultJson.getJSONObject("delta").getString("text");
            }
            return "";
        }
        if (!JSONPath.contains((Object)result, (String)"$.content[0].text")) {
            throw new KDBizException(this.getLlm().getNumber() + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        return (String)JSONPath.read((String)result, (String)"$.content[0].text", String.class);
    }

    @Override
    public int getTokenCount(String text) {
        return (int)Math.ceil((double)GaiUtils.countEnglishWords(text) * 1.3) + GaiUtils.countChineseCharacters(text);
    }
}

