/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.JSONPath;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.AwsClaude2Param;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AwsClaude2Service
extends LlmService<AwsClaude2Param> {
    private static final Log logger = LogFactory.getLog(AwsClaude2Service.class);
    private static final String humanPre = "\n\nHuman:";
    private static final String assistantPre = "\n\nAssistant:";

    public AwsClaude2Service(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(String user, boolean stream, LlmStyle llmStyle, String systemPromptTemplate, Map<String, String> variableMap, List<UserHistoryMessage> history, List<Chunk> chunkList, String userInput) {
        int lastIndex;
        String lastMsg;
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        AwsClaude2Param awsClaude2Param = new AwsClaude2Param(llmStyle);
        ArrayList<String> promptList = new ArrayList<String>();
        int tokenCount = 0;
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = AwsClaude2Service.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = systemContent + context;
        tokenCount = this.getTokenCount(systemContent);
        int total = userInput.length() + systemContent.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        String userLastInput = humanPre + userInput + assistantPre;
        promptList.add(userLastInput);
        tokenCount += this.getTokenCount(userInput);
        ArrayList<String> histroyList = new ArrayList<String>();
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            if (history.size() % 2 != 0) {
                history.remove(history.size() - 1);
            }
            for (UserHistoryMessage item : history) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)item.getAssistant()) && (histroyList.isEmpty() || ((String)histroyList.get(histroyList.size() - 1)).startsWith(humanPre))) {
                    if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                    histroyList.add(item.getAssistant());
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)item.getUser()) || histroyList.isEmpty() || !((String)histroyList.get(histroyList.size() - 1)).startsWith(assistantPre)) continue;
                if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                histroyList.add(item.getUser());
            }
        }
        if (!histroyList.isEmpty() && (lastMsg = (String)histroyList.get(lastIndex = histroyList.size() - 1)).startsWith(assistantPre)) {
            histroyList.remove(lastIndex);
        }
        if (!StringUtils.isEmpty((CharSequence)systemContent)) {
            String firstMsg = (String)promptList.get(promptList.size() - 1);
            String[] split = firstMsg.split(humanPre);
            if (split.length >= 2) {
                firstMsg = split[1];
            }
            promptList.set(promptList.size() - 1, humanPre + systemContent + firstMsg);
        }
        promptList.addAll(histroyList);
        Collections.reverse(promptList);
        StringBuilder promptString = new StringBuilder();
        for (String item : promptList) {
            promptString.append(item);
        }
        awsClaude2Param.setPrompt(promptString.toString());
        return awsClaude2Param;
    }

    @Override
    public String getResult(boolean stream, String result) {
        if (stream) {
            if ("data: [DONE]".equals(result)) {
                return null;
            }
            JSONObject json = GaiUtils.toJson(result);
            logger.info("aws claude2 \u539f\u59cb\u5185\u5bb9\uff1a{} json\u5904\u7406\u7ed3\u679c\uff1a{}", (Object)result, (Object)json);
            if (json.isEmpty()) {
                return "";
            }
            if (!json.containsKey((Object)"bytes")) {
                throw new KDBizException("claude2 stream \u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
            }
            String base64String = json.getString("bytes");
            String resultJson = new String(Base64.getDecoder().decode(base64String), StandardCharsets.UTF_8);
            if (StringUtils.isEmpty((CharSequence)resultJson)) {
                return resultJson;
            }
            return StringUtils.isEmpty((CharSequence)resultJson) ? "" : (String)JSONPath.read((String)resultJson, (String)"$.completion", String.class);
        }
        if (StringUtils.isEmpty((CharSequence)result) || !JSONPath.contains((Object)result, (String)"$.completion")) {
            throw new KDBizException("claude2 no stream \u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        return (String)JSONPath.read((String)result, (String)"$.completion", String.class);
    }
}

