/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.BaiduLlmParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class BaiduErnieService
extends LlmService<BaiduLlmParam> {
    private static final Log logger = LogFactory.getLog(BaiduErnieService.class);

    public BaiduErnieService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(String user, boolean stream, LlmStyle llmStyle, String systemPromptTemplate, Map<String, String> variableMap, List<UserHistoryMessage> history, List<Chunk> chunkList, String userInput) {
        int lastIndex;
        MessageItem4AzureBaiduTencentXf baidu;
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        BaiduLlmParam baiduLlmParam = new BaiduLlmParam(llmStyle);
        baiduLlmParam.setStream(stream);
        baiduLlmParam.setUser_id(user);
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = BaiduErnieService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = systemContent + context + "\n#\u7528\u6237\u95ee\u9898\uff1a";
        int total = userInput.length() + systemContent.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
        messageItem4AzureBaiduTencentXf.setContent(userInput);
        list.add(messageItem4AzureBaiduTencentXf);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            if (history.size() % 2 != 0) {
                history.remove(history.size() - 1);
            }
            for (UserHistoryMessage item : history) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)item.getAssistant()) && (list.isEmpty() || ((MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1)).getRole() == LlmRole.user)) {
                    if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                    messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                    messageItem4AzureBaiduTencentXf.setRole(LlmRole.assistant);
                    messageItem4AzureBaiduTencentXf.setContent(item.getAssistant());
                    list.add(messageItem4AzureBaiduTencentXf);
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)item.getUser()) || list.isEmpty() || ((MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1)).getRole() != LlmRole.assistant) continue;
                if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
                messageItem4AzureBaiduTencentXf.setContent(item.getUser());
                list.add(messageItem4AzureBaiduTencentXf);
            }
        }
        if (!list.isEmpty() && (baidu = (MessageItem4AzureBaiduTencentXf)list.get(lastIndex = list.size() - 1)).getRole() == LlmRole.assistant) {
            list.remove(lastIndex);
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)systemContent)) {
            MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXfFirst = (MessageItem4AzureBaiduTencentXf)list.get(0);
            messageItem4AzureBaiduTencentXfFirst.setContent(systemContent + " " + messageItem4AzureBaiduTencentXfFirst.getContent());
        }
        Collections.reverse(list);
        baiduLlmParam.setMessages(list);
        return baiduLlmParam;
    }

    @Override
    public String getResult(boolean stream, String result) {
        if (stream) {
            if (kd.bos.util.StringUtils.isEmpty((String)result)) {
                return "";
            }
            String string = result = result.startsWith("data: ") ? result.substring(6) : result;
            if (JSONPath.contains((Object)result, (String)"$.result")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.result", String.class);
                return msg == null ? "" : msg;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return null;
            }
            throw new KDBizException(this.getLlm().getNumber() + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        if (!JSONPath.contains((Object)result, (String)"$.result")) {
            throw new KDBizException(this.getLlm().getNumber() + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        return (String)JSONPath.read((String)result, (String)"$.result", String.class);
    }

    @Override
    public int getTokenCount(String text) {
        return (int)Math.ceil((double)GaiUtils.countEnglishWords(text) * 1.3) + GaiUtils.countChineseCharacters(text);
    }
}

