/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import com.alibaba.fastjson.JSONPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.KimiParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.llm.LlmService;
import kd.ai.gai.core.util.GaiUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KimiService
extends LlmService<KimiParam> {
    private static final Log logger = LogFactory.getLog(KimiService.class);

    public KimiService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(String user, boolean stream, LlmStyle llmStyle, String systemPromptTemplate, Map<String, String> variableMap, List<UserHistoryMessage> history, List<Chunk> chunkList, String userInput) {
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        KimiParam kimiParam = new KimiParam(llmStyle, this.getLlm());
        kimiParam.setStream(stream);
        int tokenCount = 0;
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = KimiService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(chunkList, this.getTokenCount(user) + this.getTokenCount(systemContent));
        tokenCount = this.getTokenCount(systemContent) + this.getTokenCount(context);
        int total = userInput.length() + systemContent.length() + context.length();
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
        messageItem4AzureBaiduTencentXf.setContent(userInput);
        tokenCount += this.getTokenCount(userInput);
        list.add(messageItem4AzureBaiduTencentXf);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            for (UserHistoryMessage item : history) {
                if (StringUtils.isNotEmpty((CharSequence)item.getAssistant())) {
                    if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                    tokenCount += this.getTokenCount(item.getAssistant());
                    messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                    messageItem4AzureBaiduTencentXf.setRole(LlmRole.assistant);
                    messageItem4AzureBaiduTencentXf.setContent(item.getAssistant());
                    list.add(messageItem4AzureBaiduTencentXf);
                    continue;
                }
                if ((total += item.getUser().length()) > this.getInputLimit()) break;
                tokenCount += this.getTokenCount(item.getUser());
                messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
                messageItem4AzureBaiduTencentXf.setContent(item.getUser());
                list.add(messageItem4AzureBaiduTencentXf);
            }
        }
        messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        messageItem4AzureBaiduTencentXf.setRole(LlmRole.system);
        messageItem4AzureBaiduTencentXf.setContent(systemContent);
        list.add(messageItem4AzureBaiduTencentXf);
        if (!StringUtils.isEmpty((CharSequence)context)) {
            messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
            messageItem4AzureBaiduTencentXf.setRole(LlmRole.system);
            messageItem4AzureBaiduTencentXf.setContent(context);
            list.add(messageItem4AzureBaiduTencentXf);
        }
        Collections.reverse(list);
        kimiParam.setInPutToken(tokenCount);
        kimiParam.setMessages(list);
        return kimiParam;
    }

    @Override
    public String getResult(boolean stream, String result) {
        if (stream) {
            if (StringUtils.isEmpty((CharSequence)result)) {
                return "";
            }
            String string = result = result.startsWith("data: ") ? result.substring(6) : result;
            if (JSONPath.contains((Object)result, (String)"$.prompt_filter_results")) {
                return "";
            }
            if (JSONPath.contains((Object)result, (String)"$.choices[0].delta")) {
                String msg = (String)JSONPath.read((String)result, (String)"$.choices[0].delta.content", String.class);
                return msg == null ? "" : msg;
            }
            if (StringUtils.containsIgnoreCase((CharSequence)result, (CharSequence)"[DONE]")) {
                return null;
            }
            throw new KDBizException((Object)((Object)this.getLlm()) + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        if (StringUtils.isEmpty((CharSequence)result) || !JSONPath.contains((Object)result, (String)"$.choices[0].message.content")) {
            throw new KDBizException((Object)((Object)this.getLlm()) + "\u8fd4\u56de\u7ed3\u679c\u4e0d\u6b63\u786e:" + result);
        }
        return (String)JSONPath.read((String)result, (String)"$.choices[0].message.content", String.class);
    }

    @Override
    public int getTokenCount(String text) {
        return (int)Math.ceil((double)GaiUtils.countEnglishWords(text) * 1.3) + GaiUtils.countChineseCharacters(text);
    }
}

