/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.service.llm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.llm.XunFeiLlmParam;
import kd.ai.gai.core.domain.llm.base.LlmParam;
import kd.ai.gai.core.domain.llm.base.MessageItem4AzureBaiduTencentXf;
import kd.ai.gai.core.domain.llm.base.UserHistoryMessage;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.LlmRole;
import kd.ai.gai.core.enuz.LlmStyle;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.llm.BaiduErnieService;
import kd.ai.gai.core.service.llm.LlmService;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class XunFeiService
extends LlmService<XunFeiLlmParam> {
    private static final Log logger = LogFactory.getLog(BaiduErnieService.class);

    public XunFeiService(int inputLimit, LLM llm) {
        super(inputLimit, llm);
    }

    @Override
    public LlmParam buildPrompt(String user, boolean stream, LlmStyle llmStyle, String systemPromptTemplate, Map<String, String> variableMap, List<UserHistoryMessage> history, List<Chunk> chunkList, String userInput) {
        int lastIndex;
        MessageItem4AzureBaiduTencentXf baidu;
        logger.info("\u6784\u5efa\u63d0\u793a\uff0c\u5176\u4e2d\u5386\u53f2\u8bb0\u5f55{}\u6761\uff0c\u4e0a\u4e0b\u6587{}\u6761", (Object)(history == null ? 0 : history.size()), (Object)(chunkList == null ? 0 : chunkList.size()));
        XunFeiLlmParam xunFeiLlmParam = new XunFeiLlmParam(llmStyle);
        ArrayList<MessageItem4AzureBaiduTencentXf> list = new ArrayList<MessageItem4AzureBaiduTencentXf>(16);
        if (variableMap == null) {
            variableMap = new HashMap<String, String>();
        }
        String systemContent = XunFeiService.fillVariable(systemPromptTemplate, chunkList, variableMap);
        String context = this.getContext(chunkList, this.getTokenCount(userInput) + this.getTokenCount(systemContent));
        systemContent = systemContent + context;
        int total = this.getTokenCount(userInput) + this.getTokenCount(systemContent);
        if (total > this.getInputLimit()) {
            logger.info("\u8f93\u5165\u53ef\u80fd\u8d85\u957f,\u8bf7\u5173\u6ce8\uff1a{}", (Object)total);
        }
        MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
        messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
        messageItem4AzureBaiduTencentXf.setContent(userInput);
        list.add(messageItem4AzureBaiduTencentXf);
        if (history != null && !history.isEmpty()) {
            Collections.reverse(history);
            if (history.size() % 2 != 0) {
                history.remove(history.size() - 1);
            }
            for (UserHistoryMessage item : history) {
                if (kd.bos.util.StringUtils.isNotEmpty((String)item.getAssistant()) && (list.isEmpty() || ((MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1)).getRole() == LlmRole.user)) {
                    if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                    messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                    messageItem4AzureBaiduTencentXf.setRole(LlmRole.assistant);
                    messageItem4AzureBaiduTencentXf.setContent(item.getAssistant());
                    list.add(messageItem4AzureBaiduTencentXf);
                }
                if (!kd.bos.util.StringUtils.isNotEmpty((String)item.getUser()) || list.isEmpty() || ((MessageItem4AzureBaiduTencentXf)list.get(list.size() - 1)).getRole() != LlmRole.assistant) continue;
                if ((total += item.getAssistant().length()) > this.getInputLimit()) break;
                messageItem4AzureBaiduTencentXf = new MessageItem4AzureBaiduTencentXf();
                messageItem4AzureBaiduTencentXf.setRole(LlmRole.user);
                messageItem4AzureBaiduTencentXf.setContent(item.getUser());
                list.add(messageItem4AzureBaiduTencentXf);
            }
        }
        if (!list.isEmpty() && (baidu = (MessageItem4AzureBaiduTencentXf)list.get(lastIndex = list.size() - 1)).getRole() == LlmRole.assistant) {
            list.remove(lastIndex);
        }
        if (StringUtils.isNotEmpty((CharSequence)systemContent)) {
            MessageItem4AzureBaiduTencentXf messageItem4AzureBaiduTencentXfFirst = (MessageItem4AzureBaiduTencentXf)list.get(0);
            messageItem4AzureBaiduTencentXfFirst.setContent(systemContent + " " + messageItem4AzureBaiduTencentXfFirst.getContent());
        }
        Collections.reverse(list);
        xunFeiLlmParam.setMessages(list);
        return xunFeiLlmParam;
    }

    @Override
    public String getResult(boolean stream, String result) {
        if ("data: [DONE]".equals(result)) {
            return null;
        }
        return result;
    }

    @Override
    public List<Long> filterContext(String allMsg, List<Long> chunkIdList, List<Long> fileIdList) {
        if (!StringUtils.isEmpty((CharSequence)allMsg) && allMsg.length() <= 10 && (allMsg.contains("\u5f88\u62b1\u6b49") || allMsg.contains("\u4e0d\u77e5\u9053"))) {
            logger.info("\u4e0d\u77e5\u9053\u8fc7\u6ee4\u5f15\u7528");
            return new ArrayList<Long>();
        }
        List<RepoFileVO> repoFileVOList = RepoService.getFilesByChunkIds(chunkIdList);
        return repoFileVOList.stream().map(RepoFileVO::getFileId).collect(Collectors.toList());
    }
}

