/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.trace.entity.EventLog;
import kd.ai.gai.core.trace.entity.EventLogResult;
import kd.ai.gai.core.trace.entity.StepLog;
import kd.ai.gai.core.trace.entity.StepLogResult;
import kd.ai.gai.core.trace.util.CommonUtil;
import kd.ai.gai.core.trace.util.LogUtil;
import kd.ai.gai.core.trace.util.SessionLogUtil;
import kd.ai.gai.core.trace.util.ThreadUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.time.DateFormatUtils;

public class MonitorServiceHelper {
    private static final Log logger = LogFactory.getLog(MonitorServiceHelper.class);

    public static void saveTraceSteps(long sessionId, long traceId, List<StepLog> logs) {
        logger.info("sessionId:{}", (Object)sessionId);
        ThreadUtils.execute(() -> {
            try {
                QFilter filter = new QFilter("traceid", "=", (Object)traceId);
                QFilter[] filters = new QFilter[]{filter};
                DynamicObject traceObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])filters);
                if (traceObject == null) {
                    logger.info("trace is not exist,traceId({})", (Object)traceId);
                    StepLog traceLog = (StepLog)logs.get(0);
                    DynamicObject trace = LogUtil.createTraceEntity(traceLog);
                    for (StepLog log : logs) {
                        long stepId = LogUtil.genStepId();
                        LogUtil.createStepEntityByStep(trace, log, stepId);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
                } else {
                    for (StepLog log : logs) {
                        long stepId = LogUtil.genStepId();
                        LogUtil.createStepEntityByStep(traceObject, log, stepId);
                    }
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{traceObject});
                }
            }
            catch (Exception e) {
                logger.error(String.format("save step log error : %s", CommonUtil.getStackTrace(e)));
            }
        });
    }

    public static StepLogResult saveStepLog(StepLog log) {
        logger.info(String.format("\u4fdd\u5b58Step\u65e5\u5fd7\u53c2\u6570 : %s", JSONObject.toJSONString((Object)log)));
        logger.info("save step db origin sessionId({}),traceId({})", (Object)log.getSessionId(), (Object)log.getTraceId());
        long sessionId = log.getSessionId() == null || log.getSessionId() == 0L ? LogUtil.genSessionId() : log.getSessionId();
        long traceId = log.getTraceId() == null || log.getTraceId() == 0L ? LogUtil.genTraceId() : log.getTraceId();
        long stepId = LogUtil.genStepId();
        logger.info("save step db final sessionId({}),traceId({}),stepId({})", new Object[]{sessionId, traceId, stepId});
        StepLogResult result = new StepLogResult((Long)sessionId, (Long)traceId, (Long)stepId);
        log.setSessionId(sessionId);
        log.setTraceId(traceId);
        try {
            QFilter filter = new QFilter("traceid", "=", (Object)traceId);
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject traceObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])filters);
            if (traceObject == null) {
                logger.info("trace is not exist,traceId({})", (Object)traceId);
                DynamicObject trace = LogUtil.createTraceEntity(log);
                LogUtil.createStepEntityByStep(trace, log, stepId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            } else {
                LogUtil.createStepEntityByStep(traceObject, log, stepId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{traceObject});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save step log error : %s", CommonUtil.getStackTrace(e)));
        }
        logger.info(String.format("save step log return : %s", JSONObject.toJSONString((Object)result)));
        return result;
    }

    public static StepLogResult saveAgentStepLog(StepLog log) {
        logger.info(String.format("\u4fdd\u5b58Step\u65e5\u5fd7\u53c2\u6570 : %s", JSONObject.toJSONString((Object)log)));
        logger.info("save step db origin sessionId({}),traceId({})", (Object)log.getSessionId(), (Object)log.getTraceId());
        long sessionId = log.getSessionId() == 0L ? LogUtil.genSessionId() : log.getSessionId();
        long traceId = log.getTraceId() == 0L ? LogUtil.genTraceId() : log.getTraceId();
        long stepId = LogUtil.genStepId();
        logger.info("save step db final sessionId({}),traceId({}),stepId({})", new Object[]{sessionId, traceId, stepId});
        StepLogResult result = new StepLogResult((Long)sessionId, (Long)traceId, (Long)stepId);
        log.setSessionId(sessionId);
        log.setTraceId(traceId);
        try {
            QFilter filter = new QFilter("traceid", "=", (Object)traceId);
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject traceObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])filters);
            if (traceObject == null) {
                logger.info("trace is not exist,traceId({})", (Object)traceId);
                DynamicObject trace = LogUtil.createTraceEntity(log);
                LogUtil.createStepEntityByStep(trace, log, stepId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            } else {
                logger.info("trace is exist,create step,traceId({}),stepId({})", (Object)traceId, (Object)stepId);
                LogUtil.createStepEntityByStep(traceObject, log, stepId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{traceObject});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save step log error : %s", CommonUtil.getStackTrace(e)));
        }
        logger.info(String.format("save step log return : %s", JSONObject.toJSONString((Object)result)));
        return result;
    }

    public static EventLogResult saveEventLog(EventLog log) {
        logger.info(String.format("\u4fdd\u5b58Event\u65e5\u5fd7\u53c2\u6570 : %s", JSONObject.toJSONString((Object)log)));
        long sessionId = log.getSessionId() == null || log.getSessionId() == 0L ? LogUtil.genSessionId() : log.getSessionId();
        long traceId = log.getTraceId() == null || log.getTraceId() == 0L ? LogUtil.genTraceId() : log.getTraceId();
        long stepId = log.getStepId() == null || log.getStepId() == 0L ? LogUtil.genStepId() : log.getStepId();
        long eventId = LogUtil.genEventId();
        try {
            Boolean existTrace;
            Boolean existStep;
            log.setSessionId(sessionId);
            DynamicObject dbStepEntity = null;
            DynamicObject dbStepTraceEntity = null;
            if (log.getStepId() == 0L) {
                existStep = Boolean.FALSE;
            } else {
                Map<String, DynamicObject> map = LogUtil.getExistStepEntity(log.getStepId());
                dbStepTraceEntity = map.get("trace");
                dbStepEntity = map.get("step");
                existStep = dbStepEntity == null ? Boolean.FALSE : Boolean.TRUE;
            }
            DynamicObject dbTraceEntity = null;
            if (log.getTraceId() == 0L) {
                existTrace = Boolean.FALSE;
            } else {
                dbTraceEntity = LogUtil.getExistTraceEntity(log.getTraceId());
                Boolean bl = existTrace = dbTraceEntity == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (existStep.booleanValue()) {
                LogUtil.createEventEntity(dbStepEntity, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbStepTraceEntity});
            } else if (existTrace.booleanValue()) {
                log.setStepId(stepId);
                LogUtil.createStepAndEventEntity(dbTraceEntity, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbTraceEntity});
            } else {
                log.setTraceId(traceId);
                log.setStepId(stepId);
                DynamicObject trace = LogUtil.createTraceEntity(log);
                LogUtil.createStepAndEventEntity(trace, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save event log error : %s", CommonUtil.getStackTrace(e)));
        }
        EventLogResult result = new EventLogResult(sessionId, traceId, stepId, eventId);
        logger.info(String.format("save event log return : %s", JSONObject.toJSONString((Object)result)));
        return result;
    }

    public static EventLogResult saveAgentEventLog(EventLog log) {
        logger.info(String.format("\u4fdd\u5b58Event\u65e5\u5fd7\u53c2\u6570 : %s", JSONObject.toJSONString((Object)log)));
        long sessionId = log.getSessionId() == 0L ? LogUtil.genSessionId() : log.getSessionId();
        long traceId = log.getTraceId() == 0L ? LogUtil.genTraceId() : log.getTraceId();
        long stepId = log.getStepId() == 0L ? LogUtil.genStepId() : log.getStepId();
        long eventId = LogUtil.genEventId();
        try {
            Boolean existTrace;
            Boolean existStep;
            log.setSessionId(sessionId);
            DynamicObject dbStepEntity = null;
            DynamicObject dbStepTraceEntity = null;
            if (log.getStepId() == 0L) {
                existStep = Boolean.FALSE;
            } else {
                Map<String, DynamicObject> map = LogUtil.getExistStepEntity(log.getStepId());
                dbStepTraceEntity = map.get("trace");
                dbStepEntity = map.get("step");
                existStep = dbStepEntity == null ? Boolean.FALSE : Boolean.TRUE;
            }
            DynamicObject dbTraceEntity = null;
            if (log.getTraceId() == 0L) {
                existTrace = Boolean.FALSE;
            } else {
                dbTraceEntity = LogUtil.getExistTraceEntity(log.getTraceId());
                Boolean bl = existTrace = dbTraceEntity == null ? Boolean.FALSE : Boolean.TRUE;
            }
            if (existStep.booleanValue()) {
                LogUtil.createEventEntity(dbStepEntity, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbStepTraceEntity});
            } else if (existTrace.booleanValue()) {
                log.setStepId(stepId);
                LogUtil.createStepAndEventEntity(dbTraceEntity, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbTraceEntity});
            } else {
                log.setTraceId(traceId);
                log.setStepId(stepId);
                DynamicObject trace = LogUtil.createTraceEntity(log);
                LogUtil.createStepAndEventEntity(trace, log, eventId);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{trace});
            }
        }
        catch (Exception e) {
            logger.error(String.format("save event log error : %s", CommonUtil.getStackTrace(e)));
        }
        EventLogResult result = new EventLogResult(sessionId, traceId, stepId, eventId);
        logger.info(String.format("save event log return : %s", JSONObject.toJSONString((Object)result)));
        return result;
    }

    public static JSONObject queryTraceLogs(long traceId) {
        logger.info("Agent\u65e5\u5fd7\u9884\u89c8\uff0ctraceId:{}", (Object)traceId);
        JSONObject trace = SessionLogUtil.querySingleTraceDetail(traceId);
        JSONObject data = new JSONObject();
        if (trace != null) {
            data.put("traceid", (Object)String.valueOf(trace.getLong("traceid")));
            JSONArray steps = new JSONArray();
            data.put("list", (Object)steps);
            JSONArray stepArray = trace.getJSONArray("steps");
            if (stepArray != null && !stepArray.isEmpty()) {
                for (int i = 0; i < stepArray.size(); ++i) {
                    JSONObject step = stepArray.getJSONObject(i);
                    JSONObject stepData = new JSONObject();
                    stepData.put("stepId", (Object)String.valueOf(step.get((Object)"stepid")));
                    stepData.put("title", (Object)step.getString("steptype_name"));
                    Date date = step.getDate("step_createtime");
                    String dateTime = DateFormatUtils.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
                    stepData.put("date", (Object)dateTime);
                    JSONObject traceInputObj = new JSONObject();
                    traceInputObj.put("role", (Object)"input");
                    traceInputObj.put("content", (Object)step.getString("stepinput"));
                    JSONObject traceOutputObj = new JSONObject();
                    traceOutputObj.put("role", (Object)"output");
                    traceOutputObj.put("content", (Object)step.getString("stepoutput"));
                    JSONArray logs = new JSONArray();
                    logs.add((Object)traceInputObj);
                    logs.add((Object)traceOutputObj);
                    stepData.put("logs", (Object)logs);
                    steps.add((Object)stepData);
                }
            }
        }
        logger.info("Agent\u65e5\u5fd7\u9884\u89c8\uff0c\u8fd4\u56dedata:{}", (Object)JSONObject.toJSONString((Object)data));
        return data;
    }

    public static JSONObject queryStepLogsByChatSessionId(String chatSessionId) {
        QFilter chatSessionFilter = new QFilter("chatsessionid", "=", (Object)chatSessionId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(chatSessionFilter);
        return SessionLogUtil.queryLogs(filters.toArray(new QFilter[0]));
    }

    public static JSONObject queryStepLogsBySessionId(long sessionId) {
        QFilter[] filters = new QFilter[]{new QFilter("sessionid", "=", (Object)sessionId)};
        return SessionLogUtil.queryLogs(filters);
    }
}

