/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.constant;

public class Constant {
    public static final String GAI_LOG_BILL_FORM_ID = "gai_log";
    public static final String APP_NUMBER = "gai";
    public static final String APP_CLOUD_AI = "ai";
    public static final String GAI_LOG_VIEW_FORM_ID = "gai_log_view";
    public static final String CUSTOM_CONTROL_EVENT_NAME = "eventName";
    public static final String CUSTOM_CONTROL_PAGE_ID = "pageId";
    public static final String ENTITY_NUMBER = "number";
    public static final String ENTITY_NAME = "name";

    public static enum LogType {
        SESSION("session"),
        TRACE("trace"),
        STEP("step");

        private final String key;

        private LogType(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum CustomControlEventNameEnum {
        CREATE_NEW_DATA("createNewData"),
        CUSTOM_EVENT("customEvent");

        private final String key;

        private CustomControlEventNameEnum(String key) {
            this.key = key;
        }

        public static CustomControlEventNameEnum fromKey(String key) {
            for (CustomControlEventNameEnum e : CustomControlEventNameEnum.values()) {
                if (!e.getKey().equals(key)) continue;
                return e;
            }
            return null;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static class Event {
        public static final String STEP_ID = "event_stepid";
        public static final String EVENT_ID = "event_eventid";
        public static final String EVENT_NAME = "event_eventname";
        public static final String STEP_TYPE = "event_steptype";
        public static final String EVENT_INPUT = "event_eventinput";
        public static final String EVENT_OUTPUT = "event_eventoutput";
        public static final String EVENT_INPUT_TAG = "event_eventinput_tag";
        public static final String EVENT_OUTPUT_TAG = "event_eventoutput_tag";
        public static final String GPT_PROCESS_ID = "event_gptprocessid";
        public static final String GPT_PROCESS_NODE_ID = "event_gptprocessnodeid";
        public static final String MODEL_NAME = "event_modelname";
        public static final String TAGS = "event_tags";
        public static final String METADATA = "event_metadata";
        public static final String METADATA_TAG = "event_metadata_tag";
        public static final String TOTAL_TOKEN = "event_totaltoken";
        public static final String EVENT_TIME = "event_eventtime";
        public static final String CREATE_TIME = "event_createtime";
    }

    public static class Step {
        public static final String ID = "id";
        public static final String TRACE_ID = "step_traceid";
        public static final String STEP_ID = "stepid";
        public static final String PARENT_STEP_ID = "parentstepid";
        public static final String STEP_TYPE = "steptype";
        public static final String STEP_TYPE_NAME = "steptype_name";
        public static final String STEP_INPUT = "stepinput";
        public static final String STEP_OUTPUT = "stepoutput";
        public static final String STEP_INPUT_TAG = "stepinput_tag";
        public static final String STEP_OUTPUT_TAG = "stepoutput_tag";
        public static final String GPT_PROCESS_ID = "gptprocessid";
        public static final String GPT_PROCESS_NAME = "gptprocessname";
        public static final String GPT_PROCESS_NUMBER = "gptprocessnumber";
        public static final String GPT_PROCESS_NODE_ID = "gptprocessnodeid";
        public static final String GPT_PROCESS_NODE_NAME = "gptprocessnodename";
        public static final String MODEL_NAME = "modelname";
        public static final String TAGS = "tags";
        public static final String METADATA = "metadata";
        public static final String METADATA_TAG = "metadata_tag";
        public static final String TOTAL_TOKEN = "totaltoken";
        public static final String STEP_BEGIN_TIME = "stepbegintime";
        public static final String STEP_FINISH_TIME = "stepfinishtime";
        public static final String LATENCY = "latency";
        public static final String CREATE_TIME = "step_createtime";
        public static final String SUBENTRYENTITY = "subentryentity";
        public static final String SUBENTRYENTITY_STEP_ID = String.format("%s.%s.%s", "entryentity", "subentryentity", "stepid");
    }

    public static class Trace {
        public static final String ID = "id";
        public static final String TRACE_ID = "traceid";
        public static final String TRACE_NUM = "tracenum";
        public static final String BASEDATA_NUMBER = "number";
        public static final String BASEDATA_NAME = "name";
        public static final String BASEDATA_STATUS = "status";
        public static final String BASEDATA_ENABLE = "enable";
        public static final String BASEDATA_USEORG = "useorg";
        public static final String BASEDATA_CREATEORG = "createorg";
        public static final String BASEDATA_CREATEORG_NAME = "createorg_name";
        public static final String ORG = "org";
        public static final String USER_ID = "userid";
        public static final String USER_NAME = "username";
        public static final String CLOUD_ID = "cloudid";
        public static final String APP_ID = "appid";
        public static final String CREATE_TIME = "createtime";
        public static final String MODIFY_TIME = "modifytime";
        public static final String AUDIT_DATE = "auditdate";
        public static final String CREATOR = "creator";
        public static final String MODIFIER = "modifier";
        public static final String AUDITOR = "auditor";
        public static final String ENTRYENTITY = "entryentity";
        public static final String ENTRYENTITY_STEP_ID = String.format("%s.%s", "entryentity", "stepid");
        public static final String TRACE_INPUT = "traceinput";
        public static final String TRACE_OUTPUT = "traceoutput";
    }

    public static class Session {
        public static final String CHAT_SESSION_ID = "chatsessionid";
        public static final String SESSION_ID = "sessionid";
    }

    public static class UserInfo {
        public static final String USER_PICTURE_FIELD = "picturefield";
        public static final String USER_HEADER_AVATAR = "avatar";
        public static final String USER_HEADER_PICTURE = "picture";
    }

    public static enum NodeType {
        SESSION,
        TRACE,
        STEP,
        EVENT;

    }

    public static enum StepType {
        GPT_PROCESS_START("gpt_process_start", "GPT\u4efb\u52a1\u5f00\u59cb\u8282\u70b9"),
        GPT_PROCESS_END("gpt_process_end", "GPT\u4efb\u52a1\u7ed3\u675f\u8282\u70b9"),
        GPT_PROMPT("prompt", "\u63d0\u793a\u8bcd\u7ec4\u88c5"),
        GPT_PROCESS_ACTION("action", "\u81ea\u5b9a\u4e49\u64cd\u4f5c"),
        GPT_PROCESS_MESSAGE("message", "\u6d88\u606f"),
        GPT_VECTOR_RETRIEVER("vector-retriever", "\u5411\u91cf\u68c0\u7d22"),
        GPT_GENERATION("generation", "LLM\u751f\u6210"),
        OTHER("other", "\u5176\u5b83");

        private String type;
        private String name;

        private StepType(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public static String getStepTypeName(String stepType) {
            try {
                StepType[] values;
                for (StepType value : values = StepType.values()) {
                    if (!value.getType().equalsIgnoreCase(stepType)) continue;
                    return value.getName();
                }
            }
            catch (Exception e) {
                return stepType;
            }
            return stepType;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Enable {
        ENABLE("1", "\u542f\u7528"),
        DISABLED("0", "\u7981\u7528");

        private String enable;
        private String name;

        private Enable(String enable, String name) {
            this.enable = enable;
            this.name = name;
        }

        public String getEnable() {
            return this.enable;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum BillStatus {
        TEMP("A", "\u6682\u5b58"),
        SUBMIT("B", "\u5df2\u63d0\u4ea4"),
        AUDIT("C", "\u5df2\u5ba1\u6838");

        private String status;
        private String name;

        private BillStatus(String status, String name) {
            this.status = status;
            this.name = name;
        }

        public String getStatus() {
            return this.status;
        }

        public String getName() {
            return this.name;
        }
    }
}

