/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.util;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.trace.constant.Constant;
import kd.ai.gai.core.trace.entity.BaseLog;
import kd.ai.gai.core.trace.entity.EventLog;
import kd.ai.gai.core.trace.entity.StepLog;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class LogUtil {
    public static DynamicObject createTraceEntity(BaseLog log) {
        DynamicObject trace = BusinessDataServiceHelper.newDynamicObject((String)"gai_log");
        trace.set("chatsessionid", (Object)log.getChatSessionId());
        trace.set("sessionid", (Object)log.getSessionId());
        trace.set("traceid", (Object)log.getTraceId());
        trace.set("userid", (Object)log.getUserId());
        trace.set("cloudid", (Object)log.getCloudId());
        trace.set("appid", (Object)log.getAppId());
        LocalDateTime now = LocalDateTime.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmssSSS");
        String currentDateTime = now.format(formatter);
        trace.set("number", (Object)String.format("TRACE-%s", currentDateTime));
        trace.set("name", (Object)String.format("TRACE-%s", currentDateTime));
        trace.set("status", (Object)Constant.BillStatus.AUDIT.getStatus());
        trace.set("enable", (Object)Constant.Enable.ENABLE.getEnable());
        if (log.getUserId() == null) {
            trace.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        } else {
            long uid = log.getUserId();
            if (uid == 0L) {
                trace.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            } else {
                trace.set("creator", (Object)uid);
            }
        }
        trace.set("createtime", (Object)(log.getCreateTime() != null ? log.getCreateTime() : new Date()));
        long useOrg = UserServiceHelper.getUserMainOrgId((long)log.getUserId());
        trace.set("useorg", (Object)useOrg);
        trace.set("createorg", (Object)useOrg);
        trace.set("org", (Object)useOrg);
        return trace;
    }

    public static void createStepEntityByStep(DynamicObject trace, StepLog log, Long stepId) {
        DynamicObjectCollection collection = trace.getDynamicObjectCollection("entryentity");
        DynamicObject step = collection.addNew();
        step.set("step_traceid", (Object)trace.getLong("traceid"));
        step.set("stepid", (Object)stepId);
        step.set("steptype", (Object)log.getStepType());
        step.set("parentstepid", (Object)log.getParentStepId());
        step.set("stepinput", (Object)"\u6b65\u9aa4\u8f93\u5165");
        step.set("stepinput_tag", (Object)log.getStepInput());
        step.set("stepoutput_tag", (Object)log.getStepOutput());
        step.set("stepoutput", (Object)"\u6b65\u9aa4\u8f93\u51fa");
        step.set("gptprocessid", (Object)log.getGptProcessId());
        step.set("gptprocessnodeid", (Object)log.getGptProcessNodeId());
        step.set("modelname", (Object)log.getModelName());
        step.set("tags", (Object)log.getTags());
        step.set("metadata", (Object)"\u5143\u6570\u636e");
        step.set("metadata_tag", (Object)log.getMetadata());
        step.set("totaltoken", (Object)log.getTotalToken());
        step.set("stepbegintime", (Object)(log.getStepBeginTime() == null ? new Date() : log.getStepBeginTime()));
        step.set("stepfinishtime", (Object)(log.getStepFinishTime() == null ? new Date() : log.getStepFinishTime()));
        step.set("latency", (Object)LogUtil.parseLatency(log.getStepBeginTime(), log.getStepFinishTime(), log.getLatency()));
        step.set("step_createtime", (Object)(log.getCreateTime() == null ? new Date() : log.getCreateTime()));
    }

    private static BigDecimal parseLatency(Date stepBeginTime, Date stepFinishTime, BigDecimal latency) {
        if (latency != null && BigDecimal.ZERO.compareTo(latency) != 0) {
            return latency;
        }
        Date nowDate = new Date();
        if (stepBeginTime == null) {
            stepBeginTime = nowDate;
        }
        if (stepFinishTime == null) {
            stepFinishTime = nowDate;
        }
        long time = stepFinishTime.getTime() - stepBeginTime.getTime();
        BigDecimal timeCost = new BigDecimal(time);
        return timeCost;
    }

    public static DynamicObject createStepEntityByEvent(DynamicObject trace, EventLog log) {
        DynamicObjectCollection collection = trace.getDynamicObjectCollection("entryentity");
        DynamicObject step = collection.addNew();
        step.set("step_traceid", (Object)trace.getLong("traceid"));
        step.set("stepid", (Object)log.getStepId());
        step.set("steptype", (Object)log.getStepType());
        step.set("gptprocessid", (Object)log.getGptProcessId());
        step.set("gptprocessnodeid", (Object)log.getGptProcessNodeId());
        step.set("modelname", (Object)log.getModelName());
        step.set("tags", (Object)log.getTags());
        step.set("metadata", (Object)"\u5143\u6570\u636e");
        step.set("metadata_tag", (Object)log.getMetadata());
        step.set("totaltoken", (Object)log.getTotalToken());
        step.set("step_createtime", (Object)new Date());
        return step;
    }

    public static void createEventEntity(DynamicObject step, EventLog log, Long eventId) {
        DynamicObjectCollection collection = step.getDynamicObjectCollection("subentryentity");
        DynamicObject event = collection.addNew();
        event.set("event_stepid", (Object)step.getLong("stepid"));
        event.set("event_eventinput_tag", (Object)log.getEventInput());
        event.set("event_eventoutput_tag", (Object)log.getEventOutput());
        event.set("event_eventinput", (Object)"\u4e8b\u4ef6\u8f93\u5165");
        event.set("event_eventoutput", (Object)"\u4e8b\u4ef6\u8f93\u51fa");
        event.set("event_eventid", (Object)eventId);
        event.set("event_eventname", (Object)log.getEventName());
        event.set("event_steptype", (Object)log.getStepType());
        event.set("event_gptprocessid", (Object)log.getGptProcessId());
        event.set("event_gptprocessnodeid", (Object)log.getGptProcessNodeId());
        event.set("event_modelname", (Object)log.getModelName());
        event.set("event_tags", (Object)log.getTags());
        event.set("event_metadata_tag", (Object)log.getMetadata());
        event.set("event_metadata", (Object)"\u5143\u6570\u636e");
        event.set("event_totaltoken", (Object)log.getTotalToken());
        event.set("event_eventtime", (Object)log.getEventTime());
        event.set("event_createtime", (Object)new Date());
    }

    public static void createStepAndEventEntity(DynamicObject trace, EventLog log, long eventId) {
        DynamicObject step = LogUtil.createStepEntityByEvent(trace, log);
        LogUtil.createEventEntity(step, log, eventId);
    }

    public static Map<String, DynamicObject> getExistStepEntity(long stepId) {
        QFilter stepFilter = new QFilter(Constant.Trace.ENTRYENTITY_STEP_ID, "=", (Object)stepId);
        QFilter[] stepFilters = new QFilter[]{stepFilter};
        String fields = StringUtils.join(Arrays.asList("id", Constant.Trace.ENTRYENTITY_STEP_ID), (String)",");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"gai_log", (String)fields, (QFilter[])stepFilters);
        Boolean existStep = Boolean.FALSE;
        Object tracePkValue = null;
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            block0: for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObjectCollection steps = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject step : steps) {
                    long sid = step.getLong("stepid");
                    if (sid != stepId) continue;
                    existStep = Boolean.TRUE;
                    tracePkValue = dynamicObject.getPkValue();
                    continue block0;
                }
            }
        }
        if (!existStep.booleanValue()) {
            return new HashMap<String, DynamicObject>();
        }
        DynamicObject trace = BusinessDataServiceHelper.loadSingle(tracePkValue, (String)"gai_log");
        DynamicObjectCollection stepCollection = trace.getDynamicObjectCollection("entryentity");
        DynamicObject stepDynamicObj = null;
        for (DynamicObject step : stepCollection) {
            long sid = step.getLong("stepid");
            if (sid != stepId) continue;
            stepDynamicObj = step;
            break;
        }
        HashMap<String, DynamicObject> hashMap = new HashMap<String, DynamicObject>();
        hashMap.put("step", stepDynamicObj);
        hashMap.put("trace", trace);
        return hashMap;
    }

    public static DynamicObject getExistTraceEntity(long traceId) {
        QFilter traceFilter = new QFilter("traceid", "=", (Object)traceId);
        DynamicObject trace = BusinessDataServiceHelper.loadSingle((String)"gai_log", (QFilter[])new QFilter[]{traceFilter});
        return trace;
    }

    public static long genSessionId() {
        return ID.genLongId();
    }

    public static long genTraceId() {
        return ID.genLongId();
    }

    public static long genStepId() {
        return ID.genLongId();
    }

    public static long genEventId() {
        return ID.genLongId();
    }

    public static long genId() {
        return ID.genLongId();
    }
}

