/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.trace.constant.Constant;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class SessionLogUtil {
    public static JSONObject querySessionDetail(long sessionId) {
        QFilter[] filters = new QFilter[]{new QFilter("sessionid", "=", (Object)sessionId)};
        return SessionLogUtil.querySessionDetail(filters);
    }

    public static JSONObject queryLogs(QFilter[] filters) {
        String properties = SessionLogUtil.buildProperties();
        DynamicObject[] tracesObjects = BusinessDataServiceHelper.load((String)"gai_log", (String)properties, (QFilter[])filters, (String)String.format("%s asc", "createtime"));
        final JSONObject data = new JSONObject();
        if (tracesObjects != null && tracesObjects.length > 0) {
            final JSONArray traces = new JSONArray();
            data.put("traces", (Object)traces);
            Arrays.stream(tracesObjects).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject dynamicObject) {
                    DynamicObject user;
                    DynamicObject createOrg;
                    JSONObject trace = new JSONObject();
                    String chatSessionId = dynamicObject.getString("chatsessionid");
                    long sessionId = dynamicObject.getLong("sessionid");
                    long traceId = dynamicObject.getLong("traceid");
                    String cloudId = dynamicObject.getString("cloudid");
                    String appId = dynamicObject.getString("appid");
                    if (!StringUtils.isEmpty((CharSequence)cloudId)) {
                        data.put("cloudid", (Object)cloudId);
                    }
                    if (!StringUtils.isEmpty((CharSequence)appId)) {
                        data.put("appid", (Object)appId);
                    }
                    if ((createOrg = dynamicObject.getDynamicObject("createorg")) != null) {
                        data.put("createorg", createOrg.getPkValue());
                    }
                    if ((user = dynamicObject.getDynamicObject("userid")) != null) {
                        data.put("userid", user.getPkValue());
                    }
                    data.put("chatsessionid", (Object)chatSessionId);
                    data.put("sessionid", (Object)sessionId);
                    trace.put("traceid", (Object)traceId);
                    trace.put("createtime", (Object)dynamicObject.getDate("createtime"));
                    DynamicObjectCollection stepsCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                    stepsCollection.sort((Comparator)new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            return Long.compare(o1.getLong("id"), o2.getLong("id"));
                        }
                    });
                    JSONArray steps = new JSONArray();
                    trace.put("steps", (Object)steps);
                    for (DynamicObject stepDynamicObject : stepsCollection) {
                        JSONObject step = new JSONObject();
                        BigDecimal time = stepDynamicObject.getBigDecimal("latency");
                        step.put("latency", (Object)time);
                        long id = stepDynamicObject.getLong("stepid");
                        int token = stepDynamicObject.getInt("totaltoken");
                        step.put("totaltoken", (Object)token);
                        String input = stepDynamicObject.getString("stepinput_tag");
                        String output = stepDynamicObject.getString("stepoutput_tag");
                        step.put("stepid", (Object)id);
                        step.put("stepinput", (Object)input);
                        step.put("stepoutput", (Object)output);
                        String stepType = stepDynamicObject.getString("steptype");
                        step.put("steptype", (Object)stepType);
                        DynamicObject gptProcess = stepDynamicObject.getDynamicObject("gptprocessid");
                        if (gptProcess != null) {
                            step.put("gptprocessid", gptProcess.getPkValue());
                            step.put("gptprocessname", (Object)gptProcess.getString("name"));
                            step.put("gptprocessnumber", (Object)gptProcess.getString("number"));
                            DynamicObject process = BusinessDataServiceHelper.loadSingle((Object)gptProcess.getPkValue(), (String)"gai_process");
                            if (process != null) {
                                String flowJson = process.getString("flow");
                                long nodeId = stepDynamicObject.getLong("gptprocessnodeid");
                                String gptNodeName = SessionLogUtil.parseProcessNodeName(nodeId, flowJson);
                                step.put("gptprocessnodeid", (Object)nodeId);
                                step.put("gptprocessnodename", (Object)gptNodeName);
                            }
                        } else {
                            step.put("gptprocessnodeid", (Object)0);
                        }
                        step.put("modelname", (Object)stepDynamicObject.getString("modelname"));
                        step.put("createtime", (Object)stepDynamicObject.getDate("step_createtime"));
                        steps.add((Object)step);
                    }
                    traces.add((Object)trace);
                }
            });
        }
        return data;
    }

    public static JSONObject querySessionDetail(QFilter[] filters) {
        String properties = SessionLogUtil.buildProperties();
        DynamicObject[] tracesObjects = BusinessDataServiceHelper.load((String)"gai_log", (String)properties, (QFilter[])filters, (String)String.format("%s asc", "createtime"));
        final JSONObject data = new JSONObject();
        if (tracesObjects != null && tracesObjects.length > 0) {
            data.put("tracenum", (Object)tracesObjects.length);
            final int[] totalToken = new int[]{0};
            final BigDecimal[] totalTime = new BigDecimal[]{new BigDecimal(0)};
            final JSONArray traces = new JSONArray();
            data.put("traces", (Object)traces);
            Arrays.stream(tracesObjects).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject dynamicObject) {
                    List outputs;
                    ArrayList types;
                    List inputs;
                    Object uid;
                    DynamicObject bosUser;
                    DynamicObject user;
                    DynamicObject createOrg;
                    String sessionId = String.valueOf(dynamicObject.getLong("sessionid"));
                    String traceId = String.valueOf(dynamicObject.getLong("traceid"));
                    String cloudId = dynamicObject.getString("cloudid");
                    String appId = dynamicObject.getString("appid");
                    if (!StringUtils.isEmpty((CharSequence)cloudId)) {
                        data.put("cloudid", (Object)cloudId);
                    }
                    if (!StringUtils.isEmpty((CharSequence)appId)) {
                        data.put("appid", (Object)appId);
                    }
                    if ((createOrg = dynamicObject.getDynamicObject("createorg")) != null) {
                        data.put("createorg_name", (Object)createOrg.getString("name"));
                    }
                    if ((user = dynamicObject.getDynamicObject("userid")) != null && (bosUser = BusinessDataServiceHelper.loadSingle((Object)(uid = user.getPkValue()), (String)"bos_user", (String)"id,name,picturefield")) != null) {
                        data.put("username", (Object)bosUser.getString("name"));
                        RequestContext rc = RequestContext.get();
                        String accountId = rc.getAccountId();
                        data.put("avatar", (Object)String.format("%s?kdcdc=%s", bosUser.getString("picturefield"), accountId));
                        data.put("picture", (Object)bosUser.getString("picturefield"));
                    }
                    data.put("sessionid", (Object)sessionId);
                    JSONObject trace = new JSONObject();
                    traces.add((Object)trace);
                    trace.put("traceid", (Object)traceId);
                    trace.put("createtime", (Object)dynamicObject.getDate("createtime"));
                    data.put("createtime", (Object)dynamicObject.getDate("createtime"));
                    DynamicObjectCollection steps = dynamicObject.getDynamicObjectCollection("entryentity");
                    steps.sort((Comparator)new Comparator<DynamicObject>(){

                        @Override
                        public int compare(DynamicObject o1, DynamicObject o2) {
                            return Long.compare(o1.getLong("id"), o2.getLong("id"));
                        }
                    });
                    LinkedHashMap inputsMap = new LinkedHashMap();
                    LinkedHashMap outputsMap = new LinkedHashMap();
                    LinkedList<String> stepInputs = new LinkedList<String>();
                    LinkedList<String> stepOutputs = new LinkedList<String>();
                    BigDecimal[] traceTotalTime = new BigDecimal[]{new BigDecimal(0)};
                    int[] traceTotalToken = new int[]{0};
                    for (DynamicObject step : steps) {
                        List<String> outputs2;
                        List<String> inputs2;
                        BigDecimal time = step.getBigDecimal("latency");
                        if (time != null) {
                            totalTime[0] = totalTime[0].add(time);
                            traceTotalTime[0] = traceTotalTime[0].add(time);
                        }
                        int token = step.getInt("totaltoken");
                        totalToken[0] = totalToken[0] + token;
                        traceTotalToken[0] = traceTotalToken[0] + token;
                        String stepType = step.getString("steptype");
                        stepInputs.add(step.getString("stepinput_tag"));
                        stepOutputs.add(step.getString("stepoutput_tag"));
                        if (!StringUtils.equalsIgnoreCase((CharSequence)stepType, (CharSequence)Constant.StepType.GPT_VECTOR_RETRIEVER.getType()) && !StringUtils.equalsIgnoreCase((CharSequence)stepType, (CharSequence)Constant.StepType.GPT_PROMPT.getType()) && !StringUtils.equalsIgnoreCase((CharSequence)stepType, (CharSequence)Constant.StepType.GPT_GENERATION.getType())) continue;
                        if (!inputsMap.containsKey(stepType)) {
                            inputs2 = new ArrayList<String>();
                            inputs2.add(step.getString("stepinput_tag"));
                            inputsMap.put(stepType, inputs2);
                        } else {
                            inputs2 = (List)inputsMap.get(stepType);
                            inputs2.add(step.getString("stepinput_tag"));
                            inputsMap.put(stepType, inputs2);
                        }
                        if (!outputsMap.containsKey(stepType)) {
                            outputs2 = new ArrayList<String>();
                            outputs2.add(step.getString("stepoutput_tag"));
                            outputsMap.put(stepType, outputs2);
                            continue;
                        }
                        outputs2 = (List)outputsMap.get(stepType);
                        outputs2.add(step.getString("stepoutput_tag"));
                        outputsMap.put(stepType, outputs2);
                    }
                    String traceInput = "";
                    String traceOutpt = "";
                    if (!inputsMap.isEmpty() && (inputs = (List)inputsMap.get((types = new ArrayList(inputsMap.keySet())).get(0))) != null && !inputs.isEmpty()) {
                        traceInput = (String)inputs.get(0);
                    }
                    if (!outputsMap.isEmpty() && (outputs = (List)outputsMap.get((types = new ArrayList(outputsMap.keySet())).get(types.size() - 1))) != null && !outputs.isEmpty()) {
                        traceOutpt = (String)outputs.get(outputs.size() - 1);
                    }
                    if (StringUtils.isEmpty((CharSequence)traceInput) && !stepInputs.isEmpty()) {
                        traceInput = (String)stepInputs.get(0);
                    }
                    if (StringUtils.isEmpty((CharSequence)traceOutpt) && !stepOutputs.isEmpty()) {
                        traceOutpt = (String)stepOutputs.get(stepOutputs.size() - 1);
                    }
                    trace.put("traceinput", (Object)traceInput);
                    trace.put("traceoutput", (Object)traceOutpt);
                    trace.put("latency", (Object)traceTotalTime[0]);
                    trace.put("totaltoken", (Object)traceTotalToken[0]);
                }
            });
            data.put("totaltoken", (Object)totalToken[0]);
            data.put("latency", (Object)totalTime[0]);
        }
        return data;
    }

    public static JSONObject queryTraceDetail(long traceId) {
        QFilter[] filters = new QFilter[]{new QFilter("traceid", "=", (Object)traceId)};
        DynamicObject trace = SessionLogUtil.queryTraceDetail(filters);
        long sessionId = trace.getLong("sessionid");
        return SessionLogUtil.querySessionDetail(sessionId);
    }

    public static DynamicObject queryTraceDetail(QFilter[] filters) {
        String properties = SessionLogUtil.buildTraceProperties();
        DynamicObject trace = BusinessDataServiceHelper.loadSingle((String)"gai_log", (String)properties, (QFilter[])filters);
        return trace;
    }

    public static JSONObject queryStepDetail(final long stepId) {
        QFilter[] filters = new QFilter[]{new QFilter(String.format("%s.%s", "entryentity", "stepid"), "=", (Object)stepId)};
        String properties = SessionLogUtil.buildProperties();
        DynamicObject[] tracesObjects = BusinessDataServiceHelper.load((String)"gai_log", (String)properties, (QFilter[])filters, (String)String.format("%s.%s asc", "entryentity", "step_createtime"));
        final JSONObject data = new JSONObject();
        if (tracesObjects != null && tracesObjects.length > 0) {
            final int[] totalToken = new int[]{0};
            final BigDecimal[] totalTime = new BigDecimal[]{new BigDecimal(0)};
            Arrays.stream(tracesObjects).forEach(new Consumer<DynamicObject>(){

                @Override
                public void accept(DynamicObject dynamicObject) {
                    Object uid;
                    DynamicObject bosUser;
                    DynamicObject user;
                    DynamicObject createOrg;
                    String sessionId = String.valueOf(dynamicObject.getLong("sessionid"));
                    String traceId = String.valueOf(dynamicObject.getLong("traceid"));
                    String cloudId = dynamicObject.getString("cloudid");
                    String appId = dynamicObject.getString("appid");
                    if (!StringUtils.isEmpty((CharSequence)cloudId)) {
                        data.put("cloudid", (Object)cloudId);
                    }
                    if (!StringUtils.isEmpty((CharSequence)appId)) {
                        data.put("appid", (Object)appId);
                    }
                    if ((createOrg = dynamicObject.getDynamicObject("createorg")) != null) {
                        data.put("createorg_name", (Object)createOrg.getString("name"));
                    }
                    if ((user = dynamicObject.getDynamicObject("userid")) != null && (bosUser = BusinessDataServiceHelper.loadSingle((Object)(uid = user.getPkValue()), (String)"bos_user", (String)"id,name,picturefield")) != null) {
                        data.put("username", (Object)bosUser.getString("name"));
                    }
                    data.put("sessionid", (Object)sessionId);
                    data.put("traceid", (Object)traceId);
                    data.put("createtime", (Object)dynamicObject.getDate("createtime"));
                    DynamicObjectCollection steps = dynamicObject.getDynamicObjectCollection("entryentity");
                    for (DynamicObject step : steps) {
                        long id = step.getLong("stepid");
                        if (id != stepId) continue;
                        BigDecimal time = step.getBigDecimal("latency");
                        if (time != null) {
                            totalTime[0] = totalTime[0].add(time);
                        }
                        int token = step.getInt("totaltoken");
                        totalToken[0] = totalToken[0] + token;
                        String input = step.getString("stepinput_tag");
                        String output = step.getString("stepoutput_tag");
                        data.put("stepid", (Object)id);
                        data.put("stepinput", (Object)input);
                        data.put("stepoutput", (Object)output);
                        String stepType = step.getString("steptype");
                        data.put("steptype", (Object)stepType);
                        data.put("steptype_name", (Object)Constant.StepType.getStepTypeName(stepType));
                        DynamicObject gptProcess = step.getDynamicObject("gptprocessid");
                        if (gptProcess != null) {
                            data.put("gptprocessid", gptProcess.getPkValue());
                            data.put("gptprocessname", (Object)gptProcess.getString("name"));
                            data.put("gptprocessnumber", (Object)gptProcess.getString("number"));
                            DynamicObject process = BusinessDataServiceHelper.loadSingle((Object)gptProcess.getPkValue(), (String)"gai_process");
                            if (process != null) {
                                String flowJson = process.getString("flow");
                                long nodeId = step.getLong("gptprocessnodeid");
                                String gptNodeName = SessionLogUtil.parseProcessNodeName(nodeId, flowJson);
                                data.put("gptprocessnodeid", (Object)nodeId);
                                data.put("gptprocessnodename", (Object)gptNodeName);
                            }
                        } else {
                            data.put("gptprocessnodeid", (Object)0);
                        }
                        data.put("modelname", (Object)step.getString("modelname"));
                        data.put("metadata_tag", (Object)step.getString("metadata_tag"));
                        data.put("tags", (Object)step.getString("tags"));
                        data.put("step_createtime", (Object)step.getDate("step_createtime"));
                    }
                }
            });
            data.put("totaltoken", (Object)totalToken[0]);
            data.put("latency", (Object)totalTime[0]);
        }
        return data;
    }

    public static JSONObject querySingleTraceDetail(long traceId) {
        QFilter[] filters = new QFilter[]{new QFilter("traceid", "=", (Object)traceId)};
        String properties = SessionLogUtil.buildProperties();
        DynamicObject tracesObject = BusinessDataServiceHelper.loadSingle((String)"gai_log", (String)properties, (QFilter[])filters);
        JSONObject trace = new JSONObject();
        if (tracesObject != null) {
            Object uid;
            DynamicObject bosUser;
            DynamicObject user;
            DynamicObject createOrg;
            int[] totalToken = new int[]{0};
            BigDecimal[] totalTime = new BigDecimal[]{new BigDecimal(0)};
            String sessionId = String.valueOf(tracesObject.getLong("sessionid"));
            String cloudId = tracesObject.getString("cloudid");
            String appId = tracesObject.getString("appid");
            if (!StringUtils.isEmpty((CharSequence)cloudId)) {
                trace.put("cloudid", (Object)cloudId);
            }
            if (!StringUtils.isEmpty((CharSequence)appId)) {
                trace.put("appid", (Object)appId);
            }
            if ((createOrg = tracesObject.getDynamicObject("createorg")) != null) {
                trace.put("createorg_name", (Object)createOrg.getString("name"));
            }
            if ((user = tracesObject.getDynamicObject("userid")) != null && (bosUser = BusinessDataServiceHelper.loadSingle((Object)(uid = user.getPkValue()), (String)"bos_user", (String)"id,name,picturefield")) != null) {
                trace.put("username", (Object)bosUser.getString("name"));
                RequestContext rc = RequestContext.get();
                String accountId = rc.getAccountId();
                trace.put("avatar", (Object)String.format("%s?kdcdc=%s", bosUser.getString("picturefield"), accountId));
                trace.put("picture", (Object)bosUser.getString("picturefield"));
            }
            trace.put("sessionid", (Object)sessionId);
            trace.put("traceid", (Object)traceId);
            trace.put("createtime", (Object)tracesObject.getDate("createtime"));
            DynamicObjectCollection steps = tracesObject.getDynamicObjectCollection("entryentity");
            steps.sort((Comparator)new Comparator<DynamicObject>(){

                @Override
                public int compare(DynamicObject o1, DynamicObject o2) {
                    return Long.compare(o1.getLong("id"), o2.getLong("id"));
                }
            });
            JSONArray stepsArray = new JSONArray(steps.size());
            for (DynamicObject step : steps) {
                BigDecimal time = step.getBigDecimal("latency");
                if (time != null) {
                    totalTime[0] = totalTime[0].add(time);
                }
                int token = step.getInt("totaltoken");
                totalToken[0] = totalToken[0] + token;
                JSONObject stepData = new JSONObject();
                String stepType = step.getString("steptype");
                stepData.put("stepid", (Object)step.getLong("stepid"));
                stepData.put("latency", (Object)time);
                stepData.put("totaltoken", (Object)token);
                stepData.put("step_createtime", (Object)step.getDate("step_createtime"));
                stepData.put("steptype", (Object)stepType);
                stepData.put("stepinput", (Object)step.getString("stepinput_tag"));
                stepData.put("stepoutput", (Object)step.getString("stepoutput_tag"));
                stepData.put("steptype_name", (Object)Constant.StepType.getStepTypeName(stepType));
                DynamicObject gptProcess = step.getDynamicObject("gptprocessid");
                if (gptProcess != null) {
                    stepData.put("gptprocessid", gptProcess.getPkValue());
                    stepData.put("gptprocessname", (Object)gptProcess.getString("name"));
                    stepData.put("gptprocessnumber", (Object)gptProcess.getString("number"));
                    DynamicObject process = BusinessDataServiceHelper.loadSingle((Object)gptProcess.getPkValue(), (String)"gai_process");
                    if (process != null) {
                        String flowJson = process.getString("flow");
                        long nodeId = step.getLong("gptprocessnodeid");
                        String gptNodeName = SessionLogUtil.parseProcessNodeName(nodeId, flowJson);
                        stepData.put("gptprocessnodeid", (Object)nodeId);
                        stepData.put("gptprocessnodename", (Object)gptNodeName);
                    }
                } else {
                    stepData.put("gptprocessnodeid", (Object)0);
                }
                stepData.put("modelname", (Object)step.getString("modelname"));
                stepData.put("metadata_tag", (Object)step.getString("metadata_tag"));
                stepData.put("tags", (Object)step.getString("tags"));
                stepsArray.add((Object)stepData);
            }
            trace.put("totaltoken", (Object)totalToken[0]);
            trace.put("latency", (Object)totalTime[0]);
            trace.put("steps", (Object)stepsArray);
        }
        return trace;
    }

    private static String parseProcessNodeName(long nodeId, String flowJson) {
        Flow flow = JsonUtil.fromBase64String(flowJson);
        if (flow == null) {
            return "";
        }
        List<Action> actions = flow.getActions();
        String nodeName = "";
        for (Action action : actions) {
            int id = action.getId();
            if (nodeId != (long)id) continue;
            nodeName = action.getName();
            break;
        }
        return nodeName;
    }

    public static DynamicObject[] querySessionTraces(QFilter[] filters) {
        String traceProperties = StringUtils.join((Object[])new String[]{"id", "number", "traceid", "sessionid", "chatsessionid"}, (String)",");
        String stepProperties = StringUtils.join((Object[])new String[]{String.format("%s.%s", "entryentity", "id"), String.format("%s.%s", "entryentity", "stepid"), String.format("%s.%s", "entryentity", "steptype")}, (String)",");
        String properties = StringUtils.join((Object[])new String[]{traceProperties, stepProperties}, (String)",");
        DynamicObject[] tracesObjects = BusinessDataServiceHelper.load((String)"gai_log", (String)properties, (QFilter[])filters, (String)String.format("%s asc", "createtime"));
        return tracesObjects;
    }

    public static String buildProperties() {
        String traceProperties = SessionLogUtil.buildTraceProperties();
        String stepProperties = SessionLogUtil.buildStepProperties();
        return StringUtils.join((Object[])new String[]{traceProperties, stepProperties}, (String)",");
    }

    public static String buildTraceProperties() {
        String traceProperties = StringUtils.join((Object[])new String[]{"id", "number", "traceid", "sessionid", "chatsessionid", "appid", "cloudid", "createorg", "userid", "createtime"}, (String)",");
        return traceProperties;
    }

    public static String buildStepProperties() {
        String stepProperties = StringUtils.join((Object[])new String[]{String.format("%s.%s", "entryentity", "id"), String.format("%s.%s", "entryentity", "stepid"), String.format("%s.%s", "entryentity", "steptype"), String.format("%s.%s", "entryentity", "totaltoken"), String.format("%s.%s", "entryentity", "latency"), String.format("%s.%s", "entryentity", "stepinput_tag"), String.format("%s.%s", "entryentity", "stepoutput_tag"), String.format("%s.%s", "entryentity", "step_createtime"), String.format("%s.%s", "entryentity", "gptprocessid"), String.format("%s.%s", "entryentity", "gptprocessnodeid"), String.format("%s.%s", "entryentity", "tags"), String.format("%s.%s", "entryentity", "modelname"), String.format("%s.%s", "entryentity", "metadata_tag")}, (String)",");
        return stepProperties;
    }
}

