/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trace.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.EngineCache;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.flow.Action;
import kd.ai.gai.core.engine.flow.Flow;
import kd.ai.gai.core.engine.flow.JavaPluginAction;
import kd.ai.gai.core.engine.flow.LLMAction;
import kd.ai.gai.core.engine.flow.MessageAction;
import kd.ai.gai.core.engine.flow.MserviceAction;
import kd.ai.gai.core.engine.flow.Node;
import kd.ai.gai.core.engine.flow.ScriptAction;
import kd.ai.gai.core.engine.flow.Var;
import kd.ai.gai.core.engine.flow.VarMapper;
import kd.ai.gai.core.engine.message.JavaActionMessage;
import kd.ai.gai.core.engine.message.LLMActionMessage;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.MsgNodeMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.engine.message.llmcallback.MserviceLLMCallbackMessage;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.MessageType;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.trace.MonitorServiceHelper;
import kd.ai.gai.core.trace.constant.Constant;
import kd.ai.gai.core.trace.entity.PromptLog;
import kd.ai.gai.core.trace.entity.StepLog;
import kd.ai.gai.core.trace.entity.StepLogResult;
import kd.ai.gai.core.trace.entity.VectorRetrieverLog;
import kd.ai.gai.core.trace.util.LogUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.IAppCache;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class TraceUtil {
    private static final Log logger = LogFactory.getLog(TraceUtil.class);
    public static final String LLM_TASK_START_TIME_PRE = "llmTaskStartTime";
    public static final String LLM_TASK_LLM_INPUT = "llmTaskLLMInput";
    public static final String LLM_TASK_TRACE = "llmTaskTraceId";

    public static void startFlow(Context context, Flow flow, long processId) {
        try {
            logger.info("\u5f00\u59cbGPT\u6d41\u7a0b\u65e5\u5fd7\u8bb0\u5f55,processId({}),flowId({})", (Object)processId, (Object)flow.getId());
            String chatSessionId = context.getChatSessionId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            if (kd.bos.util.StringUtils.isEmpty((String)sessionId) || "null".equalsIgnoreCase(sessionId)) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(LogUtil.genSessionId()));
            }
            long flowId = flow.getId();
            appCache.put(TraceUtil.flowProcessKey(flowId), (Object)String.valueOf(processId));
            appCache.put(TraceUtil.flowTraceKey(flowId), (Object)String.valueOf(LogUtil.genTraceId()));
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveFlowStartLog(Result result, Context context, Flow flow, long processId, String userInput, long start, long end, long createTime) {
        try {
            String chatSessionId = context.getChatSessionId();
            long flowId = flow.getId();
            logger.info("\u4fdd\u5b58GPT\u6d41\u7a0b\u5f00\u59cb\u8282\u70b9\u65e5\u5fd7,chatSessionId({}),processId({}),flowId({})", new Object[]{chatSessionId, processId, flowId});
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            appCache.put(TraceUtil.flowProcessKey(flowId), (Object)String.valueOf(processId));
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            String traceId = (String)appCache.get(TraceUtil.flowTraceKey(flowId), String.class);
            ErrorCode errorCode = result.getErrorCode();
            if (!Errors.OK.getCode().equalsIgnoreCase(errorCode.getCode())) {
                TraceUtil.saveFlowLog(chatSessionId, context.getUserId(), sessionId, traceId, processId, flowId, flow.getStart().getId(), Constant.StepType.GPT_PROCESS_START.getType(), userInput, JSONObject.toJSONString((Object)errorCode), start, end, createTime, Boolean.TRUE, errorCode.getCode());
            } else {
                TraceUtil.saveFlowLog(chatSessionId, context.getUserId(), sessionId, traceId, processId, flowId, flow.getStart().getId(), Constant.StepType.GPT_PROCESS_START.getType(), userInput, JSONObject.toJSONString(result.getData()), start, end, createTime, Boolean.TRUE, errorCode.getCode());
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveFlowNodeLog(Result result, Context context, Flow flow, Node node, Message actionMessage, Action action, long start, long end, Map<String, String> data) {
        try {
            Message message;
            String chatSessionId = context.getChatSessionId();
            long flowId = flow.getId();
            long nodeId = node.getId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            String processId = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
            String traceId = (String)appCache.get(TraceUtil.flowTraceKey(flowId), String.class);
            long pid = kd.bos.util.StringUtils.isEmpty((String)processId) ? 0L : Long.parseLong(processId);
            logger.info("\u4fdd\u5b58GPT\u6d41\u7a0b\u8282\u70b9\u65e5\u5fd7,chatSessionId({}),processId({}),flowId({}),nodeId({})", new Object[]{chatSessionId, processId, flowId, nodeId});
            String stepType = "";
            String stepInput = "";
            String stepOutput = "";
            ErrorCode errorCode = result.getErrorCode();
            if (!Errors.OK.getCode().equals(errorCode.getCode())) {
                stepOutput = errorCode.getMessage();
            } else {
                String string = stepOutput = data == null ? "" : JSONObject.toJSONString(data);
            }
            if (action instanceof JavaPluginAction) {
                message = (JavaActionMessage)actionMessage;
                stepInput = JSONObject.toJSONString(((JavaActionMessage)message).getParams());
                stepType = Constant.StepType.GPT_PROCESS_ACTION.getType();
            } else if (action instanceof LLMAction) {
                message = (LLMActionMessage)actionMessage;
                stepInput = ((LLMActionMessage)message).getUserInput();
                stepType = Constant.StepType.GPT_PROMPT.getType();
            } else if (action instanceof MessageAction) {
                stepType = Constant.StepType.GPT_PROCESS_MESSAGE.getType();
                MsgNodeMessage messageNode = TraceUtil.buildNodeMessage(context, flow, (MessageAction)action);
                stepInput = "";
                stepOutput = TraceUtil.buildMsgNodeMessage(messageNode.getElementList());
            } else if (action instanceof MserviceAction) {
                stepType = Constant.StepType.GPT_PROCESS_ACTION.getType();
            } else if (action instanceof ScriptAction) {
                stepType = Constant.StepType.GPT_PROCESS_ACTION.getType();
            }
            Boolean saveLog = Boolean.FALSE;
            if (!(action instanceof LLMAction)) {
                saveLog = Boolean.TRUE;
            }
            TraceUtil.saveFlowLog(chatSessionId, context.getUserId(), sessionId, traceId, pid, flowId, nodeId, stepType, stepInput, stepOutput, start, end, System.currentTimeMillis(), saveLog, errorCode.getCode());
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private static MsgNodeMessage buildNodeMessage(Context context, Flow flow, MessageAction messageAction) {
        MsgNodeMessage message = new MsgNodeMessage();
        message.setFlowId(flow.getId());
        ArrayList<MsgNodeMessage.MessageElement> elementList = new ArrayList<MsgNodeMessage.MessageElement>(messageAction.getVarList().size());
        block0: for (Var var : messageAction.getVarList()) {
            MsgNodeMessage.MessageElement messageElement = new MsgNodeMessage.MessageElement();
            elementList.add(messageElement);
            messageElement.setType(var.getType());
            if (var.isInput()) {
                messageElement.setValue(var.getValue());
                continue;
            }
            for (VarMapper varMapper : messageAction.getInParamMap()) {
                if (!varMapper.getInVarName().equals(var.getName())) continue;
                messageElement.setValue(TraceUtil.getVarValue(context.getChatSessionId(), flow.getId(), varMapper.getOutNodeId(), varMapper.getOutVarName()));
                continue block0;
            }
        }
        message.setElementList(elementList);
        message.setReplaceLastMessage(messageAction.isReplaceLastMessage());
        return message;
    }

    private static String getVarValue(String chatSessionId, long flowId, int outNodeId, String outVarName) {
        Map<String, String> outDataMap = FlowCacheData.getFlowNodeData(chatSessionId, flowId, outNodeId);
        return outDataMap.get(outVarName);
    }

    private static String buildMsgNodeMessage(List<MsgNodeMessage.MessageElement> elementList) {
        StringBuilder inputBuilder = new StringBuilder();
        if (elementList != null && !elementList.isEmpty()) {
            for (MsgNodeMessage.MessageElement item : elementList) {
                if (!item.getType().equals(MessageType.Text.getValue())) continue;
                inputBuilder.append(item.getValue()).append(" \r\n");
            }
        }
        return inputBuilder.toString();
    }

    private static void saveFlowLog(String chatSessionId, long userId, String sessionId, String traceId, long processId, long flowId, long nodeId, String stepType, String stepInput, String stepOutput, long start, long end, long createTime, Boolean saveLog, String errCode) {
        try {
            StepLogResult result;
            logger.info("\u4fdd\u5b58GPT\u6d41\u7a0b\u8282\u70b9\u65e5\u5fd7,chatSessionId({}),sessionId({}),traceId({}),userId({}),processId({}),flowId({}),nodeId({})", new Object[]{chatSessionId, sessionId, traceId, userId, processId, flowId, nodeId});
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            Process process = ProcessService.getProcessById(processId);
            JSONObject tagObject = TraceUtil.buildProcessTags(process);
            String tags = JSONObject.toJSONString((Object)TraceUtil.buildResultTags(tagObject, errCode));
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, traceId, null, userId, processId, tags, null, nodeId, stepType, stepInput, stepOutput, start, end, createTime);
            if (saveLog.booleanValue() && (result = MonitorServiceHelper.saveStepLog(stepLog)) != null) {
                appCache.put(TraceUtil.flowTraceKey(flowId), (Object)String.valueOf(result.getTraceId()));
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void endLLMLog(String taskId, long traceId, long start) {
        EngineCache.getAppCache(taskId).put(LLM_TASK_TRACE + taskId, (Object)String.valueOf(traceId));
        EngineCache.getAppCache(taskId).put(LLM_TASK_START_TIME_PRE + taskId, (Object)start);
    }

    public static long buildTraceId(Context context, LLMMessage message) {
        long traceId = 0L;
        try {
            LLMParsedMessage llmParsedMessage;
            String chatSessionId = context.getChatSessionId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            if (kd.bos.util.StringUtils.isEmpty((String)sessionId) || "null".equalsIgnoreCase(sessionId)) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(LogUtil.genSessionId()));
            }
            if ((llmParsedMessage = message.getCallbackMessage()) != null) {
                String trace;
                long flowId = llmParsedMessage.getFlowId();
                traceId = flowId != 0L ? (!kd.bos.util.StringUtils.isEmpty((String)(trace = (String)appCache.get(TraceUtil.flowTraceKey(flowId), String.class))) ? Long.parseLong(trace) : LogUtil.genTraceId()) : LogUtil.genTraceId();
                if (llmParsedMessage instanceof MserviceLLMCallbackMessage) {
                    MserviceLLMCallbackMessage callbackMessage = (MserviceLLMCallbackMessage)llmParsedMessage;
                    String cloudId = callbackMessage.getCloudId();
                    String appId = callbackMessage.getAppId();
                    appCache.put(TraceUtil.traceCloudKey(traceId), (Object)cloudId);
                    appCache.put(TraceUtil.traceAppKey(traceId), (Object)appId);
                }
            } else {
                traceId = LogUtil.genTraceId();
                String cloudId = "ai";
                String appId = "gai";
                appCache.put(TraceUtil.traceCloudKey(traceId), (Object)cloudId);
                appCache.put(TraceUtil.traceAppKey(traceId), (Object)appId);
            }
            return traceId;
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
            return traceId;
        }
    }

    public static void saveAsyncLLMLog(Context context, LLMParsedMessage message) {
        try {
            String chatSessionId = context.getChatSessionId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            long flowId = message.getFlowId();
            int nodeId = message.getNodeId();
            String taskId = message.getTaskId();
            Prompt prompt = (Prompt)appCache.get("prompt" + taskId, Prompt.class);
            String llmInput = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_LLM_INPUT + taskId, String.class);
            String start = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_START_TIME_PRE + taskId, String.class);
            String trace = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_TRACE + taskId, String.class);
            long startTime = kd.bos.util.StringUtils.isEmpty((String)start) ? System.currentTimeMillis() : Long.parseLong(start);
            long end = System.currentTimeMillis();
            long traceId = kd.bos.util.StringUtils.isEmpty((String)trace) ? LogUtil.genTraceId() : Long.parseLong(trace);
            String stepOutput = "";
            String errCode = message.getErrCode();
            stepOutput = !Errors.OK.getCode().equals(errCode) ? message.getErrMsg() : message.getLlmValue();
            TraceUtil.saveLLMLog(context, traceId, flowId, nodeId, prompt, llmInput, stepOutput, startTime, end, errCode, 0);
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveIfStreamAsyncLLMLog(Context context, LLMParsedMessage message) {
        if (message.isStream()) {
            if (message.isEnd()) {
                TraceUtil.saveAsyncLLMLog(context, message);
            }
        } else {
            TraceUtil.saveAsyncLLMLog(context, message);
        }
    }

    public static void saveMserviceStreamAsyncLLMLog(Context context, LLMParsedMessage message) {
        if (message.isStream()) {
            String taskId = message.getTaskId();
            String cacheKey = "llmTaskMserviceLLMOutputCache";
            if (message.isEnd()) {
                String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskMserviceLLMOutputCache", taskId), String.class);
                String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)message.getLlmValue(), (String)""));
                message.setLlmValue(cacheMessages);
                TraceUtil.saveAsyncLLMLog(context, message);
            } else {
                String llmValue = message.getLlmValue();
                String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskMserviceLLMOutputCache", taskId), String.class);
                String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)llmValue, (String)""));
                EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskMserviceLLMOutputCache", taskId), (Object)cacheMessages);
            }
        } else {
            TraceUtil.saveAsyncLLMLog(context, message);
        }
    }

    public static void savePromptTestStreamAsyncLLMLog(Context context, LLMParsedMessage message) {
        if (message.isStream()) {
            String taskId = message.getTaskId();
            String cacheKey = "llmTaskPromptTestLLMOutputCache";
            if (message.isEnd()) {
                String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskPromptTestLLMOutputCache", taskId), String.class);
                String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)message.getLlmValue(), (String)""));
                message.setLlmValue(cacheMessages);
                TraceUtil.saveAsyncLLMLog(context, message);
            } else {
                String llmValue = message.getLlmValue();
                String hisMsg = (String)EngineCache.getAppCache(taskId).get(String.format("%s%s", "llmTaskPromptTestLLMOutputCache", taskId), String.class);
                String cacheMessages = String.format("%s%s", kd.bos.util.StringUtils.getStringValue((Object)hisMsg, (String)""), kd.bos.util.StringUtils.getStringValue((Object)llmValue, (String)""));
                EngineCache.getAppCache(taskId).put(String.format("%s%s", "llmTaskPromptTestLLMOutputCache", taskId), (Object)cacheMessages);
            }
        } else {
            TraceUtil.saveAsyncLLMLog(context, message);
        }
    }

    public static void saveSyncLLMLog(String taskId, Context context, LLMMessage message, String llmValue, Prompt prompt, long traceId, long start, long end, String errCode) {
        try {
            LLMParsedMessage llmParsedMessage = message.getCallbackMessage();
            long flowId = 0L;
            long nodeId = 0L;
            if (llmParsedMessage != null) {
                flowId = llmParsedMessage.getFlowId();
                nodeId = llmParsedMessage.getNodeId();
            }
            String llmInput = (String)EngineCache.getAppCache(taskId).get(LLM_TASK_LLM_INPUT + taskId, String.class);
            TraceUtil.saveLLMLog(context, traceId, flowId, nodeId, prompt, llmInput, llmValue, start, end, errCode, 0);
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    private static void saveLLMLog(Context context, long traceId, long flowId, long nodeId, Prompt prompt, String stepInput, String stepOutput, long start, long end, String errCode, int token) {
        try {
            String chatSessionId = context.getChatSessionId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            LLM llm = prompt.getLlm();
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            long processId = 0L;
            Process process = null;
            if (flowId != 0L) {
                String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
                processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
                process = ProcessService.getProcessById(processId);
            }
            logger.info("\u4fdd\u5b58GPT LLM\u65e5\u5fd7,chatSessionId({}),processId({}),flowId({}),nodeId({})", new Object[]{chatSessionId, processId, flowId, nodeId});
            String trace = String.valueOf(traceId);
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            JSONObject tagObj = TraceUtil.buildLLMPromptTags(process, prompt);
            String tags = JSONObject.toJSONString((Object)TraceUtil.buildResultTags(tagObj, errCode));
            String metadata = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptMetadata(prompt));
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, llm.getNumber(), context.getUserId(), processId, tags, metadata, nodeId, Constant.StepType.GPT_GENERATION.getType(), stepInput, stepOutput, start, end, System.currentTimeMillis(), token);
            StepLogResult result = MonitorServiceHelper.saveStepLog(stepLog);
            if (result != null) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void savePromptLog(String taskId, String chatSessionId, long traceId, String modelName, String userInput, String llmParamString, long flowId, long nodeId, Prompt prompt, long start, long end) {
        try {
            String metadata;
            String tags;
            long userId = RequestContext.get().getCurrUserId();
            if (!kd.bos.util.StringUtils.isEmpty((String)taskId)) {
                EngineCache.getAppCache(taskId).put(LLM_TASK_LLM_INPUT + taskId, (Object)llmParamString);
            }
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            long processId = 0L;
            Process process = null;
            if (flowId != 0L) {
                String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
                processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
                process = ProcessService.getProcessById(processId);
            }
            String trace = String.valueOf(traceId);
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, modelName, userId, processId, tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(process, prompt)), metadata = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptMetadata(prompt)), nodeId, Constant.StepType.GPT_PROMPT.getType(), userInput, llmParamString, start, end, System.currentTimeMillis());
            StepLogResult result = MonitorServiceHelper.saveStepLog(stepLog);
            if (result != null) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveVectorRetrieverLog(String chatSessionId, long traceId, String userInput, String vectorOutput, long flowId, long nodeId, Prompt prompt, long start, long end) {
        try {
            String metadata;
            long userId = RequestContext.get().getCurrUserId();
            IAppCache appCache = EngineCache.getAppCache(chatSessionId);
            String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
            long processId = 0L;
            Process process = null;
            if (flowId != 0L) {
                String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
                processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
                process = ProcessService.getProcessById(processId);
            }
            String modelName = TraceUtil.parseModelName(prompt, userInput);
            String tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(process, prompt));
            String trace = String.valueOf(traceId);
            String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
            String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
            StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, modelName, userId, processId, tags, metadata = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptMetadata(prompt)), nodeId, Constant.StepType.GPT_VECTOR_RETRIEVER.getType(), userInput, vectorOutput, start, end, System.currentTimeMillis());
            StepLogResult result = MonitorServiceHelper.saveStepLog(stepLog);
            if (result != null) {
                appCache.put(TraceUtil.chatSessionKey(chatSessionId), (Object)String.valueOf(result.getSessionId()));
            }
        }
        catch (Exception e) {
            logger.error("GPT\u4efb\u52a1\u8c03\u7528\u8bb0\u5f55\u65e5\u5fd7\u5931\u8d25");
        }
    }

    public static void saveTraceVectorAndPromptLog(String chatSessionId, long traceId, VectorRetrieverLog vectorRetrieverLog, PromptLog promptLog) {
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        ArrayList<StepLog> logs = new ArrayList<StepLog>();
        logs.add(TraceUtil.transformVectorRetrieverLog(traceId, vectorRetrieverLog));
        logs.add(TraceUtil.transformPromptLog(traceId, promptLog));
        MonitorServiceHelper.saveTraceSteps(kd.bos.util.StringUtils.isEmpty((String)sessionId) ? 0L : Long.parseLong(sessionId), traceId, logs);
    }

    private static StepLog transformVectorRetrieverLog(long traceId, VectorRetrieverLog vectorRetrieverLog) {
        long flowId = vectorRetrieverLog.getFlowId();
        long nodeId = vectorRetrieverLog.getNodeId();
        String chatSessionId = vectorRetrieverLog.getChatSessionId();
        Prompt prompt = vectorRetrieverLog.getPrompt();
        String userInput = vectorRetrieverLog.getUserInput();
        String vectorOutput = vectorRetrieverLog.getVectorOutput();
        long start = vectorRetrieverLog.getStart();
        long end = vectorRetrieverLog.getEnd();
        long userId = RequestContext.get().getCurrUserId();
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        long processId = 0L;
        Process process = null;
        if (flowId != 0L) {
            String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
            processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
            process = ProcessService.getProcessById(processId);
        }
        String modelName = TraceUtil.parseModelName(prompt, userInput);
        String tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(process, prompt));
        String trace = String.valueOf(traceId);
        String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
        String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
        String metadata = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptMetadata(prompt));
        StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, modelName, userId, processId, tags, metadata, nodeId, Constant.StepType.GPT_VECTOR_RETRIEVER.getType(), userInput, vectorOutput, start, end, System.currentTimeMillis());
        return stepLog;
    }

    private static StepLog transformPromptLog(long traceId, PromptLog promptLog) {
        long flowId = promptLog.getFlowId();
        long nodeId = promptLog.getNodeId();
        String taskId = promptLog.getTaskId();
        String llmParamString = promptLog.getLlmParamString();
        String chatSessionId = promptLog.getChatSessionId();
        Prompt prompt = promptLog.getPrompt();
        String modelName = promptLog.getModelName();
        String userInput = promptLog.getUserInput();
        long start = promptLog.getStart();
        long end = promptLog.getEnd();
        long userId = RequestContext.get().getCurrUserId();
        if (!kd.bos.util.StringUtils.isEmpty((String)taskId)) {
            EngineCache.getAppCache(taskId).put(LLM_TASK_LLM_INPUT + taskId, (Object)llmParamString);
        }
        IAppCache appCache = EngineCache.getAppCache(chatSessionId);
        String sessionId = (String)appCache.get(TraceUtil.chatSessionKey(chatSessionId), String.class);
        long processId = 0L;
        Process process = null;
        if (flowId != 0L) {
            String pid = (String)appCache.get(TraceUtil.flowProcessKey(flowId), String.class);
            processId = kd.bos.util.StringUtils.isEmpty((String)pid) ? 0L : Long.parseLong(pid);
            process = ProcessService.getProcessById(processId);
        }
        String trace = String.valueOf(traceId);
        String appId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceAppKey(traceId), String.class), (String)"");
        String cloudId = kd.bos.util.StringUtils.getStringValue((Object)appCache.get(TraceUtil.traceCloudKey(traceId), String.class), (String)"");
        String tags = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptTags(process, prompt));
        String metadata = JSONObject.toJSONString((Object)TraceUtil.buildLLMPromptMetadata(prompt));
        StepLog stepLog = TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, trace, modelName, userId, processId, tags, metadata, nodeId, Constant.StepType.GPT_PROMPT.getType(), userInput, llmParamString, start, end, System.currentTimeMillis());
        return stepLog;
    }

    private static String parseModelName(Prompt prompt, String userInput) {
        List<Long> repoIdList = prompt.getRepoIds();
        logger.info("\u4e0a\u4e0b\u6587repoIdList:{}", JSON.toJSON(repoIdList));
        if (repoIdList != null && !repoIdList.isEmpty() && !StringUtils.isEmpty((CharSequence)userInput)) {
            RepoVO repoInfo = RepoService.getRepoInfo(repoIdList.get(0));
            LLM embeddingModel = repoInfo.getLlm();
            return embeddingModel.getNumber();
        }
        return "";
    }

    private static StepLog buildStepLog(String cloudId, String appId, String chatSessionId, String sessionId, String traceId, String modelName, long userId, long processId, String tags, String metadata, long nodeId, String stepType, String stepInput, String stepOutput, long start, long end, long createTime) {
        return TraceUtil.buildStepLog(cloudId, appId, chatSessionId, sessionId, traceId, modelName, userId, processId, tags, metadata, nodeId, stepType, stepInput, stepOutput, start, end, createTime, 0);
    }

    private static StepLog buildStepLog(String cloudId, String appId, String chatSessionId, String sessionId, String traceId, String modelName, long userId, long processId, String tags, String metadata, long nodeId, String stepType, String stepInput, String stepOutput, long start, long end, long createTime, int token) {
        logger.info("\u4fdd\u5b58Step\u65e5\u5fd7,cloudId({}),appId({}),chatSessionId({}),processId({}),nodeId({}),stepType({})", new Object[]{cloudId, appId, chatSessionId, processId, nodeId, stepType});
        StepLog stepLog = new StepLog();
        stepLog.setChatSessionId(chatSessionId);
        stepLog.setSessionId(kd.bos.util.StringUtils.isEmpty((String)sessionId) ? 0L : Long.parseLong(sessionId));
        stepLog.setTraceId(kd.bos.util.StringUtils.isEmpty((String)traceId) ? 0L : Long.parseLong(traceId));
        stepLog.setUserId(userId);
        stepLog.setCloudId(cloudId);
        stepLog.setAppId(appId);
        stepLog.setModelName(modelName);
        stepLog.setTags(tags);
        stepLog.setGptProcessId(processId);
        stepLog.setGptProcessNodeId(nodeId);
        stepLog.setStepType(stepType);
        stepLog.setStepOutput(stepOutput);
        stepLog.setStepInput(stepInput);
        stepLog.setMetadata(metadata);
        stepLog.setStepBeginTime(new Date(start));
        stepLog.setStepFinishTime(new Date(end));
        stepLog.setTotalToken(token);
        stepLog.setLatency(new BigDecimal(end - start).setScale(0));
        stepLog.setCreateTime(createTime == 0L ? new Date() : new Date(createTime));
        return stepLog;
    }

    private static JSONObject buildLLMPromptMetadata(Prompt prompt) {
        JSONObject object = new JSONObject();
        object.put("prompt", (Object)prompt);
        return object;
    }

    private static JSONObject buildProcessTags(Process process) {
        JSONObject object = new JSONObject();
        if (process != null) {
            object.put("process", (Object)new JSONObject());
            object.getJSONObject("process").put("number", (Object)process.getNumber());
            object.getJSONObject("process").put("name", (Object)process.getName());
        }
        return object;
    }

    private static JSONObject buildResultTags(JSONObject tagObject, String errCode) {
        JSONObject object = new JSONObject();
        object.put("errCode", (Object)errCode);
        tagObject.put("result", (Object)object);
        return tagObject;
    }

    private static JSONObject buildLLMPromptTags(Process process, Prompt prompt) {
        JSONObject object = TraceUtil.buildProcessTags(process);
        if (prompt != null) {
            object.put("prompt", (Object)new JSONObject());
            object.getJSONObject("prompt").put("number", (Object)prompt.getNumber());
            object.getJSONObject("prompt").put("name", (Object)prompt.getName());
        }
        return object;
    }

    private static String flowTraceKey(long flowId) {
        return String.format("FLOW-TRACE-%s", flowId);
    }

    private static String chatSessionKey(String chatSessionId) {
        return String.format("CHAT-SESSION-%s", chatSessionId);
    }

    private static String flowProcessKey(long flowId) {
        return String.format("FLOW-PROCESS-%s", flowId);
    }

    private static String traceCloudKey(long traceId) {
        return TraceUtil.traceCloudKey(String.valueOf(traceId));
    }

    private static String traceCloudKey(String traceId) {
        return String.format("TRACE-CLOUD-%s", traceId);
    }

    private static String traceAppKey(long traceId) {
        return TraceUtil.traceAppKey(String.valueOf(traceId));
    }

    private static String traceAppKey(String traceId) {
        return String.format("TRACE-APP-%s", traceId);
    }
}

