/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import java.util.Arrays;
import kd.ai.gai.core.trust.analyzer.NumberRecognizer;
import kd.ai.gai.core.trust.model.EntityType;

public class CreditCardRecognizer
extends NumberRecognizer {
    public CreditCardRecognizer(String name) {
        super(name, EntityType.CREDIT_CARD, Arrays.asList("en", "zh"), Arrays.asList("\u4fe1\u7528\u5361", "\u94f6\u884c\u5361\u53f7", "bank", "\u94f6\u884c"));
        this.addPattern("(?:(36\\d{2}[- ]?\\d{4}[- ]?\\d{4}[- ]?\\d{2}))", 0.4f);
        this.addPattern("(?:(36\\d{4}[- ]\\d{8}))", 0.4f);
        this.addPattern("(?:(37\\d{2}[- ]?\\d{4}[- ]?\\d{4}[- ]?\\d{3}))", 0.4f);
        this.addPattern("(?:(37\\d{2}[- ]\\d{6}[- ]?\\d{5}))", 0.4f);
        this.addPattern("(?:(37\\d{4}[- ]\\d{9}))", 0.4f);
        this.addPattern("(?:(1\\d{3}[- ]?\\d{4}[- ]?\\d{4}[- ]?\\d{4}[- ]?\\d{2,3}))", 0.4f);
        this.addPattern("(?:(1\\d{5}[- ]\\d{10}[- ]?\\d{2,3}))", 0.4f);
        this.addPattern("(?:([345689]\\d{3}[- ]?\\d{4}[- ]?\\d{4}[- ]?\\d{4}([- ]?\\d{1,3})?))", 0.4f);
        this.addPattern("(?:([345689]\\d{5}[- ]\\d{10}([- ]?\\d{1,3})?))", 0.4f);
    }

    @Override
    protected boolean invalidateResult(String text, String match, int start, int end) {
        boolean bInvalid = false;
        if (start > 0) {
            char previousChar = text.charAt(start - 1);
            boolean bl = bInvalid = CreditCardRecognizer.isInvalidPunctuationSymbol(previousChar) || CreditCardRecognizer.isNumber(previousChar);
        }
        if (end < text.length()) {
            char nextChar = text.charAt(end);
            bInvalid = bInvalid || CreditCardRecognizer.isInvalidPunctuationSymbol(nextChar) || CreditCardRecognizer.isNumber(nextChar);
        }
        return bInvalid;
    }
}

