/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import com.huaban.analysis.jieba.JiebaSegmenter;
import com.huaban.analysis.jieba.SegToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import kd.ai.gai.core.trust.analyzer.AbcRecognizer;
import kd.ai.gai.core.trust.analyzer.StopWords;
import kd.ai.gai.core.trust.model.EntityType;
import kd.ai.gai.core.trust.model.Lemma;
import kd.ai.gai.core.trust.model.RecognizerResult;

public class LemmaContextAwareEnhancer {
    private float contextSimilarityFactor = 0.35f;
    private float minScoreWithContextSimilarity = 0.4f;
    private int contextPrefixCount = 5;
    private int contextSuffixCount = 0;

    public void setContextSimilarityFactor(float contextSimilarityFactor) {
        this.contextSimilarityFactor = contextSimilarityFactor;
    }

    public void setMinScoreWithContextSimilarity(float minScoreWithContextSimilarity) {
        this.minScoreWithContextSimilarity = minScoreWithContextSimilarity;
    }

    public void setContextPrefixCount(int contextPrefixCount) {
        this.contextPrefixCount = contextPrefixCount;
    }

    public void setContextSuffixCount(int contextSuffixCount) {
        this.contextSuffixCount = contextSuffixCount;
    }

    private List<Lemma> processText(String text) {
        JiebaSegmenter segmenter = new JiebaSegmenter();
        List segTokenList = segmenter.process(text, JiebaSegmenter.SegMode.SEARCH);
        ArrayList<Lemma> rtn = new ArrayList<Lemma>(segTokenList.size());
        for (SegToken segToken : segTokenList) {
            Lemma lemma = new Lemma(segToken.word, segToken.startOffset, segToken.endOffset);
            rtn.add(lemma);
        }
        return rtn;
    }

    public List<RecognizerResult> enhanceUsingContext(String text, List<RecognizerResult> results, List<AbcRecognizer> recognizers) {
        HashMap<String, AbcRecognizer> recognizerMap = new HashMap<String, AbcRecognizer>(recognizers.size());
        for (AbcRecognizer recognizer : recognizers) {
            recognizerMap.put(recognizer.getId(), recognizer);
        }
        List<Lemma> lemmas = this.processText(text);
        for (RecognizerResult result : results) {
            List<String> surroundingWords;
            int supportiveWordIndex;
            AbcRecognizer recognizer;
            if (result.isEnhanced() || result.getRecognizerId() == null || (recognizer = (AbcRecognizer)recognizerMap.get(result.getRecognizerId())) == null || recognizer.getContext() == null || recognizer.getContext().isEmpty() || (supportiveWordIndex = this.findSupportiveWordIndexInContext(surroundingWords = this.extractSurroundingWords(lemmas, result.getEntityType(), result.getText(), result.getStart()), recognizer.getContext())) <= -1) continue;
            float score = result.getScore() + this.contextSimilarityFactor;
            score = Float.max(score, this.minScoreWithContextSimilarity);
            score = Float.min(score, 1.0f);
            result.setScore(score);
            result.setEnhanced(true);
        }
        return results;
    }

    private int findSupportiveWordIndexInContext(List<String> contextList, List<String> recognizerContextList) {
        int rtn = -1;
        if (contextList == null || recognizerContextList == null) {
            return rtn;
        }
        int len = contextList.size();
        for (int i = 0; i < len; ++i) {
            if (!recognizerContextList.contains(contextList.get(i))) continue;
            rtn = i;
            break;
        }
        return rtn;
    }

    private List<String> processKeyWords(List<Lemma> lemmas) {
        ArrayList<String> rtn = new ArrayList<String>(lemmas.size());
        for (Lemma lemma : lemmas) {
            if (StopWords.getInstance().isStopWord(lemma.getWord())) continue;
            rtn.add(lemma.getWord());
        }
        return rtn;
    }

    private List<String> extractSurroundingWords(List<Lemma> lemmas, EntityType entityType, String word, int start) {
        int tokenIndex = this.findIndexOfMatchToken(word, start, lemmas);
        List<String> keywords = this.processKeyWords(lemmas);
        int prefixCount = this.contextPrefixCount;
        if (entityType == EntityType.SYSTEM_ID && prefixCount > 2) {
            prefixCount = 2;
        }
        List<String> backwardContext = this.addNWordsBackward(tokenIndex, prefixCount, lemmas, keywords);
        List<String> forwardContext = this.addNWordsForward(tokenIndex, this.contextSuffixCount, lemmas, keywords);
        LinkedHashSet<String> contextSet = new LinkedHashSet<String>();
        contextSet.addAll(backwardContext);
        contextSet.addAll(forwardContext);
        return new ArrayList<String>(contextSet);
    }

    private int findIndexOfMatchToken(String word, int start, List<Lemma> lemmas) {
        boolean found = false;
        int i = -1;
        for (i = 0; i < lemmas.size(); ++i) {
            if (lemmas.get(i).getStart() != start && start >= lemmas.get(i).getStart() + lemmas.get(i).getWord().length()) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("Did not find word '" + word + "' in the list of tokens although it is expected to be found");
        }
        return i;
    }

    private List<String> addNWords(int index, int nWords, List<Lemma> lemmas, List<String> keywords, boolean isBackward) {
        int i = index;
        ArrayList<String> contextWords = new ArrayList<String>();
        int remaining = nWords + 1;
        while (i >= 0 && i < lemmas.size() && remaining > 0) {
            String lowerLemma = lemmas.get(i).getWord().toLowerCase();
            if (keywords.contains(lowerLemma)) {
                contextWords.add(lowerLemma);
                --remaining;
            }
            i = isBackward ? i - 1 : i + 1;
        }
        return contextWords;
    }

    private List<String> addNWordsForward(int index, int nWords, List<Lemma> lemmas, List<String> keywords) {
        return this.addNWords(index, nWords, lemmas, keywords, false);
    }

    private List<String> addNWordsBackward(int index, int nWords, List<Lemma> lemmas, List<String> keywords) {
        return this.addNWords(index, nWords, lemmas, keywords, true);
    }
}

