/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import kd.ai.gai.core.trust.analyzer.AbcRecognizer;
import kd.ai.gai.core.trust.model.EntityType;
import kd.ai.gai.core.trust.model.Pattern;
import kd.ai.gai.core.trust.model.RecognizerResult;
import kd.ai.gai.core.trust.tools.RecognizerTools;

public class NumberRecognizer
extends AbcRecognizer {
    private final List<Pattern> patterns = new ArrayList<Pattern>(2);

    public NumberRecognizer(String name, EntityType supportedEntity, List<String> supportedLanguage, List<String> context) {
        super(name, supportedEntity, supportedLanguage, context);
    }

    public void addPattern(String regex, float score) {
        this.patterns.add(new Pattern(regex, score));
    }

    public void addPattern(List<Pattern> patterns) {
        this.patterns.addAll(patterns);
    }

    @Override
    public List<RecognizerResult> analyze(String text) {
        if (this.patterns != null && !this.patterns.isEmpty()) {
            return this.analyzePatterns(text);
        }
        return Collections.emptyList();
    }

    private List<RecognizerResult> analyzePatterns(String text) {
        List<RecognizerResult> results = new ArrayList<RecognizerResult>();
        for (Pattern pattern : this.patterns) {
            String patternString = "(?:\\\\t|\\\\n){0,1}" + pattern.getRegex();
            Matcher matcher = java.util.regex.Pattern.compile(patternString).matcher(text);
            int index = 0;
            while (matcher.find(index)) {
                int start = matcher.start();
                int end = matcher.end();
                index = start + 1;
                String currentMatch = text.substring(start, end);
                if (currentMatch.startsWith("\\t") || currentMatch.startsWith("\\n")) {
                    index = (start += 2) + 1;
                    currentMatch = text.substring(start, end);
                }
                if (currentMatch.isEmpty()) continue;
                float score = pattern.getScore();
                if (this.invalidateResult(text, currentMatch, start, end)) continue;
                RecognizerResult patternResult = new RecognizerResult(this.getSupportedEntity(), currentMatch, start, end, score);
                patternResult.setRecognizerId(this.getId());
                if (!(patternResult.getScore() > 0.0f)) continue;
                index = end;
                results.add(patternResult);
            }
        }
        results = RecognizerTools.removeDuplicates(results);
        return results;
    }

    protected boolean invalidateResult(String text, String match, int start, int end) {
        char nextChar;
        char previousChar;
        if (start > 0 && (NumberRecognizer.isInvalidPunctuationSymbol(previousChar = text.charAt(start - 1)) || NumberRecognizer.isLatinLetter(previousChar))) {
            return true;
        }
        return end < text.length() && (NumberRecognizer.isInvalidPunctuationSymbol(nextChar = text.charAt(end)) || NumberRecognizer.isLatinLetter(nextChar) || NumberRecognizer.isNumber(nextChar));
    }

    protected static boolean isInvalidPunctuationSymbol(char character) {
        return character == '%' || Character.getType(character) == 26;
    }

    protected static boolean isLatinLetter(char letter) {
        if (!Character.isLetter(letter) && Character.getType(letter) != 6) {
            return false;
        }
        Character.UnicodeBlock block = Character.UnicodeBlock.of(letter);
        return block.equals(Character.UnicodeBlock.BASIC_LATIN) || block.equals(Character.UnicodeBlock.LATIN_1_SUPPLEMENT) || block.equals(Character.UnicodeBlock.LATIN_EXTENDED_A) || block.equals(Character.UnicodeBlock.LATIN_EXTENDED_ADDITIONAL) || block.equals(Character.UnicodeBlock.LATIN_EXTENDED_B) || block.equals(Character.UnicodeBlock.COMBINING_DIACRITICAL_MARKS);
    }

    protected static boolean isNumber(char character) {
        return character >= '0' && character <= '9';
    }
}

