/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import kd.ai.gai.core.trust.analyzer.AbcRecognizer;
import kd.ai.gai.core.trust.model.EntityType;
import kd.ai.gai.core.trust.model.Pattern;
import kd.ai.gai.core.trust.model.RecognizerResult;
import kd.ai.gai.core.trust.tools.RecognizerTools;

public class PatternRecognizer
extends AbcRecognizer {
    private List<Pattern> patterns;
    private List<String> denyList;
    private float denyListScore;

    public PatternRecognizer(String name, EntityType supportedEntity, List<String> supportedLanguage, List<Pattern> patterns, List<String> context) {
        this(name, supportedEntity, supportedLanguage, patterns, context, null, 0.0f);
    }

    public PatternRecognizer(String name, EntityType supportedEntity, List<String> supportedLanguage, List<Pattern> patterns, List<String> context, List<String> denyList, float denyListScore) {
        super(name, supportedEntity, supportedLanguage, context);
        this.patterns = patterns;
        this.denyList = denyList;
        this.denyListScore = denyListScore;
        if (denyList != null && !denyList.isEmpty()) {
            Pattern denyListPattern = this.denyListToRegex();
            if (this.patterns == null) {
                this.patterns = new ArrayList<Pattern>(1);
            }
            this.patterns.add(denyListPattern);
        }
    }

    private Pattern denyListToRegex() {
        ArrayList<String> escapedDenyList = new ArrayList<String>(this.denyList.size());
        for (String element : this.denyList) {
            escapedDenyList.add(java.util.regex.Pattern.quote(element));
        }
        String joinedRegex = String.join((CharSequence)"|", escapedDenyList);
        String regex = "(?:^|(?<=\\W))(" + joinedRegex + ")(?:(?=\\W)|$)";
        return new Pattern(regex, this.denyListScore);
    }

    @Override
    public List<RecognizerResult> analyze(String text) {
        if (this.patterns != null && !this.patterns.isEmpty()) {
            return this.analyzePatterns(text);
        }
        return Collections.emptyList();
    }

    private List<RecognizerResult> analyzePatterns(String text) {
        List<RecognizerResult> results = new ArrayList<RecognizerResult>();
        for (Pattern pattern : this.patterns) {
            String patternString = "(?:\\\\t|\\\\n){0,1}" + pattern.getRegex();
            Matcher matcher = java.util.regex.Pattern.compile(patternString).matcher(text);
            int index = 0;
            while (matcher.find(index)) {
                int start = matcher.start();
                int end = matcher.end();
                index = start + 1;
                String currentMatch = text.substring(start, end);
                if (currentMatch.startsWith("\\t") || currentMatch.startsWith("\\n")) {
                    index = (start += 2) + 1;
                    currentMatch = text.substring(start, end);
                }
                if (currentMatch.isEmpty()) continue;
                float score = pattern.getScore();
                RecognizerResult patternResult = new RecognizerResult(this.getSupportedEntity(), currentMatch, start, end, score);
                patternResult.setRecognizerId(this.getId());
                if (!(patternResult.getScore() > 0.0f)) continue;
                index = end;
                results.add(patternResult);
            }
        }
        results = RecognizerTools.removeDuplicates(results);
        return results;
    }
}

