/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.analyzer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.ai.gai.core.trust.analyzer.AbcRecognizer;
import kd.ai.gai.core.trust.analyzer.NumberRecognizer;
import kd.ai.gai.core.trust.analyzer.PatternRecognizer;
import kd.ai.gai.core.trust.model.EntityType;
import kd.ai.gai.core.trust.model.Pattern;

public class PatternRecognizerBuilder {
    private final List<Pattern> patterns = new ArrayList<Pattern>(1);
    private final String name;
    private final EntityType supportedEntity;
    private final List<String> supportedLanguage = new ArrayList<String>(1);
    private final List<String> context = new ArrayList<String>(1);
    private boolean isNumberRecognizer = false;

    private PatternRecognizerBuilder(String name, EntityType supportedEntity) {
        this.name = name;
        this.supportedEntity = supportedEntity;
    }

    public static PatternRecognizerBuilder newBuilder(String name, EntityType supportedEntity) {
        return new PatternRecognizerBuilder(name, supportedEntity);
    }

    public PatternRecognizerBuilder addSupportedLanguage(String ... lang) {
        Collections.addAll(this.supportedLanguage, lang);
        return this;
    }

    public PatternRecognizerBuilder addPattern(String regex, float score) {
        this.patterns.add(new Pattern(regex, score));
        return this;
    }

    public PatternRecognizerBuilder addContext(String ... context) {
        Collections.addAll(this.context, context);
        return this;
    }

    public PatternRecognizerBuilder numberRecognizer() {
        this.isNumberRecognizer = true;
        return this;
    }

    public AbcRecognizer build() {
        if (this.isNumberRecognizer) {
            NumberRecognizer recognizer = new NumberRecognizer(this.name, this.supportedEntity, this.supportedLanguage, this.context);
            recognizer.addPattern(this.patterns);
            return recognizer;
        }
        return new PatternRecognizer(this.name, this.supportedEntity, this.supportedLanguage, this.patterns, this.context);
    }
}

