/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.masking;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.ai.gai.core.trust.masking.Faker;
import kd.ai.gai.core.trust.model.EntityType;
import kd.ai.gai.core.trust.model.MaskingInfo;
import kd.ai.gai.core.trust.model.MaskingResult;
import kd.ai.gai.core.trust.model.RecognizerResult;
import kd.bos.util.StringUtils;

public class MaskingEngine {
    private String findOrGenFakeVal(String realVal, EntityType entityType, Set<String> allVal, MaskingResult maskingResult) {
        String fakeValue;
        for (MaskingInfo maskingInfo : maskingResult.getInfos()) {
            if (entityType != maskingInfo.getEntityType() || !realVal.equals(maskingInfo.getText())) continue;
            return maskingInfo.getFakeValue();
        }
        while (StringUtils.isNotEmpty((String)(fakeValue = Faker.fakeByType(entityType))) && !allVal.add(fakeValue)) {
        }
        return fakeValue;
    }

    public MaskingResult masking(String text, List<RecognizerResult> analyzeResult) {
        return this.masking(text, analyzeResult, null);
    }

    public MaskingResult masking(String text, List<RecognizerResult> analyzeResult, Set<MaskingInfo> maskingInfos) {
        HashSet<String> allVal = new HashSet<String>(analyzeResult.size());
        for (RecognizerResult result : analyzeResult) {
            allVal.add(result.getText());
        }
        String resultText = text;
        MaskingResult maskingResult = new MaskingResult();
        if (maskingInfos != null) {
            maskingResult.setInfos(maskingInfos);
            for (MaskingInfo maskingInfo : maskingInfos) {
                allVal.add(maskingInfo.getFakeValue());
            }
        }
        for (int i = analyzeResult.size() - 1; i >= 0; --i) {
            RecognizerResult result = analyzeResult.get(i);
            EntityType entityType = result.getEntityType();
            String fakeValue = this.findOrGenFakeVal(result.getText(), entityType, allVal, maskingResult);
            if (StringUtils.isEmpty((String)fakeValue)) continue;
            resultText = resultText.substring(0, result.getStart()) + fakeValue + resultText.substring(result.getEnd());
            MaskingInfo maskingInfo = new MaskingInfo();
            maskingInfo.setText(result.getText());
            maskingInfo.setEntityType(entityType);
            maskingInfo.setFakeValue(fakeValue);
            maskingResult.getInfos().add(maskingInfo);
        }
        maskingResult.setMaskingText(resultText);
        return maskingResult;
    }

    public String deMasking(String text, List<RecognizerResult> analyzeResult, Set<MaskingInfo> maskingInfoList) {
        String resultText = text;
        for (int i = analyzeResult.size() - 1; i >= 0; --i) {
            RecognizerResult result = analyzeResult.get(i);
            EntityType entityType = result.getEntityType();
            String fakeValue = result.getText();
            boolean found = false;
            String realValue = "";
            for (MaskingInfo maskingInfo : maskingInfoList) {
                if (entityType != maskingInfo.getEntityType() || !fakeValue.equals(maskingInfo.getFakeValue())) continue;
                realValue = maskingInfo.getText();
                found = true;
                break;
            }
            if (!found) continue;
            resultText = resultText.substring(0, result.getStart()) + realValue + resultText.substring(result.getEnd());
        }
        return resultText;
    }
}

