/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.trust.tools;

import java.util.ArrayList;
import java.util.List;
import kd.ai.gai.core.trust.model.RecognizerResult;

public class RecognizerTools {
    public static void sortStartEnd(List<RecognizerResult> list) {
        list.sort((o1, o2) -> {
            int compare = Integer.compare(o1.getStart(), o2.getStart());
            if (compare == 0) {
                compare = Integer.compare(o2.getEnd(), o1.getEnd());
            }
            return compare;
        });
    }

    public static void sortScoreStartEnd(List<RecognizerResult> list) {
        list.sort((o1, o2) -> {
            int compare = Float.compare(o2.getScore(), o1.getScore());
            if (compare == 0 && (compare = Integer.compare(o1.getStart(), o2.getStart())) == 0) {
                compare = Integer.compare(o2.getEnd(), o1.getEnd());
            }
            return compare;
        });
    }

    public static List<RecognizerResult> removeDuplicates(List<RecognizerResult> results) {
        ArrayList<RecognizerResult> filteredResults = new ArrayList<RecognizerResult>();
        RecognizerTools.sortScoreStartEnd(results);
        for (RecognizerResult result : results) {
            boolean toKeep;
            if (result.getScore() == 0.0f) continue;
            boolean bl = toKeep = !filteredResults.contains(result);
            if (toKeep) {
                for (RecognizerResult filtered : filteredResults) {
                    if (!filtered.contains(result) || result.getEntityType() != filtered.getEntityType()) continue;
                    toKeep = false;
                    break;
                }
            }
            if (!toKeep) continue;
            filteredResults.add(result);
        }
        return filteredResults;
    }
}

