/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.ai.gai.core.domain.dto.Prompt;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.HexUtils;

public class Encrypt {
    private static final Log log = LogFactory.getLog(Encrypt.class);
    private static final String ERR_CODE = "gai.encrypt.000001";
    private static final String ERR_CODE2 = "gai.encrypt.000002";

    private Encrypt() {
    }

    public static String encrypt(Prompt prompt) {
        byte[] encryptData1;
        Encrypt.checkParameter(prompt);
        Key key = Encrypt.genKey(prompt);
        try {
            encryptData1 = Encrypt.encrypt(key, prompt.getPrompt().getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(new ErrorCode(ERR_CODE2, e.getMessage()), new Object[0]);
        }
        return Encrypters.encode((String)HexUtils.toHex((byte[])encryptData1));
    }

    private static void checkParameter(Prompt prompt) {
        if (prompt == null) {
            throw new KDBizException(new ErrorCode(ERR_CODE, "prompt parameter is null"), new Object[0]);
        }
        if (prompt.getId() == 0L) {
            throw new KDBizException(new ErrorCode(ERR_CODE, "prompt.id parameter is null"), new Object[0]);
        }
        if (prompt.getCreateTime() == null) {
            throw new KDBizException(new ErrorCode(ERR_CODE, "prompt.createTime parameter is null"), new Object[0]);
        }
        if (prompt.getPrompt() == null) {
            throw new KDBizException(new ErrorCode(ERR_CODE, "prompt.Prompt parameter is null"), new Object[0]);
        }
    }

    private static Key genKey(Prompt prompt) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String s2 = prompt.getCreateTime() == null ? "null" : simpleDateFormat.format(prompt.getCreateTime());
        String k = String.format("%s-%s", prompt.getId(), s2);
        byte[] data = Hashing.sha512().hashString((CharSequence)k, StandardCharsets.UTF_8).asBytes();
        byte[] aesKeyBytes = new byte[32];
        System.arraycopy(data, 0, aesKeyBytes, 0, aesKeyBytes.length);
        return new SecretKeySpec(aesKeyBytes, "AES");
    }

    private static byte[] encrypt(Key key, byte[] message) throws NoSuchAlgorithmException, NoSuchPaddingException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, InvalidKeyException {
        SecureRandom sr = SecureRandom.getInstanceStrong();
        byte[] iv = sr.generateSeed(16);
        GCMParameterSpec ivParameterSpec = new GCMParameterSpec(128, iv);
        Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
        cipher.init(1, key, ivParameterSpec);
        byte[] data = cipher.doFinal(message);
        byte[] r = new byte[iv.length + data.length];
        System.arraycopy(iv, 0, r, 0, iv.length);
        System.arraycopy(data, 0, r, iv.length, data.length);
        return r;
    }
}

