/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;

public class GaiCacheManager {
    private GaiCacheManager() {
    }

    public static GaiCacheManager get() {
        return Holder.instance;
    }

    public static LocalMemoryCache getMessageCache() {
        return Holder.localMemoryCache;
    }

    public String get(String key) {
        IAppCache cache = this.getAppCache();
        return (String)cache.get(this.addSessionKeyPrefix(key), String.class);
    }

    public void put(String key, String value) {
        IAppCache cache = this.getAppCache();
        cache.put(this.addSessionKeyPrefix(key), (Object)value);
    }

    public void remove(String key) {
        IAppCache cache = this.getAppCache();
        cache.remove(this.addSessionKeyPrefix(key));
    }

    private String addSessionKeyPrefix(String key) {
        return RequestContext.get().getGlobalSessionId() + "." + key;
    }

    public IAppCache getAppCache() {
        return AppCache.get((String)String.format("ai-gai.%s", RequestContext.get().getTenantId()));
    }

    public LocalMemoryCache getLocalMemoryCache(String region, String type, boolean timeToLive, int timeout, int maxMemSize) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeToLive(timeToLive);
        info.setTimeout(timeout);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(region, type, info);
    }

    private static class Holder {
        private static GaiCacheManager instance = new GaiCacheManager();
        private static LocalMemoryCache localMemoryCache = new GaiCacheManager().getLocalMemoryCache(RequestContext.get().getAccountId(), "gai", true, 180, 200);

        private Holder() {
        }
    }
}

