/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.field.type.OutFieldType;
import kd.ai.gai.core.enuz.field.type.VarFieldType;
import kd.ai.gai.core.service.AiccService;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;

public class GaiFieldTypeInitUtils {
    public static List<ComboItem> createLlmComboItem() {
        List<Map<String, Object>> serviceList = AiccService.getLlmList();
        ArrayList<ComboItem> list = new ArrayList<ComboItem>(serviceList.size());
        for (Map<String, Object> service : serviceList) {
            ComboItem comboItem = new ComboItem();
            if (Boolean.TRUE.equals(service.get("active"))) {
                comboItem.setCaption(new LocaleString(service.get("name") + "\uff08\u5b9e\u4f8b\u5df2\u914d\u7f6e\uff09"));
            } else {
                comboItem.setCaption(new LocaleString(service.get("name") + "\uff08\u5b9e\u4f8b\u672a\u914d\u7f6e\uff09"));
            }
            comboItem.setValue((String)service.get("number"));
            list.add(comboItem);
        }
        return list;
    }

    public static List<ComboItem> createEmbeddingComboItem() {
        LLM[] llms = LLM.values();
        if (llms.length > 0) {
            List<String> instanceList = AiccService.getAiccInstanceListWithInstance();
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(llms.length);
            for (LLM llm : llms) {
                if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING) continue;
                ComboItem comboItem = new ComboItem();
                if (instanceList.contains(llm.getNumber())) {
                    comboItem.setCaption(new LocaleString(llm.getName() + "\uff08\u5b9e\u4f8b\u5df2\u914d\u7f6e\uff09"));
                } else {
                    comboItem.setCaption(new LocaleString(llm.getName() + "\uff08\u5b9e\u4f8b\u672a\u914d\u7f6e\uff09"));
                }
                comboItem.setValue(llm.getNumber());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.LANGUAGE_MODEL_INIT_ERROR.getCode(), GaiErrorCode.LANGUAGE_MODEL_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    public static List<ComboItem> createVarTypeComboItem() {
        VarFieldType[] types = VarFieldType.values();
        if (Objects.nonNull(types) && types.length > 0) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(types.length);
            for (VarFieldType type : types) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(type.getName()));
                comboItem.setValue(type.getType());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.VAR_FIELD_TYPE_INIT_ERROR.getCode(), GaiErrorCode.VAR_FIELD_TYPE_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }

    public static List<ComboItem> createOutTypeComboItem() {
        OutFieldType[] types = OutFieldType.values();
        if (Objects.nonNull(types) && types.length > 0) {
            ArrayList<ComboItem> list = new ArrayList<ComboItem>(types.length);
            for (OutFieldType type : types) {
                ComboItem comboItem = new ComboItem();
                comboItem.setCaption(new LocaleString(type.getName()));
                comboItem.setValue(type.getType());
                list.add(comboItem);
            }
            return list;
        }
        ErrorCode errorCode = new ErrorCode(GaiErrorCode.OUT_FIELD_TYPE_INIT_ERROR.getCode(), GaiErrorCode.OUT_FIELD_TYPE_INIT_ERROR.getMsg());
        throw new KDBizException(errorCode, new Object[0]);
    }
}

