/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.enuz.BLG;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.util.StringUtils;

public class GaiLicenseUtils {
    private static final Log logger = LogFactory.getLog(GaiLicenseUtils.class);

    public static boolean currUserCanMservice() {
        RequestContext rc = RequestContext.get();
        long currUserId = rc.getCurrUserId();
        return GaiLicenseUtils.canGPTService(currUserId);
    }

    public static boolean userUseBLG(long userId, String blgids) {
        boolean use = false;
        Map info = LicenseServiceHelper.getProductInfo();
        String softwareCode = info.get("softwareCode") == null ? "" : (String)info.get("softwareCode");
        String version = LicenseServiceHelper.getProductVersion();
        logger.info("\u8bb8\u53ef\u7248\u672c\uff1a{}", (Object)version);
        if ("5.0".equals(version) && ("22CBDC6A72E84A23".equals(softwareCode) || "EA18D8E1CD665E25".equals(softwareCode))) {
            return true;
        }
        if (StringUtils.isNotEmpty((String)blgids)) {
            String[] ids;
            for (String id : ids = blgids.split(",")) {
                try {
                    long groupId = Long.parseLong(id);
                    if (!BLG.exists(groupId) || !(use = GaiLicenseUtils.checkUserUseGroupLic(userId, groupId))) continue;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new KDBizException(GaiExceptionUtil.buildErr(GaiErrorCode.LIC_BIND_DATA_ERR), new Object[0]);
                }
            }
        } else {
            use = GaiLicenseUtils.checkUserUseGroupLic(userId, BLG.GAI.getGroupId());
        }
        return use;
    }

    public static boolean canGPTService(Long userId) {
        String softwareCode;
        String version = LicenseServiceHelper.getProductVersion();
        logger.info("\u8bb8\u53ef\u7248\u672c\uff1a{}", (Object)version);
        if ("1.0".equals(version)) {
            return true;
        }
        Map info = LicenseServiceHelper.getProductInfo();
        String string = softwareCode = info.get("softwareCode") == null ? "" : (String)info.get("softwareCode");
        if ("5.0".equals(version) && ("22CBDC6A72E84A23".equals(softwareCode) || "EA18D8E1CD665E25".equals(softwareCode))) {
            return true;
        }
        boolean use = false;
        long currUserId = RequestContext.get().getCurrUserId();
        for (BLG blg : BLG.values()) {
            long groupId = blg.getGroupId();
            use = GaiLicenseUtils.checkUserUseGroupLic(currUserId, groupId);
            if (use) break;
        }
        return use;
    }

    public static boolean checkUserUseGroupLic(Long userId, long groupId) {
        int totalNumber = LicenseServiceHelper.getTotalNumber((Object)groupId);
        if (totalNumber > 0) {
            LicenseCheckResult licenseCheckResult = LicenseServiceHelper.checkUserInGroup((Long)userId, (Long)groupId);
            return licenseCheckResult.getHasLicense();
        }
        return false;
    }

    public static List<String> getUserBLG(Long userId) {
        ArrayList<String> userBlg = new ArrayList<String>(6);
        for (BLG b : BLG.values()) {
            long groupId = b.getGroupId();
            if (!GaiLicenseUtils.checkUserUseGroupLic(userId, groupId)) continue;
            userBlg.add(groupId + "");
        }
        return userBlg;
    }
}

