/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.Assistant;
import kd.ai.gai.core.domain.dto.GaiInitConfig;
import kd.ai.gai.core.domain.dto.Process;
import kd.ai.gai.core.domain.dto.agent.Agent;
import kd.ai.gai.core.domain.dto.agent.ChatUser;
import kd.ai.gai.core.domain.dto.agent.Question;
import kd.ai.gai.core.domain.vo.Skill;
import kd.ai.gai.core.domain.vo.SuggestedAskData;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.Errors;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.ai.gai.core.engine.message.StartFlowMessage;
import kd.ai.gai.core.enuz.BLG;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.service.AssistantService;
import kd.ai.gai.core.service.ProcessService;
import kd.ai.gai.core.service.SkillService;
import kd.ai.gai.core.service.agent.AgentService;
import kd.ai.gai.core.util.GaiLicenseUtils;
import kd.ai.gai.core.util.ShowFormUtil;
import kd.ai.gai.core.util.StrUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class GaiUtils {
    private static final Log log = LogFactory.getLog(GaiUtils.class);
    public static final String CHAT_SESSION_ID = "chatSessionId";
    public static final String START_PROCESS_MAP = "startProcessData";
    public static final String SLIDE = "slideEnv";

    public static Map<String, String> toMap(JSONObject json) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            map.put(key, String.valueOf(value));
        }
        return map;
    }

    public static Map<String, String> objectToMap(Object obj) {
        Field[] fields;
        if (obj == null) {
            return null;
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(16);
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            try {
                resultMap.put(field.getName(), (String)field.get(obj));
            }
            catch (IllegalAccessException e) {
                log.error((Throwable)e);
            }
        }
        return resultMap;
    }

    public static String buildUrlQueryString(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        try {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (sb.length() > 0) {
                    sb.append('&');
                }
                sb.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append('=').append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException("UTF-8 encoding not supported.");
        }
        return sb.toString();
    }

    public static Map<String, String> convertToStringMap(Map<String, Object> map) {
        if (map == null) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            String strValue = String.valueOf(value);
            result.put(key, strValue);
        }
        return result;
    }

    public static void showBillForm(IFormView view, String appId, String billFormId, String billPkId, String crossPageData) {
        ShowFormUtil.openBill(appId, billFormId, billPkId, view, crossPageData);
    }

    public static void openApp(IFormView view, String caption, String appNumber, String source, String entityNumber, String crossPageData) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNumber);
        String mainPageId = appInfo.getHomeId();
        if (!kd.bos.util.StringUtils.isEmpty((String)crossPageData)) {
            Map crossPageDataMap = (Map)JSON.parseObject((String)crossPageData, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            RootPageIdContext rootPageIdContext = new RootPageIdContext(mainPageId, null, crossPageDataMap);
            FlowCacheData.putRootPageId2ChatSessionId(mainPageId, rootPageIdContext);
        }
        FormShowParameter param = new FormShowParameter();
        param.setFormId("pc_main_console");
        param.setCaption(caption);
        param.setCustomParam("appNumber", (Object)appNumber);
        param.setCustomParam("source", (Object)source);
        param.setCustomParam("entityNumber", (Object)entityNumber);
        param.setCustomParam("crossPageData", (Object)crossPageData);
        param.getOpenStyle().setShowType(ShowType.NewWindow);
        view.showForm(param);
    }

    public static String getAppIdByPageId(String pageId) {
        IFormView formView = SessionManager.getCurrent().getViewNoPlugin(pageId);
        if (formView == null) {
            throw new KDBizException(Errors.getAppIdError(pageId, "form view"), new Object[0]);
        }
        IDataModel dataModel = formView.getModel();
        if (dataModel == null) {
            throw new KDBizException(Errors.getAppIdError(pageId, "data model"), new Object[0]);
        }
        MainEntityType entityType = dataModel.getDataEntityType();
        if (entityType == null) {
            throw new KDBizException(Errors.getAppIdError(pageId, "main entity type"), new Object[0]);
        }
        return entityType.getAppId();
    }

    public static void startProcess(long processId, Context context, Map<String, String> paramMap, String userInput) {
        Process process = ProcessService.getProcessById(processId);
        if (process == null) {
            log.info("\u6d41\u7a0b processId :{}\u4e0d\u5b58\u5728", (Object)processId);
            throw new KDBizException("\u6d41\u7a0b processId \uff1a" + processId + "\u4e0d\u5b58\u5728");
        }
        GaiUtils.startProcess(process, context, paramMap, userInput);
    }

    public static void startProcess(String processNumber, Context context, Map<String, String> paramMap, String userInput) {
        Process process = ProcessService.getProcessByNumber(processNumber);
        if (process == null) {
            log.info("\u6d41\u7a0b processId :{}\u4e0d\u5b58\u5728", (Object)processNumber);
            throw new KDBizException("\u6d41\u7a0b processId \uff1a" + processNumber + "\u4e0d\u5b58\u5728");
        }
        List<Skill> skills = context.getSkillList();
        if (skills == null || skills.isEmpty()) {
            log.info("\u8be5\u7528\u6237\u6ca1\u6709\u6743\u9650\u542f\u52a8\u8be5\u6d41\u7a0b\uff08\u8be5\u7528\u6237\u6ca1\u6709\u6743\u9650\u542f\u52a8\u4efb\u4f55\u6d41\u7a0b\uff09");
            throw new KDBizException("\u8be5\u7528\u6237\u6ca1\u6709\u6743\u9650\u542f\u52a8\u8be5\u6d41\u7a0b");
        }
        List ids = context.getSkillList().stream().map(Skill::getId).collect(Collectors.toList());
        if (!ids.contains(process.getId() + "")) {
            String blgs = process.getBlgs();
            if (blgs == null) {
                blgs = "606";
            }
            String[] blgidArr = blgs.split(",");
            StringBuilder tips = new StringBuilder("\u542f\u52a8").append(processNumber).append("\u6280\u80fd\u5931\u8d25\uff0c\u6ca1\u6709\u52a9\u624b");
            for (String blgId : blgidArr) {
                long bldId = Long.parseLong(blgId);
                BLG blg = BLG.parse(bldId);
                assert (blg != null);
                tips.append(blg.name()).append('\u6216');
            }
            String tipString = tips.toString();
            if (tipString.endsWith("\u6216")) {
                tipString = tipString.substring(0, tipString.length() - 1);
                tipString = tipString + "\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002";
            }
            log.info(tipString);
            throw new KDBizException(tipString);
        }
        GaiUtils.startProcess(process, context, paramMap, userInput);
    }

    public static void startProcess(Process process, Context context, Map<String, String> paramMap, String userInput) {
        StartFlowMessage startFlowMessage = new StartFlowMessage();
        startFlowMessage.setProcessId(process.getId());
        startFlowMessage.setChatSessionId(context.getChatSessionId());
        startFlowMessage.setInParams(paramMap);
        if (kd.bos.util.StringUtils.isNotEmpty((String)userInput)) {
            startFlowMessage.setUserInput(userInput);
        }
        Result result = HandlerFactory.runHandler(context, startFlowMessage);
        log.info("\u542f\u52a8\u6d41\u7a0bprocess ({})\uff1a{}", (Object)process.getNumber(), JSON.toJSON((Object)result));
    }

    public static String getCurrentBizAppId(IFormView thisView) {
        IFormView mainView = thisView.getMainView();
        if (null == mainView) {
            if (thisView.getParentView() == null) {
                return null;
            }
            if (thisView.getParentView().getModel() == null) {
                return null;
            }
            if (thisView.getParentView().getModel().getDataEntityType() == null) {
                return null;
            }
            return thisView.getParentView().getModel().getDataEntityType().getBizAppNumber();
        }
        Tab tabap = (Tab)mainView.getControl("tabap");
        String appPageId = tabap.getCurrentTab();
        if (appPageId != null && appPageId.length() < 30) {
            return "main";
        }
        IFormView view = thisView.getViewNoPlugin(appPageId);
        if (view == null) {
            return null;
        }
        String appId = view.getModel().getDataEntityType().getBizAppNumber();
        return appId;
    }

    public static String getCurrentBizPageId(IFormView thisView) {
        IFormView mainView = thisView.getMainView();
        if (null == mainView) {
            if (thisView.getParentView() != null) {
                return thisView.getParentView().getPageId();
            }
        } else {
            Tab tabap = (Tab)mainView.getControl("tabap");
            String appPageId = tabap.getCurrentTab();
            if (appPageId != null && appPageId.length() < 30) {
                return "main";
            }
            IFormView view = thisView.getViewNoPlugin(appPageId);
            if (view == null) {
                return null;
            }
            Tab submaintab = (Tab)view.getControl("_submaintab_");
            if (submaintab != null) {
                return submaintab.getCurrentTab();
            }
            return view.getFormShowParameter().getPageId();
        }
        return thisView.getPageId();
    }

    public static void startProcessIfHas(Context context, IFormView thisView) {
        String startProcessMapCache = thisView.getPageCache().get(START_PROCESS_MAP);
        if (StringUtils.isEmpty((CharSequence)startProcessMapCache)) {
            return;
        }
        Map map = (Map)JSON.parseObject((String)startProcessMapCache, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
        String processNumber = (String)map.get("processNumber");
        if (StringUtils.isEmpty((CharSequence)processNumber)) {
            log.info("map\u7f13\u5b58\u4e2d\u7684processNumber\u4e0d\u5b58\u5728\uff1a{}", (Object)map);
            return;
        }
        GaiUtils.startProcess(processNumber, context, (Map<String, String>)map, null);
    }

    public static RootPageIdContext newContextInSlide(IFormView thisView, String chatSessionId) {
        String bizAppId = GaiUtils.getCurrentBizAppId(thisView);
        List<String> userBlgs = GaiLicenseUtils.getUserBLG(RequestContext.get().getCurrUserId());
        List<Skill> processListData = ProcessService.getProcessListDataByAppid(bizAppId, userBlgs);
        Assistant assistant = AssistantService.getDefault();
        assistant = assistant == null ? new Assistant() : assistant;
        String rootPageId = GaiUtils.getRootPageId(thisView);
        String assistantPageId = thisView.getPageId();
        FormShowParameter formShowParameter = thisView.getFormShowParameter();
        Object slide = formShowParameter.getCustomParam(SLIDE);
        SLIDEENV slideenv = slide == null ? SLIDEENV.MAIN : (slide instanceof SLIDEENV ? (SLIDEENV)((Object)slide) : SLIDEENV.valueOf((String)slide));
        Context context = Context.create(slideenv, assistant, rootPageId, assistantPageId, rootPageId, processListData, chatSessionId);
        chatSessionId = context.getChatSessionId();
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId(rootPageId);
        if (null == rootPageIdContext) {
            rootPageIdContext = new RootPageIdContext(rootPageId, chatSessionId, null);
        } else {
            rootPageIdContext.setChatSessionId(chatSessionId);
        }
        FlowCacheData.putRootPageId2ChatSessionId(rootPageId, rootPageIdContext);
        thisView.getPageCache().put(CHAT_SESSION_ID, chatSessionId);
        return rootPageIdContext;
    }

    public static void newContextInPrompt(IFormView thisView) {
        String rootPageId = GaiUtils.getRootPageId(thisView);
        Context context = Context.create(SLIDEENV.PLAYGROUND, 0L, rootPageId, thisView.getPageId(), thisView.getParentView().getPageId(), null);
        String chatSessionId = context.getChatSessionId();
        thisView.getPageCache().put(CHAT_SESSION_ID, chatSessionId);
    }

    public static RootPageIdContext newContextInPortal(IFormView thisView) {
        String rootPageId = GaiUtils.getRootPageId(thisView);
        Context context = Context.create(SLIDEENV.HOMEPAGE, 0L, rootPageId, thisView.getPageId(), thisView.getPageId(), null);
        String chatSessionId = context.getChatSessionId();
        thisView.getPageCache().put(CHAT_SESSION_ID, chatSessionId);
        RootPageIdContext rootPageIdContext = FlowCacheData.getContextByRootPageId(rootPageId);
        if (null == rootPageIdContext) {
            rootPageIdContext = new RootPageIdContext(rootPageId, chatSessionId, null);
        } else {
            rootPageIdContext.setChatSessionId(chatSessionId);
        }
        FlowCacheData.putRootPageId2ChatSessionId(rootPageId, rootPageIdContext);
        thisView.getPageCache().put(CHAT_SESSION_ID, chatSessionId);
        return rootPageIdContext;
    }

    public static void newContextInAgentPlayground(IFormView thisView) {
        String rootPageId;
        String parentViewPageId = rootPageId = GaiUtils.getRootPageId(thisView);
        IFormView parentView = thisView.getParentView();
        if (parentView != null) {
            parentViewPageId = parentView.getPageId();
        }
        Context context = Context.create(SLIDEENV.AGENT, 0L, rootPageId, thisView.getPageId(), parentViewPageId, null);
        String chatSessionId = context.getChatSessionId();
        thisView.getPageCache().put(CHAT_SESSION_ID, chatSessionId);
    }

    public static Boolean getBoolean(String key, Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        Object obj = map.get(key);
        if (obj == null) {
            return null;
        }
        return Boolean.valueOf(obj + "");
    }

    public static Boolean getBoolean(Map<String, String> map, String key) {
        if (map == null) {
            return null;
        }
        String obj = map.get(key);
        if (obj == null) {
            return null;
        }
        return Boolean.valueOf(obj);
    }

    public static void refreshBizPageId(Context context, IFormView thisView) {
        String currentBizPageIdPageId = GaiUtils.getCurrentBizPageId(thisView);
        String cachePageId = context.getBizPageId();
        log.info("refreshBizPageId,getCurrentBizPageId:{},context cacheBizPageId {}", (Object)currentBizPageIdPageId, (Object)cachePageId);
        if (currentBizPageIdPageId == null || cachePageId == null || currentBizPageIdPageId.equals("appmiantab") || cachePageId.equals("appmiantab") || !currentBizPageIdPageId.equals(cachePageId)) {
            context.setBizPageId(currentBizPageIdPageId);
            String bizAppId = GaiUtils.getCurrentBizAppId(thisView);
            List<String> userBlgs = GaiLicenseUtils.getUserBLG(RequestContext.get().getCurrUserId());
            List<Skill> skills = SkillService.getList(bizAppId, userBlgs);
            context.setSkillList(skills);
            FlowCacheData.putContext(context.getChatSessionId(), context);
        }
    }

    public static GaiInitConfig getInitGaiConfig(Map<String, String> crossPageData, IFormView thisView, String chatSessionId) {
        Boolean showIcon = Boolean.TRUE;
        Boolean switchSide = Boolean.FALSE;
        Boolean lockSide = null;
        String startProcessNumber = "";
        String selectedProcessNumber = "";
        SLIDEENV slideEnv = SLIDEENV.MAIN;
        String selectedProcessId = "";
        String activeControlIdString = "";
        JSONArray selectionControlArr = new JSONArray();
        if (null != crossPageData && !crossPageData.isEmpty()) {
            selectedProcessId = crossPageData.getOrDefault("selectedProcessNumber", "");
            switchSide = GaiUtils.getBoolean(crossPageData, "switchSide");
            lockSide = GaiUtils.getBoolean(crossPageData, "lockSide");
            log.info("gai init side: \u8de8\u9875\u6570\u636e\u4f20\u9012\uff1a{}", crossPageData);
        } else {
            Map map = thisView.getFormShowParameter().getCustomParams();
            log.info("gai init side: \u6253\u5f00form\u53c2\u6570\u4f20\u9012\uff1a{}", JSON.toJSON((Object)map));
            if (map != null && !map.isEmpty()) {
                showIcon = GaiUtils.getBoolean("showIcon", map);
                Object slide = map.get(SLIDE);
                slideEnv = slide == null ? SLIDEENV.MAIN : (slide instanceof SLIDEENV ? (SLIDEENV)((Object)slide) : SLIDEENV.parse((String)slide));
                switchSide = GaiUtils.getBoolean("switchSide", map);
                lockSide = GaiUtils.getBoolean("lockSide", map);
                startProcessNumber = map.getOrDefault("processNumber", "");
                if (kd.bos.util.StringUtils.isEmpty((String)startProcessNumber)) {
                    startProcessNumber = map.getOrDefault("startProcessNumber", "");
                }
                if (StringUtils.isNotEmpty((CharSequence)startProcessNumber)) {
                    log.info("\u9700\u8981\u542f\u52a8\u6d41\u7a0b{}", (Object)startProcessNumber);
                    thisView.getPageCache().put(START_PROCESS_MAP, JSON.toJSONString((Object)map));
                }
                selectedProcessNumber = map.getOrDefault("selectedProcessNumber", "");
                Object activeControlId = map.get("activeControlId");
                Object selectionControls = map.get("selectionControls");
                if (selectionControls != null) {
                    selectionControlArr = (JSONArray)selectionControls;
                    if (activeControlId != null) {
                        activeControlIdString = (String)activeControlId;
                    }
                    slideEnv = SLIDEENV.BOS_EMBEDDED;
                    switchSide = true;
                }
            }
            if (!kd.bos.util.StringUtils.isEmpty((String)selectedProcessNumber)) {
                Process process = ProcessService.getProcessByNumber(selectedProcessNumber);
                if (process == null) {
                    log.info("process:{} \u67e5\u8be2\u4e0d\u5230", (Object)selectedProcessNumber);
                } else {
                    selectedProcessId = process.getId() + "";
                }
            }
        }
        GaiInitConfig gaiInitConfig = new GaiInitConfig(showIcon, switchSide, lockSide, slideEnv, chatSessionId, activeControlIdString, selectionControlArr);
        Long userId = RequestContext.get().getCurrUserId();
        gaiInitConfig.setUserAgree(GptPrivacyHelper.isUserAgree(userId));
        gaiInitConfig.setSelectedProcessId(selectedProcessId);
        Assistant assistant = AssistantService.getAssistantWithDefault();
        if (null != assistant) {
            String picture = assistant.getPicture();
            if (kd.bos.util.StringUtils.isNotEmpty((String)picture)) {
                String avatar = AgentService.assemblyPictureWebUrl(picture);
                gaiInitConfig.setAvatar(avatar);
            }
            gaiInitConfig.setAssistantId(StrUtils.longAsString(assistant.getId()));
            gaiInitConfig.setAssistantName(assistant.getName());
            gaiInitConfig.setIntroduce(assistant.getIntroduce());
            gaiInitConfig.setOpeningSpeech(assistant.getOpeningSpeech());
        }
        Map userAvatarMap = UserServiceHelper.getUserAvatarPath(Collections.singletonList(userId), (boolean)true);
        ChatUser chatUser = new ChatUser();
        chatUser.setUserName(RequestContext.get().getUserName());
        chatUser.setUserId(userId + "");
        RequestContext rc = RequestContext.get();
        String avatar = String.format("%s%s%s", userAvatarMap.get(userId), ((String)userAvatarMap.get(userId)).contains("?") ? "&kdcdc=" : "?kdcdc=", rc.getAccountId());
        chatUser.setPicture(avatar);
        gaiInitConfig.setChatUser(chatUser);
        return gaiInitConfig;
    }

    public static String getRootPageId(IFormView thisView) {
        IFormView iFormView = thisView.getMainView();
        if (iFormView == null) {
            iFormView = thisView.getParentView();
        }
        if (iFormView == null) {
            iFormView = thisView;
        }
        return iFormView.getPageId();
    }

    public static boolean getStream(String serviceNumber) {
        DynamicObject serviceObj = QueryServiceHelper.queryOne((String)"aicc_service", (String)"id,number,supportstream", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)serviceNumber)});
        if (serviceObj == null) {
            return false;
        }
        return (Boolean)serviceObj.get("supportstream");
    }

    public static boolean canShowSkill(String version, long userId, List<String> blgs, String skillBlg) {
        if ("1.0".equals(version)) {
            return true;
        }
        if ("7.0".equals(version)) {
            return true;
        }
        if ("5.0".equals(version)) {
            return GaiLicenseUtils.userUseBLG(userId, null);
        }
        return blgs.contains(skillBlg);
    }

    public static boolean canOpenSide(Long userId) {
        return GptPrivacyHelper.isTenantAgree(RequestContext.get().getTenantId());
    }

    public static JSONObject toJson(String origin) {
        if (StringUtils.isEmpty((CharSequence)origin)) {
            return new JSONObject();
        }
        int start = origin.indexOf(123);
        int end = origin.lastIndexOf(125);
        if (start == -1 || end == -1) {
            return new JSONObject();
        }
        try {
            return JSON.parseObject((String)origin.substring(start, end + 1));
        }
        catch (Exception e) {
            return new JSONObject();
        }
    }

    public static int hashMapInitialCapacity(int total) {
        int initialCapacity = (int)Math.ceil((float)total / 0.75f);
        initialCapacity = (int)Math.pow(2.0, Math.ceil(Math.log(initialCapacity) / Math.log(2.0)));
        return initialCapacity;
    }

    public static int countSymbols(String text) {
        Pattern symbolPattern = Pattern.compile("[^\\w\\s\u4e00-\u9fa5]");
        Matcher symbolMatcher = symbolPattern.matcher(text);
        int count = 0;
        while (symbolMatcher.find()) {
            ++count;
        }
        return count;
    }

    public static int countChineseCharacters(String text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.UnicodeScript.of(c) != Character.UnicodeScript.HAN) continue;
            ++count;
        }
        return count;
    }

    public static int countEnglishLetters(String text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Character.isLetter(c) || Character.UnicodeScript.of(c) == Character.UnicodeScript.HAN) continue;
            ++count;
        }
        return count;
    }

    public static int countEnglishWords(String text) {
        int count = 0;
        boolean inWord = false;
        for (char c : text.toCharArray()) {
            if (Character.isLetter(c)) {
                inWord = true;
                continue;
            }
            if (!inWord) continue;
            ++count;
            inWord = false;
        }
        if (inWord) {
            ++count;
        }
        return count;
    }

    public static String removeExtraNewLines(String input) {
        StringBuilder output = new StringBuilder();
        boolean previousCharWasNewLine = false;
        for (char c : input.toCharArray()) {
            if (c == '\n') {
                if (!previousCharWasNewLine) {
                    output.append(c);
                }
                previousCharWasNewLine = true;
                continue;
            }
            output.append(c);
            previousCharWasNewLine = false;
        }
        return output.toString();
    }

    public static List<Skill> buildSkillList(List<Skill> tempskillList) {
        ArrayList<Skill> skillList = new ArrayList<Skill>();
        for (Skill skill : tempskillList) {
            if (skill.getType() == Skill.Type.AGENT) {
                Agent agent = AgentService.getAgent(Long.parseLong(skill.getId()), false);
                skill.setName(agent.getName());
                skill.setNumber(agent.getNumber());
                skill.setType(Skill.Type.AGENT);
                skill.setPicture(agent.getPicture());
                skill.setBgColor(agent.getBgColor());
                skill.setPrologue(agent.getPrologue());
                List<Question> questions = agent.getQuestionList();
                ArrayList<SuggestedAskData> suggestedAskDataList = new ArrayList<SuggestedAskData>();
                if (questions != null) {
                    for (Question question : questions) {
                        suggestedAskDataList.add(new SuggestedAskData("1", question.getValue()));
                    }
                    skill.setSuggestedAsks(suggestedAskDataList);
                }
                skillList.add(skill);
                continue;
            }
            long skillId = Long.parseLong(skill.getId());
            Skill process = ProcessService.getProcessByIdAndOther(skillId, null, null);
            if (process != null) {
                skill.setName(process.getName());
                skill.setNumber(process.getNumber());
                skill.setSuggestedAsks(process.getSuggestedAsks());
                skill.setPrologue(process.getPrologue());
                skillList.add(skill);
                continue;
            }
            log.info("\u8fd9\u4e2aid\uff1a{}\u6ca1\u6709\u5bf9\u5e94\u7684process\uff0c\u5df2\u7ecf\u5ffd\u7565", (Object)skillId);
        }
        return skillList;
    }
}

