/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import java.util.Map;
import kd.ai.gai.core.engine.Errors;
import kd.bos.exception.KDBizException;
import kd.bos.kscript.runtime.Interpreter;

public class ScriptEngine {
    private static ScriptEngine engine;
    private static final ThreadLocal<Interpreter> interpreterThreadLocal;

    private ScriptEngine() {
    }

    public static ScriptEngine getEngine() {
        if (engine == null) {
            engine = new ScriptEngine();
        }
        return engine;
    }

    private Interpreter getInterpreter() {
        Interpreter interpreter = interpreterThreadLocal.get();
        if (interpreter == null) {
            interpreter = new Interpreter();
            interpreter.funcProviderList.clear();
            interpreter.setForBot(true);
            interpreterThreadLocal.set(interpreter);
        }
        return interpreter;
    }

    public void clear() {
        interpreterThreadLocal.remove();
    }

    public Object runScript(String script, Map<String, Object> ctx) {
        Interpreter interpreter = this.getInterpreter();
        try {
            return interpreter.evalExpr(script, ctx);
        }
        catch (Exception e) {
            throw new KDBizException(Errors.runScriptError(script, e.getMessage()), new Object[0]);
        }
    }

    static {
        interpreterThreadLocal = new ThreadLocal();
    }
}

