/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.HashMap;
import java.util.Map;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.RootPageIdContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class ShowFormUtil {
    private static final Log log = LogFactory.getLog(ShowFormUtil.class);

    public static void openBill(String appId, String billFormId, Object billPkId, IFormView myView, String crossPageData) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("formId", billFormId);
        para.put("pkId", billPkId);
        HashMap<String, Object> tmpParams = new HashMap<String, Object>();
        tmpParams.putAll(para);
        tmpParams.put("view", myView);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        String appNumber = appInfo.getNumber();
        String mainPageId = appInfo.getHomeId();
        if (mainPageId == null || mainPageId.trim().length() == 0) {
            throw new KDBizException("\u5e94\u7528\u9996\u9875\u6ca1\u6709\u914d\u7f6e\u3002");
        }
        DynamicObject pageObject = BusinessDataServiceHelper.loadSingleFromCache((Object)mainPageId, (String)"bos_formmeta", (String)"number, inheritpath");
        if (pageObject == null) {
            throw new KDBizException("\u5e94\u7528\u9996\u9875\u9875\u9762\u4e0d\u5b58\u5728\u3002");
        }
        if (!StringUtils.isEmpty((String)crossPageData)) {
            Map crossPageDataMap = (Map)JSON.parseObject((String)crossPageData, (TypeReference)new TypeReference<Map<String, String>>(){}, (Feature[])new Feature[0]);
            RootPageIdContext rootPageIdContext = new RootPageIdContext(mainPageId, null, crossPageDataMap);
            FlowCacheData.putRootPageId2ChatSessionId(mainPageId, rootPageIdContext);
        }
        String mainPageNumber = pageObject.getString("number");
        String billPkIdString = billPkId.toString();
        tmpParams.put("appname", appInfo.getName().getLocaleValue());
        tmpParams.put("appmainnumber", mainPageNumber);
        tmpParams.put("pkId", billPkIdString);
        OpenPageUtils.openApp((String)appInfo.getNumber(), (String)null, tmpParams, (IFormView)myView);
        tmpParams.remove("view");
        String pageId = ShowFormUtil.getBillPageId(myView.getMainView(), billFormId, billPkIdString);
        IFormView formIdPage = myView.getViewNoPlugin(pageId);
        if (formIdPage != null) {
            ShowFormUtil.activatePage(pageId, myView, para);
        } else {
            IFormView mainPageView = myView.getMainView();
            if (mainPageView == null) {
                log.info("openBill----mainPageView or mainPageID is null");
            } else {
                String appPageId = ShowFormUtil.getAppPageId(mainPageView.getPageId(), appNumber);
                IFormView appPageView = mainPageView.getViewNoPlugin(appPageId);
                if (appPageView != null) {
                    if (appPageView.getPageId().equalsIgnoreCase(mainPageView.getPageId())) {
                        appPageView = mainPageView;
                    }
                    FormShowParameter fsp = ShowFormUtil.createShowFormParameter(billFormId, tmpParams);
                    fsp.setHasRight(true);
                    fsp.setAppId(appNumber);
                    fsp.setCustomParam("appid", (Object)appNumber);
                    ShowFormUtil.addCustomParam(fsp, tmpParams);
                    fsp.setPageId(pageId);
                    if (myView.getPageId().equals(appPageView.getPageId())) {
                        myView.showForm(fsp);
                    } else {
                        appPageView.showForm(fsp);
                        myView.sendFormAction(appPageView);
                    }
                } else {
                    log.info("openBill----appPageView is null");
                }
            }
        }
    }

    public static void activatePage(String pageID, IFormView view, Map<String, Object> customParams) {
        IFormView childView = view.getViewNoPlugin(pageID);
        if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
            childView = view.getView(pageID);
        }
        if (childView != null) {
            if (!view.getPageId().equalsIgnoreCase(childView.getPageId())) {
                HashMap customparameters = (HashMap)customParams.get("customparameters");
                childView.getFormShowParameter().getCustomParams().remove("messageId");
                childView.getFormShowParameter().getCustomParams().remove("tabType");
                childView.getFormShowParameter().getCustomParams().remove("openPage");
                if (customparameters != null) {
                    if (customparameters.get("messageId") != null) {
                        childView.getFormShowParameter().setCustomParam("messageId", customparameters.get("messageId"));
                    }
                    if (customparameters.get("tabType") != null) {
                        childView.getFormShowParameter().setCustomParam("tabType", customparameters.get("tabType"));
                    }
                    if (customparameters.get("openPage") != null) {
                        childView.getFormShowParameter().setCustomParam("openPage", customparameters.get("openPage"));
                    }
                }
                childView.getFormShowParameter().setHasRight(true);
                childView.activate();
                if ("bos".equals(childView.getFormShowParameter().getServiceAppId())) {
                    childView.updateView();
                }
                view.sendFormAction(childView);
            }
        } else {
            view.showTipNotification("\u7cfb\u7edf\u5df2\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u767b\u5f55!");
        }
    }

    public static FormShowParameter createShowFormParameter(String formNumber, Map<String, Object> parameter) {
        FormShowParameter sp = FormShowParameter.createFormShowParameter(parameter);
        sp.getOpenStyle().setShowType(ShowType.NewTabPage);
        sp.getOpenStyle().setTargetKey("_submaintab_");
        HashMap map = new HashMap();
        sp.setCustomParams(map);
        return sp;
    }

    public static void addCustomParam(FormShowParameter fsp, Map<String, Object> customParams) {
        if (customParams != null) {
            customParams.forEach((k, v) -> fsp.setCustomParam(k, v));
        }
    }

    public static String getBillPageId(IFormView targetView, String formId, String billPkid) {
        return formId + targetView.getPageId() + "_" + billPkid;
    }

    public static String getAppPageId(String mainPageViewPageId, String appNumber) {
        return appNumber + mainPageViewPageId;
    }
}

