/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.aop;

import com.alibaba.fastjson.JSON;
import java.util.Objects;
import java.util.function.Function;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.pojo.AbsRagParams;
import kd.ai.gai.pojo.GaiRagSearchParams;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public class GaiMService {
    private static final Log logger = LogFactory.getLog(GaiMService.class);

    public static <T, R> R execute(String methodDesc, T param, Function<T, R> func) {
        String requestId = RequestContext.get().getRequestId();
        logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011{}-\u5f00\u59cb\uff0crequestId:{}", (Object)methodDesc, (Object)requestId);
        try {
            String version = LicenseServiceHelper.getProductVersion();
            logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011{}-{}\u8bb8\u53ef\u6821\u9a8c-\u5f00\u59cb\uff0crequestId:{}", new Object[]{methodDesc, version, requestId});
            if (("1.0".equalsIgnoreCase(version) || "2.0".equalsIgnoreCase(version) || "3.0".equalsIgnoreCase(version) || "4.0".equalsIgnoreCase(version) || "5.0".equalsIgnoreCase(version) || "6.0".equalsIgnoreCase(version)) && param instanceof AbsRagParams) {
                GPTLicenseHelper.checkLic((String)"ai_gai_reporag", (Long)0L);
            } else if (param instanceof GaiRagSearchParams) {
                GPTLicenseHelper.checkLic((String)"ai_gai_reporag", (Long)0L);
            }
            logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011{}-\u8bb8\u53ef\u6821\u9a8c-\u7ed3\u675f\uff0crequestId:{}", (Object)methodDesc, (Object)requestId);
            logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011{},param:{}-\u5f00\u59cb\uff0crequestId:{}", new Object[]{methodDesc, SerializationUtils.toJsonString(param), requestId});
            if (param instanceof String && StringUtils.isEmpty((CharSequence)((String)param))) {
                throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR), new Object[0]);
            }
            logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011{}-\u5f00\u59cb\u6267\u884c\u81ea\u5b9a\u4e49\u51fd\u6570\uff0crequestId:{}", (Object)methodDesc, (Object)requestId);
            R result = func.apply(param);
            logger.info("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011{}-\u81ea\u5b9a\u4e49\u51fd\u6570\u6267\u884c\u7ed3\u675f\uff0crequestId:{}\uff0c\u54cd\u5e94\u7ed3\u679c:{}", new Object[]{methodDesc, requestId, JSON.toJSONString(result)});
            return result;
        }
        catch (Exception e) {
            logger.error("\u3010GPT-\u63a5\u53e3\u670d\u52a1\u3011{}-\u5f02\u5e38\uff0crequestId:{},errMsg:{}", new Object[]{methodDesc, requestId, e.getMessage(), e});
            if (e instanceof KDBizException) {
                ErrorCode errorCode = ((KDBizException)e).getErrorCode();
                if (Objects.isNull(errorCode)) {
                    throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR), new Object[0]);
                }
                throw e;
            }
            throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR), new Object[0]);
        }
    }
}

