/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.helper;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.aop.GaiMService;
import kd.ai.gai.core.Constant;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.domain.dto.Chunk;
import kd.ai.gai.core.domain.vo.RepoDataInfo;
import kd.ai.gai.core.domain.vo.RepoFileVO;
import kd.ai.gai.core.domain.vo.RepoVO;
import kd.ai.gai.core.enuz.LLM;
import kd.ai.gai.core.enuz.repo.ChunkRule;
import kd.ai.gai.core.rag.milvus.MilvusService;
import kd.ai.gai.core.rag.service.RepoDispatchService;
import kd.ai.gai.core.service.AiccService;
import kd.ai.gai.core.service.FilePreviewService;
import kd.ai.gai.core.service.RepoService;
import kd.ai.gai.core.service.embedding.EmbeddingServiceFactory;
import kd.ai.gai.dto.GaiEmbeddingData;
import kd.ai.gai.dto.GaiRepoData;
import kd.ai.gai.dto.GaiRepoFileData;
import kd.ai.gai.dto.GaiRepoSearchData;
import kd.ai.gai.pojo.GaiRagSearchParams;
import kd.ai.gai.pojo.GaiRepoAddFileParams;
import kd.ai.gai.pojo.GaiRepoCreateParams;
import kd.ai.gai.pojo.GaiRepoDelFileParams;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.url.UrlService;

public class RagHelper {
    private static final Log logger = LogFactory.getLog(RagHelper.class);
    private static final long max_file_size = 0x6400000L;
    private static final String repos_file_id = "doc_manage.id";
    private static final String repos_file_name = "doc_manage.file_name";
    private static final String repos_file_status = "doc_manage.file_status";
    private static final String repos_file_path = "doc_manage.file_path";
    private static final String repo_file_select_field = String.join((CharSequence)",", "doc_manage.id", "doc_manage.file_name", "doc_manage.file_status", "doc_manage.file_path");
    private static final String repo_select_field = String.join((CharSequence)",", "id", "number", "name", "useorg", "repo_source", "desc", "status", "index_method", "type", "modifytime");

    public static RepoDataInfo createRepo(String methodHeaderDesc, GaiRepoCreateParams params) {
        return GaiMService.execute(String.format("%s-\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93", methodHeaderDesc), params, p -> {
            RequestContext rc = RequestContext.get();
            long currUserId = rc.getCurrUserId();
            String repoName = params.getName();
            String repoType = params.getType();
            long useOrg = params.getUseOrg();
            String indexMethod = params.getIndexMethod();
            String desc = params.getDesc();
            String chunkStrategy = params.getChunkStrategy();
            List<GaiRepoCreateParams.RepoFileParam> fileInfos = params.getFileInfos();
            if (kd.bos.util.StringUtils.isEmpty((String)chunkStrategy)) {
                chunkStrategy = ChunkRule.ChunkStrategy.BASE_FIXED_LENGTH.getStrategy();
            }
            RagHelper.checkMustParams(repoName, repoType, useOrg, fileInfos, chunkStrategy);
            List<GaiEmbeddingData> useableEmbeddings = RagHelper.getGaiUseableEmbedding();
            if (useableEmbeddings == null || useableEmbeddings.isEmpty()) {
                GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_REPO_EMBEDDING_LLM_ERR);
            }
            if (kd.bos.util.StringUtils.isEmpty((String)indexMethod)) {
                indexMethod = useableEmbeddings.get(0).getNumber();
            }
            DynamicObject repoInfo = BusinessDataServiceHelper.newDynamicObject((String)"gai_repo_info");
            String repoNumber = CodeRuleServiceHelper.getNumber((String)repoInfo.getDataEntityType().getName(), (DynamicObject)repoInfo, null);
            long repoId = ORM.create().genLongId("gai_repo_info");
            repoInfo.set("id", (Object)repoId);
            repoInfo.set("name", (Object)repoName);
            repoInfo.set("number", (Object)repoNumber);
            repoInfo.set("useorg", (Object)useOrg);
            repoInfo.set("type", (Object)repoType);
            repoInfo.set("chunk_strategy", (Object)chunkStrategy);
            repoInfo.set("creator", (Object)currUserId);
            repoInfo.set("desc", (Object)desc);
            repoInfo.set("enable", (Object)"1");
            repoInfo.set("index_method", (Object)indexMethod);
            repoInfo.set("status", (Object)"A");
            repoInfo.set("repo_source", (Object)"ms");
            repoInfo.set("file_total", (Object)(fileInfos != null ? fileInfos.size() : 0));
            DynamicObjectCollection docs = repoInfo.getDynamicObjectCollection("doc_manage");
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u5165\u5e93\u5f00\u59cb\uff0crepoId:{}", (Object)repoId);
            for (GaiRepoCreateParams.RepoFileParam f : fileInfos) {
                DynamicObject doc = docs.addNew();
                doc.set("file_name", (Object)f.getFileName());
                doc.set("file_type", (Object)f.getFileType());
                doc.set("file_path", (Object)f.getFilePath());
                doc.set("file_size", (Object)f.getFileSize());
                doc.set("file_status", (Object)"A");
                String currenFileSource = RagHelper.getFileSource(repoType, f.getFileType());
                doc.set("file_source", (Object)currenFileSource);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{repoInfo});
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u521b\u5efa\u95ee\u7b54\u77e5\u8bc6\u5e93-\u5165\u5e93\u5b8c\u6210\uff0crepoId:{}", (Object)repoId);
            boolean start = RepoDispatchService.dispatchTask((long)repoId);
            if (!start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"D", repoId});
                throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.RAG_REPO_TASK_ERR), new Object[0]);
            }
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=? where fid = ?", (Object[])new Object[]{"B", repoId});
            logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u95ee\u7b54\u77e5\u8bc6\u5e93\uff0crepoId:{}-\u4efb\u52a1\u542f\u52a8\u6210\u529f", (Object)repoId);
            return new RepoDataInfo(repoId, repoNumber, repoName);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GaiRepoData queryRepoInfo(String methodHeaderDesc, long repoId) {
        String repoStatus = "B";
        float repoProcess = 0.0f;
        long repoModiftTime = 0L;
        try {
            GaiRepoData repoData = GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93\u4fe1\u606f", methodHeaderDesc), repoId, p -> {
                DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
                long id = repoObj.getLong("id");
                String status = repoObj.getString("status");
                String number = repoObj.getString("number");
                String name = repoObj.getString("name");
                Long useorg = repoObj.getLong("useorg");
                String desc = repoObj.getString("desc");
                String indexMethod = repoObj.getString("index_method");
                String type = repoObj.getString("type");
                long modifytime = repoObj.getDate("modifytime").getTime();
                float process = RepoService.algoRepoTaskProcess((long)p);
                return new GaiRepoData(id, number, name, useorg, indexMethod, type, desc, status, process, modifytime);
            });
            repoStatus = repoData.getStatus();
            repoProcess = repoData.getProcess();
            repoModiftTime = repoData.getLastModifytime();
            GaiRepoData gaiRepoData = repoData;
            return gaiRepoData;
        }
        finally {
            long currentTime = System.currentTimeMillis();
            if (("B".equals(repoStatus) || repoProcess < 1.0f) && currentTime - repoModiftTime >= 0x6DDD00L) {
                RepoService.checkRepoTaskTime((long)repoId, (float)repoProcess, (long)repoModiftTime);
            }
        }
    }

    public static List<GaiRepoFileData> queryRepoFilesInfo(String methodHeaderDesc, long repoId) {
        return GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93\u6587\u4ef6\u5217\u8868\u4fe1\u606f", methodHeaderDesc), repoId, p -> {
            List files;
            DynamicObjectCollection repoObjs = QueryServiceHelper.query((String)"gai_repo_info", (String)repo_file_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
            if (repoObjs != null && repoObjs.size() > 0) {
                files = new ArrayList(repoObjs.size());
                for (DynamicObject repoObj : repoObjs) {
                    Long fileId = repoObj.getLong(repos_file_id);
                    String name = repoObj.getString(repos_file_name);
                    String path = repoObj.getString(repos_file_path);
                    String status = repoObj.getString(repos_file_status);
                    GaiRepoFileData repoFileDTO = new GaiRepoFileData(fileId, name, path, status);
                    files.add(repoFileDTO);
                }
            } else {
                files = Collections.emptyList();
            }
            return files;
        });
    }

    public static List<GaiEmbeddingData> queryIndexMethod(String methodHeaderDesc) {
        return GaiMService.execute(String.format("%s-\u67e5\u8be2\u77e5\u8bc6\u5e93\u7d22\u53ef\u7528\u5f15\u65b9\u5f0f", methodHeaderDesc), null, o -> {
            LLM[] llms = LLM.values();
            List instanceList = AiccService.getAiccInstanceList();
            ArrayList<GaiEmbeddingData> list = new ArrayList<GaiEmbeddingData>(llms.length);
            for (LLM llm : llms) {
                if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING || !instanceList.contains(llm.getNumber())) continue;
                list.add(new GaiEmbeddingData(llm.getNumber(), llm.getName()));
            }
            return list;
        });
    }

    public static boolean addRepoFiles(String methodHeaderDesc, GaiRepoAddFileParams params) {
        return GaiMService.execute(String.format("%s-\u65b0\u589e\u77e5\u8bc6\u5e93\u6587\u4ef6", methodHeaderDesc), params, p -> {
            long repoId = params.getRepoId();
            List<GaiRepoCreateParams.RepoFileParam> fileInfos = params.getFileInfos();
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RagHelper.checkExistAndRunning(repoObj);
            StringBuilder msg = new StringBuilder();
            String repoType = repoObj.getString("type");
            RagHelper.checkMustFilesParams(msg, repoType, fileInfos);
            String status = repoObj.getString("status");
            if ("B".equals(status)) {
                logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u4efb\u52a1\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002");
                GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_REPO_RUNNING_ERR);
            }
            int size = fileInfos.size();
            long[] ids = ORM.create().genLongIds("gai_repo_info", size);
            String sql = "INSERT INTO T_GAI_REPO_DOC_MANAGE (FID,FENTRYID,FFILENAME,FFILESTATUS,FFILEPATH,FFILESIZE,FFILETYPE,FCREATEDATE,FFILESOURCE) VALUES (?,?,?,?,?,?,?,?,?)";
            for (int i = 0; i < fileInfos.size(); ++i) {
                GaiRepoCreateParams.RepoFileParam fileParam = fileInfos.get(i);
                RagHelper.insertOneFile(repoId, repoType, ids[i], sql, fileParam);
            }
            boolean start = RepoDispatchService.dispatchTask((long)repoId);
            DynamicObject repo = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)"file_total", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            int repoFileTotal = repo.getInt("file_total");
            if (start) {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,ffiletotal=? where fid = ?", (Object[])new Object[]{"B", repoFileTotal + size, repoId});
            } else {
                DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set fstatus=?,ffiletotal=? where fid = ?", (Object[])new Object[]{"D", repoFileTotal + size, repoId});
                GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_REPO_TASK_ERR);
            }
            return Boolean.TRUE;
        });
    }

    public static boolean deleteRepoById(String methodHeaderDesc, long repoId) {
        return GaiMService.execute(String.format("%s-\u5220\u9664\u77e5\u8bc6\u5e93", methodHeaderDesc), repoId, p -> {
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", p)});
            RagHelper.checkExistAndRunning(repoObj);
            boolean del = "dev".equalsIgnoreCase(repoObj.getString("repo_source"));
            RepoService.delRepoByIds((Object[])new Object[]{p}, (boolean)del);
            MainEntityType repoEntityType = EntityMetadataCache.getDataEntityType((String)"gai_repo_info");
            DeleteServiceHelper.delete((IDataEntityType)repoEntityType, (Object[])new Object[]{p});
            return Boolean.TRUE;
        });
    }

    public static boolean deleteRepoFiles(String methodHeaderDesc, GaiRepoDelFileParams delFileParams) {
        return GaiMService.execute(String.format("%s-\u5220\u9664\u77e5\u8bc6\u5e93\u4e2d\u6587\u4ef6", methodHeaderDesc), delFileParams, params -> {
            long repoId = params.getRepoId();
            long[] fileIds = params.getFileIds();
            if (repoId <= 0L || fileIds == null || fileIds.length <= 0) {
                GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR);
            }
            DynamicObject repoObj = QueryServiceHelper.queryOne((String)"gai_repo_info", (String)repo_select_field, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId)});
            RagHelper.checkExistAndRunning(repoObj);
            String indexMethod = repoObj.getString("index_method");
            LLM llm = LLM.parse((String)indexMethod);
            DynamicObjectCollection dids = QueryServiceHelper.query((String)"gai_text_chunk", (String)"id", (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId).and("fileid", "in", (Object)fileIds)});
            if (dids != null) {
                List ids = dids.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
                logger.info("\u3010GPT-RAG-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5220\u9664\u77e5\u8bc6\u5e93\u4e2d\u6587\u4ef6,\u5757IDS:{}", ids);
                if (!ids.isEmpty()) {
                    MilvusService.getExecutor((LLM)llm).delByIdList(ids);
                }
            }
            DeleteServiceHelper.delete((String)"gai_text_chunk", (QFilter[])new QFilter[]{new QFilter("repoid", "=", (Object)repoId).and("fileid", "in", (Object)fileIds)});
            StringBuilder sql = new StringBuilder();
            sql.append("delete t_gai_repo_doc_manage ");
            sql.append("where fid = ? ");
            sql.append("and fentryid in (");
            sql.append(String.join((CharSequence)",", Collections.nCopies(fileIds.length, "?")));
            sql.append(')');
            Object[] sqlParams = new Object[fileIds.length + 1];
            sqlParams[0] = repoId;
            for (int i = 0; i < fileIds.length; ++i) {
                sqlParams[i + 1] = fileIds[i];
            }
            DB.execute((DBRoute)DBRoute.of((String)"aidb"), (String)sql.toString(), (Object[])sqlParams);
            String docCountSql = "select count(1)  from t_gai_repo_doc_manage  where fid=? ";
            int totalCount = (Integer)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)docCountSql, (Object[])new Object[]{repoId}, resultSet -> {
                resultSet.next();
                return resultSet.getInt(1);
            });
            DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)"update t_gai_repo_info set ffiletotal=? where fid = ?", (Object[])new Object[]{totalCount, repoId});
            String repoSource = repoObj.getString("repo_source");
            if ("dev".equalsIgnoreCase(repoSource)) {
                DynamicObjectCollection repoObjPaths = QueryServiceHelper.query((String)"gai_repo_info", (String)repos_file_path, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)repoId).and(repos_file_id, "in", (Object)fileIds)});
                if (repoObjPaths != null) {
                    for (DynamicObject repoObjPath : repoObjPaths) {
                        String path = repoObjPath.getString(repos_file_path);
                        FileServiceFactory.getAttachmentFileService().delete(path);
                    }
                }
            } else {
                logger.info("\u3010GPT-RAG-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5220\u9664\u77e5\u8bc6\u5e93\u4e2d\u6587\u4ef6\uff0c\u975e\u5f00\u53d1\u5e73\u53f0\u521b\u5efa\u6765\u6e90\uff0c\u4e0d\u5904\u7406\u539f\u6587\u4ef6");
            }
            RepoService.updateRepoStatus((long)repoId);
            return Boolean.TRUE;
        });
    }

    public static List<GaiRepoSearchData> search(String methodHeaderDesc, GaiRagSearchParams searchParams) {
        return GaiMService.execute(String.format("%s-\u77e5\u8bc6\u5e93\u68c0\u7d22", methodHeaderDesc), searchParams, p -> {
            List<Long> repoIds = p.getRepoIds();
            if (repoIds == null || repoIds.size() <= 0) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr((GaiErrorCode)GaiErrorCode.RAG_REPO_SEARCH_PARAMS_ERR, (String)"\u77e5\u8bc6\u5e93\u4e0d\u4e3a\u7a7a"), new Object[0]);
            }
            String input = p.getInput();
            int topK = p.getTopK();
            if (kd.bos.util.StringUtils.isEmpty((String)input)) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr((GaiErrorCode)GaiErrorCode.RAG_REPO_SEARCH_PARAMS_ERR, (String)"\u5f85\u68c0\u7d22\u6587\u672c\u5185\u5bb9\u4e0d\u4e3a\u7a7a"), new Object[0]);
            }
            if (input.length() > 1000) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr((GaiErrorCode)GaiErrorCode.RAG_REPO_SEARCH_PARAMS_ERR, (String)"\u5f85\u68c0\u7d22\u6587\u672c\u5185\u5bb9\u9700\u8981\u57281000\u5b57\u7b26\u4ee5\u5185"), new Object[0]);
            }
            if (topK < 1 || topK > 20) {
                throw new KDBizException(GaiExceptionUtil.buildExtMsgErr((GaiErrorCode)GaiErrorCode.RAG_REPO_SEARCH_PARAMS_ERR, (String)"TopK\u503c\u4e3a[1,20]"), new Object[0]);
            }
            long repoId = repoIds.get(0);
            RepoVO repoInfo = RepoService.getRepoInfo((long)repoId);
            LLM embeddingModel = repoInfo.getLlm();
            List chunkList = EmbeddingServiceFactory.getExecutor((LLM)embeddingModel).search(repoIds, input, topK);
            ArrayList<GaiRepoSearchData> searchDatas = new ArrayList<GaiRepoSearchData>();
            if (chunkList != null && chunkList.size() > 0) {
                for (Chunk chunk : chunkList) {
                    long repositoryId = chunk.getRepositoryId();
                    long chunkId = chunk.getId();
                    String title = chunk.getTitle();
                    String url = chunk.getUrl();
                    String chunkContent = chunk.getChunk();
                    Long businessId = chunk.getBusinessId();
                    if (StringUtils.isEmpty((CharSequence)title) && StringUtils.isEmpty((CharSequence)url)) {
                        RepoFileVO repoFileVO = RepoService.getFileByChunkId((long)chunkId);
                        String fileSource = repoFileVO.getSource();
                        if ("doc".equals(fileSource) || "code".equals(fileSource)) {
                            String path = repoFileVO.getPath();
                            title = repoFileVO.getName();
                            url = FilePreviewService.getPreviewUrl((String)path);
                        } else {
                            title = repoFileVO.getTitle();
                            url = repoFileVO.getUrl();
                        }
                    } else {
                        boolean isNextCloud = url.startsWith("{domainContextUrl}");
                        if (isNextCloud) {
                            String domainContextUrl = UrlService.getDomainContextUrl();
                            url = url.replaceFirst("\\{domainContextUrl\\}", domainContextUrl);
                        }
                    }
                    GaiRepoSearchData gaiRepoSearchData = new GaiRepoSearchData(chunkId, repositoryId, chunkContent, title, url, businessId);
                    searchDatas.add(gaiRepoSearchData);
                }
            }
            return searchDatas;
        });
    }

    private static void checkMustParams(String repoName, String repoType, long useOrg, List<GaiRepoCreateParams.RepoFileParam> fileInfos, String chunkStrategy) {
        StringBuilder msg = new StringBuilder();
        if (kd.bos.util.StringUtils.isEmpty((String)repoName)) {
            msg.append("repoName,");
        }
        if (kd.bos.util.StringUtils.isEmpty((String)repoType)) {
            msg.append("type,");
        }
        if (!(kd.bos.util.StringUtils.isEmpty((String)chunkStrategy) || ChunkRule.ChunkStrategy.BASE_FIXED_LENGTH.getStrategy().equals(chunkStrategy) || ChunkRule.ChunkStrategy.CUSTOMIZE.getStrategy().equals(chunkStrategy))) {
            msg.append("chunkStrategy,");
        }
        ArrayList<String> propList = new ArrayList<String>();
        propList.add("number");
        Map orgInfo = OrgUnitServiceHelper.getOrgProperty((long)useOrg, propList);
        if (orgInfo == null || orgInfo.isEmpty()) {
            msg.append("useOrg,");
        }
        RagHelper.checkMustFilesParams(msg, repoType, fileInfos);
    }

    private static void checkMustFilesParams(StringBuilder msg, String repoType, List<GaiRepoCreateParams.RepoFileParam> fileInfos) {
        if (fileInfos == null || fileInfos.isEmpty()) {
            msg.append("fileInfos,");
        } else {
            boolean outOfRange = fileInfos.stream().anyMatch(f -> f.getFileSize() > 0x6400000L || f.getFileSize() <= 0L);
            if (outOfRange) {
                msg.append("\u6587\u4ef6\u5927\u5c0f\u4e0d\u6ee1\u8db3\uff1a\u5927\u4e8e0MB\u6216\u5c0f\u4e8e\u7b49\u4e8e100MB \u8981\u6c42,");
            }
            if ("kd_code_gen".equals(repoType)) {
                boolean typefail = fileInfos.stream().allMatch(f -> f.getFileType().contains("json"));
                if (typefail) {
                    msg.append("\u4ee3\u7801\u751f\u6210\u77e5\u8bc6\u5e93\uff0c\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u90fd\u4e3ajson,");
                }
            } else {
                boolean typefail = fileInfos.stream().allMatch(f -> Arrays.asList(Constant.RepoInfo.handle_file_type).contains(f.getFileType()));
                if (!typefail) {
                    msg.append("\u95ee\u7b54\u77e5\u8bc6\u5e93\uff0c\u6587\u4ef6\u7c7b\u578b\u5fc5\u987b\u4e3a\uff1atext,pdf,json,");
                }
            }
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)msg.toString())) {
            msg.append("\u53c2\u6570\u4e0d\u5408\u89c4");
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_REPO_PARAMS_ERR, (String)msg.toString());
        }
    }

    private static void insertOneFile(long repoId, String repoType, long id, String sql, GaiRepoCreateParams.RepoFileParam fileParam) {
        String currenFileSource = RagHelper.getFileSource(repoType, fileParam.getFileType());
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)sql, (Object[])new Object[]{repoId, id, fileParam.getFileName(), "A", fileParam.getFilePath(), fileParam.getFileSize(), fileParam.getFileType(), new Timestamp(System.currentTimeMillis()), currenFileSource});
    }

    private static void checkExistAndRunning(DynamicObject repoObj) {
        if (repoObj != null) {
            String status = repoObj.getString("status");
            if ("B".equals(status)) {
                logger.info("\u3010\u77e5\u8bc6\u5e93\u3011\u4efb\u52a1\u8fd0\u884c\u4e2d\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002");
                GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_REPO_RUNNING_ERR);
            }
        } else {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_REPO_EXEIT_ERR);
        }
    }

    private static List<GaiEmbeddingData> getGaiUseableEmbedding() {
        LLM[] llms = LLM.values();
        List instanceList = AiccService.getAiccInstanceList();
        ArrayList<GaiEmbeddingData> list = new ArrayList<GaiEmbeddingData>(llms.length);
        for (LLM llm : llms) {
            if (!llm.isActive() || llm.getModelType() != LLM.ModelType.EMBEDDING || !instanceList.contains(llm.getNumber())) continue;
            list.add(new GaiEmbeddingData(llm.getNumber(), llm.getName()));
        }
        return list;
    }

    private static String getFileSource(String repoType, String fileType) {
        String currenFileSource = "kd_code_gen".equals(repoType) ? "code" : ("qa".equals(repoType) && fileType.contains("json") ? "html" : "doc");
        return currenFileSource;
    }
}

