/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Map;
import kd.ai.gai.core.domain.llm.base.Result2User;
import kd.ai.gai.core.engine.ActionCallbackMessage;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.handler.EmbeddingHandler;
import kd.ai.gai.core.engine.message.llmcallback.LLMSplitMessage;
import kd.ai.gai.mservice.GaiCallBackService;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiCallBackServiceImpl
implements GaiCallBackService {
    private static final Log logger = LogFactory.getLog(GaiCallBackServiceImpl.class);

    public void llmNotify(ArrayList<Map<String, String>> list) {
        logger.info("GaiCallBackService({}) llmNotify:{}", (Object)RequestContext.get().getTraceId(), (Object)JSON.toJSONString(list));
        for (Map<String, String> item : list) {
            GaiCallBackServiceImpl.callLlmMessage(Long.parseLong(item.get("id")), item.get("status"), item.get("result"), item.get("errorCode"), item.get("message"), Boolean.parseBoolean(item.get("stream")), Integer.parseInt(item.get("streamSeqNo")));
        }
    }

    public static void callLlmMessage(long id, String status, String result, String errorCode, String message, boolean stream, int streamSeqNo) {
        LLMSplitMessage llmRawMessage = new LLMSplitMessage();
        llmRawMessage.setId(id);
        llmRawMessage.setStatus(status);
        llmRawMessage.setResult(result);
        llmRawMessage.setErrCode(errorCode);
        llmRawMessage.setErrMsg(message);
        llmRawMessage.setStream(stream);
        llmRawMessage.setStreamSeqNO(streamSeqNo);
        HandlerFactory.callback((ActionCallbackMessage)llmRawMessage);
    }

    public void embeddingNotify(ArrayList<Map<String, String>> list) {
        logger.info("GaiCallBackService({}) embeddingNotify:{}", (Object)RequestContext.get().getTraceId(), (Object)JSON.toJSONString(list));
        for (Map<String, String> item : list) {
            Result2User result2User = new Result2User(item.get("errorCode"), item.get("message"), item.get("id"), item.get("result"));
            EmbeddingHandler.callback((Result2User)result2User);
        }
    }
}

