/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.ai.gai.core.domain.dto.agent.ChatMessageDTO;
import kd.ai.gai.core.domain.dto.agent.ChatSessionDTO;
import kd.ai.gai.core.domain.dto.agent.Message;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.enuz.ChatMessageTypeEnum;
import kd.ai.gai.core.service.agent.ChatService;
import kd.ai.gai.core.service.agent.MessageService;
import kd.ai.gai.core.trace.entity.BaseResult;
import kd.ai.gai.mservice.GaiChatService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;

public class GaiChatServiceImpl
implements GaiChatService {
    private static final Log logger = LogFactory.getLog(GaiChatServiceImpl.class);

    public String getMessageList(String requiredParams, String bizParams) {
        logger.info("getMessageList requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        JSONObject bizParamsJo = JSONObject.parseObject((String)bizParams);
        List chatSessionIdList = bizParamsJo.getJSONArray("chatSessionIdList").toJavaList(String.class);
        Map idMap = ChatService.getSessionIdList((List)chatSessionIdList);
        long startTime = bizParamsJo.getLongValue("startTime");
        JSONObject dataJo = new JSONObject();
        JSONArray listJa = new JSONArray();
        List chatMessageDTOList = ChatService.getChatMessageList(idMap.keySet(), (Date)(startTime > 0L ? new Date(startTime) : null));
        if (CollectionUtils.isNotEmpty((Collection)chatMessageDTOList)) {
            JSONObject listItemJo = null;
            Map<String, List<ChatMessageDTO>> chatMessageDTOMap = chatMessageDTOList.stream().collect(Collectors.groupingBy(ChatMessageDTO::getSessionId));
            for (Map.Entry<String, List<ChatMessageDTO>> item : chatMessageDTOMap.entrySet()) {
                listItemJo = new JSONObject();
                listItemJo.put("chatSessionId", idMap.get(Long.parseLong(item.getKey())));
                listItemJo.put("messageList", item.getValue());
                listJa.add((Object)listItemJo);
            }
            dataJo.put("list", (Object)listJa);
        }
        String result = JSONObject.toJSONString((Object)new BaseResult((Object)dataJo));
        logger.info("getMessageList result:{}", (Object)result);
        return result;
    }

    public String sendMsg(String requiredParams, String bizParams) {
        logger.info("sendMsg requiredParams:{}, bizParams:{}", (Object)requiredParams, (Object)bizParams);
        BaseResult baseResult = new BaseResult(null);
        try {
            JSONObject bizParamsJo = JSONObject.parseObject((String)bizParams);
            String chatSessionId = bizParamsJo.getString("chatSessionId");
            Context context = FlowCacheData.getContext((String)chatSessionId);
            String content = bizParamsJo.getString("content");
            long type = bizParamsJo.getLong("type");
            if (type == ChatMessageTypeEnum.USER.getId()) {
                baseResult = BaseResult.fail((String)"\u6682\u4e0d\u652f\u6301\u53d1\u9001\u7528\u6237\u6d88\u606f");
            } else if (type == ChatMessageTypeEnum.ASSISTANT.getId()) {
                ChatSessionDTO chatSessionDTO = ChatService.getChatSession((String)chatSessionId);
                Message lastUserMessage = MessageService.getLastUserMessage((String)chatSessionId, null);
                Message message = new Message();
                message.setContentTag(content);
                message.setType(Long.valueOf(type));
                message.setSessionId(Long.valueOf(Long.parseLong(chatSessionDTO.getSessionId())));
                message.setRunId(lastUserMessage.getRunId());
                message.setEnable(lastUserMessage.getEnable());
                message.setSkillId(lastUserMessage.getSkillId());
                message.setSkillType(lastUserMessage.getSkillType());
                message.setSkillSrc(lastUserMessage.getSkillSrc());
                message = MessageService.saveMessage((String)chatSessionId, (Message)message);
                ChatService.pushUserOrAssistantMessage((Context)context, (Message)message);
            }
        }
        catch (Exception e) {
            logger.error(String.format("error : %s", e.getMessage()), (Throwable)e);
            baseResult = BaseResult.fail((String)e.getMessage());
        }
        String result = JSONObject.toJSONString((Object)baseResult);
        logger.info("sendMsg result:{}", (Object)result);
        return result;
    }
}

