/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.Map;
import kd.ai.gai.core.api.APIResultHelper;
import kd.ai.gai.core.helper.GptPrivacyHelper;
import kd.ai.gai.core.privacy.PrivacyAgreementService;
import kd.ai.gai.core.privacy.model.PrivacyAgreementType;
import kd.ai.gai.mservice.GaiPrivacyService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class GaiPrivacyServiceImpl
implements GaiPrivacyService {
    private static final Log logger = LogFactory.getLog(GaiPrivacyServiceImpl.class);

    public boolean isUserAgree() {
        logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u9690\u79c1\u534f\u8bae,\u7528\u6237\u7b7e\u7f72\u72b6\u6001\u67e5\u8be2-\u5f00\u59cb");
        boolean userAgree = GptPrivacyHelper.isUserAgree((Long)RequestContext.get().getCurrUserId());
        logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u9690\u79c1\u534f\u8bae,\u7528\u6237\u7b7e\u7f72\u72b6\u6001\u67e5\u8be2 \u7ed3\u679c\uff1a{} -\u7ed3\u675f", (Object)userAgree);
        return userAgree;
    }

    public boolean isTenantAgree() {
        logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u9690\u79c1\u534f\u8bae,\u79df\u6237\u7b7e\u7f72\u72b6\u6001\u67e5\u8be2-\u5f00\u59cb");
        boolean tenantAgree = GptPrivacyHelper.isTenantAgree((String)RequestContext.get().getTenantId());
        logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u9690\u79c1\u534f\u8bae,\u79df\u6237\u7b7e\u7f72\u72b6\u6001\u67e5\u8be2 \u7ed3\u679c\uff1a{} -\u7ed3\u675f", (Object)tenantAgree);
        return tenantAgree;
    }

    public boolean signPrivacyAgreement(String sAgreementType, boolean bSignOrUnSign) {
        logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u9690\u79c1\u534f\u8bae\u670d\u52a1\uff1a\u7b7e\u7f72\u534f\u8bae\u63a5\u53e3 - \u5f00\u59cb");
        PrivacyAgreementType agreementType = PrivacyAgreementType.valueOf((String)sAgreementType);
        logger.info("\u5f85\u7b7e\u7f72\u670d\u52a1\u534f\u8bae\u7c7b\u578b\u662f: " + agreementType.getName());
        String tenantId = RequestContext.get().getTenantId();
        long userId = RequestContext.get().getCurrUserId();
        boolean bResult = agreementType == PrivacyAgreementType.TENANT_PRIVACY_AGREEMENT ? PrivacyAgreementService.signTenantPrivacyAgreement((String)tenantId, (long)userId, (boolean)bSignOrUnSign) : PrivacyAgreementService.signUserPrivacyPolicy((long)userId, (boolean)bSignOrUnSign);
        logger.info("\u7b7e\u7f72\u7ed3\u679c" + (bResult ? "\u6210\u529f" : "\u5931\u8d25"));
        logger.info("\u3010GPT-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u9690\u79c1\u534f\u8bae\u670d\u52a1\uff1a\u7b7e\u7f72\u534f\u8bae\u63a5\u53e3 - \u7ed3\u675f");
        return bResult;
    }

    public String getTenantPrivacyAgreeRecords() {
        String traceId = RequestContext.get().getTraceId();
        try {
            List recordList = PrivacyAgreementService.getTenantPrivacyAgreeRecords();
            Map mapResult = APIResultHelper.buildOk((String)traceId, (Object)recordList);
            return JSON.toJSONString((Object)mapResult);
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            Map mapResult = APIResultHelper.buildErr((String)traceId, (ErrorCode)ex.getErrorCode());
            return JSON.toJSONString((Object)mapResult);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            String sMessage = ex.getMessage();
            if (StringUtils.isEmpty((CharSequence)sMessage)) {
                sMessage = ex.toString();
            }
            Map mapResult = APIResultHelper.buildErr((String)traceId, (ErrorCode)new ErrorCode("1", sMessage));
            return JSON.toJSONString((Object)mapResult);
        }
    }

    public String getUserPolicyAgreeRecords(long userId) {
        String traceId = RequestContext.get().getTraceId();
        try {
            List recordList = PrivacyAgreementService.getUserPolicyAgreeRecords((long)userId);
            Map mapResult = APIResultHelper.buildOk((String)traceId, (Object)recordList);
            return JSON.toJSONString((Object)mapResult);
        }
        catch (KDException ex) {
            logger.error((Throwable)ex);
            Map mapResult = APIResultHelper.buildErr((String)traceId, (ErrorCode)ex.getErrorCode());
            return JSON.toJSONString((Object)mapResult);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            String sMessage = ex.getMessage();
            if (StringUtils.isEmpty((CharSequence)sMessage)) {
                sMessage = ex.toString();
            }
            Map mapResult = APIResultHelper.buildErr((String)traceId, (ErrorCode)new ErrorCode("1", sMessage));
            return JSON.toJSONString((Object)mapResult);
        }
    }
}

