/*
 * Decompiled with CFR 0.152.
 */
package kd.ai.gai.mservice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.ai.gai.core.api.mservice.MserviceResultHelper;
import kd.ai.gai.core.code.GaiErrorCode;
import kd.ai.gai.core.code.GaiExceptionUtil;
import kd.ai.gai.core.engine.Context;
import kd.ai.gai.core.engine.FlowCacheData;
import kd.ai.gai.core.engine.HandlerFactory;
import kd.ai.gai.core.engine.Message;
import kd.ai.gai.core.engine.Result;
import kd.ai.gai.core.engine.json.JsonUtil;
import kd.ai.gai.core.engine.message.LLMMessage;
import kd.ai.gai.core.engine.message.llmcallback.LLMParsedMessage;
import kd.ai.gai.core.engine.message.llmcallback.MserviceLLMCallbackMessage;
import kd.ai.gai.core.enuz.SLIDEENV;
import kd.ai.gai.core.helper.GPTLicenseHelper;
import kd.ai.gai.mservice.GaiPromptService;
import kd.ai.gai.pojo.GaiPrompUseRepoParams;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GaiPromptServiceImpl
implements GaiPromptService {
    private static final Log logger = LogFactory.getLog(GaiPromptServiceImpl.class);

    public Map<String, Object> asyncCall(Map<String, String> callBackInfo, boolean isStream, long promptId, String input, Map<String, String> varParams) {
        Map resp;
        Context context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (long)0L, null, null, null, null);
        String requestId = context.getChatSessionId();
        logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528-\u5f00\u59cb\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s", requestId, promptId));
        try {
            FlowCacheData.putContext((String)requestId, (Context)context);
            resp = this.call(callBackInfo, context, isStream, promptId, input, varParams, false);
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528-\u7ed3\u675f\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a%s", requestId, promptId, JSON.toJSONString((Object)resp)));
        }
        catch (Exception e) {
            ErrorCode errorCode;
            resp = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)((Object)e)).getErrorCode()) ? MserviceResultHelper.buildErr((String)requestId, (ErrorCode)errorCode) : MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_ASYNC_ERROR)) : MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_ASYNC_ERROR);
            logger.error(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528-\u5f02\u5e38\uff0cchatSessionId\uff08requestId\uff09,PromptID\uff1a%s,errMsg\uff1a%s", requestId, promptId, JSON.toJSONString((Object)resp)), (Throwable)e);
        }
        return resp;
    }

    public Map<String, Object> asyncCallUseHistoryMsg(Map<String, String> callBackInfo, String chatSessionId, boolean isStream, long promptId, String input, Map<String, String> varParams) {
        Map resp;
        try {
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb,chatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s", chatSessionId, promptId));
            if (StringUtils.isBlank((CharSequence)chatSessionId)) {
                throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.MESSAGE_CHAT_SESSION_ERROR), new Object[0]);
            }
            Context context = FlowCacheData.getContext((String)chatSessionId);
            if (Objects.isNull(context)) {
                context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (String)chatSessionId, null, (long)0L, null, null, null);
                FlowCacheData.putContext((String)chatSessionId, (Context)context);
                logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb\uff0c\u7b2c\u4e00\u6b21\u4f1a\u8bdd\uff0c\u6784\u5efa Context\uff1a%s", JSON.toJSONString((Object)context)));
            }
            resp = this.call(callBackInfo, context, isStream, promptId, input, varParams, false);
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u7ed3\u675f\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s\uff0c\u54cd\u5e94\u7ed3\u679c\uff1a%s", chatSessionId, promptId, JSON.toJSONString(resp)));
        }
        catch (Exception e) {
            ErrorCode errorCode;
            resp = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)((Object)e)).getErrorCode()) ? MserviceResultHelper.buildErr((String)chatSessionId, (ErrorCode)errorCode) : MserviceResultHelper.buildErr((String)chatSessionId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_ASYNC_ERROR)) : MserviceResultHelper.buildErr((String)chatSessionId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_ASYNC_ERROR);
            logger.error(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528-\u5f02\u5e38(\u542b\u5bf9\u8bdd\u5386\u53f2)\uff0cchatSessionId\uff08requestId\uff09:%s,PromptID\uff1a%s,errMsg\uff1a%s", chatSessionId, promptId, JSON.toJSONString((Object)resp)), (Throwable)e);
        }
        return resp;
    }

    public Map<String, Object> asyncCallUseDynamicRepo(Map<String, String> callBackInfo, String paramsJson) {
        Map resp;
        logger.info(String.format("\u3010GPT\u63d0\u793a-\u52a8\u6001\u4f7f\u7528\u77e5\u8bc6\u5e93-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb\uff0ccallback:%s , params: %s", SerializationUtils.toJsonString(callBackInfo), paramsJson));
        String chatSessionId = null;
        try {
            if (StringUtils.isBlank((CharSequence)paramsJson)) {
                GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_PROMPT_REPO_ERR);
            }
            GaiPrompUseRepoParams params = (GaiPrompUseRepoParams)SerializationUtils.fromJsonString((String)paramsJson, GaiPrompUseRepoParams.class);
            long promptId = params.getPromptId();
            chatSessionId = params.getChatSessionId();
            if (StringUtils.isBlank((CharSequence)chatSessionId)) {
                throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.MESSAGE_CHAT_SESSION_ERROR), new Object[0]);
            }
            Context context = FlowCacheData.getContext((String)chatSessionId);
            if (Objects.isNull(context)) {
                context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (String)chatSessionId, null, (long)0L, null, null, null);
                FlowCacheData.putContext((String)chatSessionId, (Context)context);
                logger.info(String.format("\u3010GPT\u63d0\u793a-\u52a8\u6001\u4f7f\u7528\u77e5\u8bc6\u5e93-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb\uff0c\u7b2c\u4e00\u6b21\u4f1a\u8bdd\uff0c\u6784\u5efa Context\uff1a%s", JSON.toJSONString((Object)context)));
            }
            resp = this.callUseDynamicRepo(callBackInfo, context, params, false);
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u52a8\u6001\u4f7f\u7528\u77e5\u8bc6\u5e93-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u7ed3\u675f\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s,\u54cd\u5e94\u7ed3\u679c\uff1a%s", chatSessionId, promptId, JSON.toJSONString(resp)));
        }
        catch (Exception e) {
            ErrorCode errorCode;
            if (chatSessionId == null) {
                chatSessionId = MserviceResultHelper.buildRequestId();
            }
            resp = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)((Object)e)).getErrorCode()) ? MserviceResultHelper.buildErr((String)chatSessionId, (ErrorCode)errorCode) : MserviceResultHelper.buildErr((String)chatSessionId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_SYNC_ERROR)) : MserviceResultHelper.buildErr((String)chatSessionId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_SYNC_ERROR);
            logger.error(String.format("\u3010GPT\u63d0\u793a-\u52a8\u6001\u4f7f\u7528\u77e5\u8bc6\u5e93-\u5fae\u670d\u52a1\u3011\u5f02\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f02\u5e38\uff0cerrMsg\uff1a%s", JSON.toJSONString((Object)resp)), (Throwable)e);
        }
        return resp;
    }

    public Map<String, Object> syncCall(long promptId, String input, Map<String, String> varParams) {
        Map resp;
        Context context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (long)0L, null, null, null, null);
        String requestId = context.getChatSessionId();
        try {
            FlowCacheData.putContext((String)requestId, (Context)context);
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528-\u5f00\u59cb\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s", requestId, promptId));
            resp = this.call(null, context, false, promptId, input, varParams, true);
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528-\u7ed3\u675f\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s,\u54cd\u5e94\u7ed3\u679c\uff1a%s", requestId, promptId, JSON.toJSONString(resp)));
        }
        catch (Exception e) {
            ErrorCode errorCode;
            resp = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)((Object)e)).getErrorCode()) ? MserviceResultHelper.buildErr((String)requestId, (ErrorCode)errorCode) : MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_SYNC_ERROR)) : MserviceResultHelper.buildErr((String)requestId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_SYNC_ERROR);
            logger.error(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528-\u5f02\u5e38\uff0crequestId:%s,PromptID\uff1a%s,errMsg\uff1a%s", requestId, promptId, JSON.toJSONString((Object)resp)), (Throwable)e);
        }
        return resp;
    }

    public Map<String, Object> syncCallUseHistoryMsg(String chatSessionId, long promptId, String input, Map<String, String> varParams) {
        Map resp;
        try {
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s", chatSessionId, promptId));
            if (StringUtils.isBlank((CharSequence)chatSessionId)) {
                throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.MESSAGE_CHAT_SESSION_ERROR), new Object[0]);
            }
            Context context = FlowCacheData.getContext((String)chatSessionId);
            if (Objects.isNull(context)) {
                context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (String)chatSessionId, null, (long)0L, null, null, null);
                FlowCacheData.putContext((String)chatSessionId, (Context)context);
                logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb\uff0c\u7b2c\u4e00\u6b21\u4f1a\u8bdd\uff0c\u6784\u5efa Context\uff1a%s", JSON.toJSONString((Object)context)));
            }
            resp = this.call(null, context, false, promptId, input, varParams, true);
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u7ed3\u675f\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s,\u54cd\u5e94\u7ed3\u679c\uff1a%s", chatSessionId, promptId, JSON.toJSONString(resp)));
        }
        catch (Exception e) {
            ErrorCode errorCode;
            resp = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)((Object)e)).getErrorCode()) ? MserviceResultHelper.buildErr((String)chatSessionId, (ErrorCode)errorCode) : MserviceResultHelper.buildErr((String)chatSessionId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_SYNC_ERROR)) : MserviceResultHelper.buildErr((String)chatSessionId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_SYNC_ERROR);
            logger.error(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f02\u5e38\uff0crequestId:%s,PromptID\uff1a%s,errMsg\uff1a%s", chatSessionId, promptId, JSON.toJSONString((Object)resp)), (Throwable)e);
        }
        return resp;
    }

    public Map<String, Object> syncCallUseDynamicRepo(String paramsJson) {
        Map resp;
        logger.info(String.format("\u3010GPT\u63d0\u793a-\u52a8\u6001\u4f7f\u7528\u77e5\u8bc6\u5e93-\u5fae\u670d\u52a1\u670d\u52a1\u3011 \u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb, params: %s", paramsJson));
        String chatSessionId = null;
        try {
            if (StringUtils.isBlank((CharSequence)paramsJson)) {
                GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_PROMPT_REPO_ERR);
            }
            GaiPrompUseRepoParams params = (GaiPrompUseRepoParams)SerializationUtils.fromJsonString((String)paramsJson, GaiPrompUseRepoParams.class);
            chatSessionId = params.getChatSessionId();
            long promptId = params.getPromptId();
            if (StringUtils.isBlank((CharSequence)chatSessionId)) {
                throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.MESSAGE_CHAT_SESSION_ERROR), new Object[0]);
            }
            Context context = FlowCacheData.getContext((String)chatSessionId);
            if (Objects.isNull(context)) {
                context = Context.create((SLIDEENV)SLIDEENV.API_MSERVICE, (String)chatSessionId, null, (long)0L, null, null, null);
                FlowCacheData.putContext((String)chatSessionId, (Context)context);
                logger.info(String.format("\u3010GPT\u63d0\u793a-\u52a8\u6001\u4f7f\u7528\u77e5\u8bc6\u5e93-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f00\u59cb\uff0c\u7b2c\u4e00\u6b21\u4f1a\u8bdd\uff0c\u6784\u5efa Context\uff1a%s", JSON.toJSONString((Object)context)));
            }
            resp = this.callUseDynamicRepo(null, context, params, true);
            logger.info(String.format("\u3010GPT\u63d0\u793a-\u52a8\u6001\u4f7f\u7528\u77e5\u8bc6\u5e93-\u5fae\u670d\u52a1\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u7ed3\u675f\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s,\u54cd\u5e94\u7ed3\u679c\uff1a%s", chatSessionId, promptId, JSON.toJSONString(resp)));
        }
        catch (Exception e) {
            ErrorCode errorCode;
            if (chatSessionId == null) {
                chatSessionId = MserviceResultHelper.buildRequestId();
            }
            resp = e instanceof KDBizException ? (Objects.nonNull(errorCode = ((KDBizException)((Object)e)).getErrorCode()) ? MserviceResultHelper.buildErr((String)chatSessionId, (ErrorCode)errorCode) : MserviceResultHelper.buildErr((String)chatSessionId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_SYNC_ERROR)) : MserviceResultHelper.buildErr((String)chatSessionId, (GaiErrorCode)GaiErrorCode.PROMPT_MS_SYNC_ERROR);
            logger.error(String.format("\u3010GPT\u63d0\u793a-\u52a8\u6001\u4f7f\u7528\u77e5\u8bc6\u5e93-\u5fae\u670d\u52a1\u3011\u540c\u6b65\u8c03\u7528(\u542b\u5bf9\u8bdd\u5386\u53f2)-\u5f02\u5e38\uff0cerrMsg\uff1a%s", JSON.toJSONString((Object)resp)), (Throwable)e);
        }
        return resp;
    }

    public String updatePrompt(String requiredParamsStr, String bizParamsStr) {
        logger.info("\u3010GPT\u63d0\u793a-update-\u5fae\u670d\u52a1\u670d\u52a1\u3011-\u5f00\u59cb, requiredParamsStr:{},bizParamsStr:{}", (Object)requiredParamsStr, (Object)bizParamsStr);
        try {
            if (StringUtils.isBlank((CharSequence)requiredParamsStr)) {
                throw new KDBizException(new ErrorCode(GaiErrorCode.PRAMPT_MS_CALl_ERROR.getCode(), String.format(GaiErrorCode.PRAMPT_MS_CALl_ERROR.getMsg(), "\u5165\u53c2\uff1arequiredParamsStr")), new Object[0]);
            }
            if (StringUtils.isBlank((CharSequence)bizParamsStr)) {
                throw new KDBizException(new ErrorCode(GaiErrorCode.PRAMPT_MS_CALl_ERROR.getCode(), String.format(GaiErrorCode.PRAMPT_MS_CALl_ERROR.getMsg(), "\u5165\u53c2\uff1abizParamsStr")), new Object[0]);
            }
            JSONObject bizParamsJs = JSON.parseObject((String)bizParamsStr);
            String promptIdStr = bizParamsJs.getString("promptId");
            String llmNumber = bizParamsJs.getString("llmNumber");
            long promptId = Long.parseLong(promptIdStr);
            DynamicObject prompt = BusinessDataServiceHelper.loadSingle((Object)promptId, (String)"gai_prompt");
            if (prompt == null) {
                throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.PRAMPT_NO_EXIET_ERROR), new Object[0]);
            }
            GPTLicenseHelper.checkLic((String)"gai_prompt", (Long)promptId);
            prompt.set("language_model", (Object)llmNumber);
            SaveServiceHelper.update((DynamicObject)prompt);
            HashMap<String, Object> resp = new HashMap<String, Object>(5);
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("promptId", promptIdStr);
            data.put("llmNumber", llmNumber);
            resp.put("errCode", GaiErrorCode.OK.getCode());
            resp.put("errMsg", GaiErrorCode.OK.getMsg());
            resp.put("status", true);
            resp.put("data", data);
            return JsonUtil.toJson(resp);
        }
        catch (Exception e) {
            ErrorCode errorCode;
            if (e instanceof KDBizException && Objects.nonNull(errorCode = ((KDBizException)((Object)e)).getErrorCode())) {
                return JsonUtil.toJson((Object)MserviceResultHelper.buildErr((ErrorCode)errorCode));
            }
            logger.error(String.format("\u3010GPT\u63d0\u793a-update-\u5fae\u670d\u52a1\u3011-\u5f02\u5e38\uff0cerrMsg\uff1a%s", e.getMessage()), (Throwable)e);
            return JsonUtil.toJson((Object)MserviceResultHelper.buildErr((ErrorCode)new ErrorCode(GaiErrorCode.PRAMPT_MS_CALl_ERROR.getCode(), String.format(GaiErrorCode.PRAMPT_MS_CALl_ERROR.getMsg(), e.getMessage()))));
        }
    }

    public void syncCenterService(String languageModel) {
        logger.info("\u3010GPT\u63d0\u793a-update-\u52a9\u624b\u4e2d\u63a7\u9884\u5236\u6a21\u578b\u3011-\u5f00\u59cb, languagemodel:{}", (Object)languageModel);
        String getAssistantPrompt = "select fprompt from t_gai_assistant_config where fid = 10000";
        long prompt = (Long)DB.query((DBRoute)DBRoute.of((String)"aidb"), (String)getAssistantPrompt, resultSet -> {
            resultSet.next();
            return resultSet.getLong(1);
        });
        logger.info(String.valueOf(prompt));
        String updateLanguageModelSql = "update t_gai_prompt set flanguagemodel=? where fid = ?";
        DB.update((DBRoute)DBRoute.of((String)"aidb"), (String)updateLanguageModelSql, (Object[])new Object[]{languageModel, prompt});
        logger.info("\u3010GPT\u63d0\u793a-update-\u52a9\u624b\u4e2d\u63a7\u9884\u5236\u6a21\u578b\u3011-\u5b8c\u6210, languagemodel:{}", (Object)languageModel);
    }

    private Map<String, Object> call(Map<String, String> callBackInfo, Context context, boolean isStream, long promptId, String input, Map<String, String> varParams, boolean sync) {
        return this.call(callBackInfo, context, isStream, promptId, input, varParams, sync, Collections.emptyList());
    }

    private Map<String, Object> callUseDynamicRepo(Map<String, String> callBackInfo, Context context, GaiPrompUseRepoParams params, boolean sync) {
        long promptId = params.getPromptId();
        String input = params.getInput();
        boolean stream = params.isStream();
        List<Long> repoIds = params.getRepoIds();
        Map<String, String> varParams = params.getVarParams();
        if (repoIds == null || repoIds.isEmpty()) {
            GaiExceptionUtil.throwGaiException((GaiErrorCode)GaiErrorCode.RAG_PROMPT_REPO_ERR);
        }
        return this.call(callBackInfo, context, stream, promptId, input, varParams, sync, repoIds);
    }

    private Map<String, Object> call(Map<String, String> callBackInfo, Context context, boolean isStream, long promptId, String input, Map<String, String> varParams, boolean sync, List<Long> repoIds) {
        String requestId = context.getChatSessionId();
        DynamicObject promptInfo = BusinessDataServiceHelper.loadSingle((Object)promptId, (String)"gai_prompt");
        if (Objects.isNull(promptInfo)) {
            throw new KDBizException(GaiExceptionUtil.buildErr((GaiErrorCode)GaiErrorCode.NO_PROMPT), new Object[0]);
        }
        LLMMessage llmMessage = new LLMMessage();
        llmMessage.setUserInput(input);
        llmMessage.setPromptId(promptId);
        llmMessage.setRepoIdList(repoIds);
        llmMessage.setStream(isStream);
        llmMessage.setParamMap(varParams);
        llmMessage.setSync(sync);
        if (!sync) {
            this.buildCallBackMessage(callBackInfo, llmMessage);
        }
        Result result = HandlerFactory.runHandler((Context)context, (Message)llmMessage);
        logger.info(String.format("\u3010GPT\u63d0\u793a-\u5fae\u670d\u52a1\u670d\u52a1\u3011%s\u8c03\u7528-\u7ed3\u675f\uff0cchatSessionId\uff08requestId\uff09:%s \uff0cPromptID\uff1a%s,llm\u7ed3\u679c\uff1a%s", sync ? "\u540c\u6b65" : "\u5f02\u6b65", requestId, promptId, JSON.toJSONString((Object)result)));
        return MserviceResultHelper.build((String)requestId, (Result)result);
    }

    private void buildCallBackMessage(Map<String, String> callBackInfo, LLMMessage llmMessage) {
        MserviceLLMCallbackMessage callbackMessage = new MserviceLLMCallbackMessage();
        callbackMessage.setCloudId(callBackInfo.get("cloudId"));
        callbackMessage.setAppId(callBackInfo.get("appId"));
        callbackMessage.setServiceName(callBackInfo.get("serviceName"));
        callbackMessage.setMethodName(callBackInfo.get("methodName"));
        callbackMessage.setFactoryQualifiedPrefix(callBackInfo.get("factoryQualifiedPrefix"));
        llmMessage.setCallbackMessage((LLMParsedMessage)callbackMessage);
    }
}

